/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ui.wizards;

import eu.geclipse.aws.auth.AWSAuthTokenDescription;
import eu.geclipse.aws.ui.Messages;
import eu.geclipse.aws.ui.internal.Activator;
import eu.geclipse.aws.ui.wizards.AWSAuthTokenWizard;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.auth.PasswordManager;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.wizards.VoSelectionWizardPage;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AWSAuthTokenWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "eu.geclipse.aws.ui.awsAuthTokenWizardPage";
    private Text accessIdText;
    private Text secretIdText;
    private AWSAuthTokenDescription awsAuthTokenDesc;
    private AWSAuthTokenWizard authTokenWizard;

    protected AWSAuthTokenWizardPage(AWSAuthTokenWizard authTokenWizard, AWSAuthTokenDescription awsAuthTokenDesc) {
        super(WIZARD_PAGE_ID, Messages.getString("AWSAuthTokenWizardPage.wizard_page_title"), null);
        this.awsAuthTokenDesc = awsAuthTokenDesc;
        this.authTokenWizard = authTokenWizard;
        this.setDescription(Messages.getString("AWSAuthTokenWizardPage.wizard_page_description"));
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/credentials_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.authTokenWizard.setCanFinish(true);
        if (visible) {
            this.initPage();
        }
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        Group credentialsGroup = new Group(mainComp, 0);
        credentialsGroup.setLayout((Layout)new GridLayout(2, false));
        credentialsGroup.setText(Messages.getString("AWSAuthTokenWizardPage.group_credentials_title"));
        GridData gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        credentialsGroup.setLayoutData((Object)gData);
        Label accessIdLabel = new Label((Composite)credentialsGroup, 16384);
        accessIdLabel.setText(Messages.getString("AWSAuthTokenWizardPage.label_access_id"));
        gData = new GridData();
        accessIdLabel.setLayoutData((Object)gData);
        this.accessIdText = new Text((Composite)credentialsGroup, 18444);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.accessIdText.setLayoutData((Object)gData);
        Label secretIdLabel = new Label((Composite)credentialsGroup, 16384);
        secretIdLabel.setText(Messages.getString("AWSAuthTokenWizardPage.label_secret_id"));
        gData = new GridData();
        secretIdLabel.setLayoutData((Object)gData);
        this.secretIdText = new Text((Composite)credentialsGroup, 0x404804);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.secretIdText.setLayoutData((Object)gData);
        this.setControl((Control)mainComp);
    }

    private void initPage() {
        block10: {
            String emptyString = "";
            this.accessIdText.setText(emptyString);
            this.secretIdText.setText(emptyString);
            if (this.awsAuthTokenDesc != null) {
                String awsAccessId = this.awsAuthTokenDesc.getAwsAccessId();
                if (awsAccessId != null) {
                    String awsSecretId = PasswordManager.getPassword((String)("/eu/geclipse/aws/" + awsAccessId));
                    this.accessIdText.setText(awsAccessId);
                    if (awsSecretId != null) {
                        this.secretIdText.setText(awsSecretId);
                    } else {
                        this.secretIdText.setFocus();
                    }
                }
            } else {
                IVirtualOrganization[] selectedVos = this.getVoSelectionPage().getSelectedVos();
                if (selectedVos[0] != null) {
                    AWSVirtualOrganization awsVo = (AWSVirtualOrganization)selectedVos[0];
                    try {
                        String awsAccessId = awsVo.getProperties().getAwsAccessId();
                        this.accessIdText.setText(awsAccessId);
                        String awsSecretId = PasswordManager.getPassword((String)("/eu/geclipse/aws/" + awsAccessId));
                        if (awsSecretId != null) {
                            this.secretIdText.setText(awsSecretId);
                            break block10;
                        }
                        this.secretIdText.setFocus();
                    }
                    catch (ProblemException problemEx) {
                        Activator.log("Could not extract aws access id from aws vo properties", (Exception)((Object)problemEx));
                    }
                } else {
                    this.accessIdText.setEnabled(true);
                    this.accessIdText.setFocus();
                }
            }
        }
    }

    public AWSAuthTokenDescription getTokenDescription() {
        String accessId = this.accessIdText.getText().trim();
        String secretId = this.secretIdText.getText().trim();
        AWSVirtualOrganization awsVo = null;
        if (this.awsAuthTokenDesc == null || this.awsAuthTokenDesc.getAwsVo() == null) {
            IVirtualOrganization[] selectedVos;
            IVirtualOrganization[] iVirtualOrganizationArray = selectedVos = this.getVoSelectionPage().getSelectedVos();
            int n = selectedVos.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualOrganization virtualOrganization = iVirtualOrganizationArray[n2];
                awsVo = (AWSVirtualOrganization)virtualOrganization;
                ++n2;
            }
        } else {
            awsVo = this.awsAuthTokenDesc.getAwsVo();
        }
        AWSAuthTokenDescription authTokenDesc = new AWSAuthTokenDescription(awsVo);
        PasswordManager.registerPassword((String)("/eu/geclipse/aws/" + accessId), (String)secretId);
        return authTokenDesc;
    }

    public boolean isValid() {
        String error = null;
        if (this.accessIdText.getText().trim().length() == 0) {
            error = Messages.getString("AWSAuthTokenWizardPage.form_error_access_id_required");
        }
        if (this.secretIdText.getText().trim().length() == 0) {
            error = Messages.getString("AWSAuthTokenWizardPage.form_error_secret_id_required");
        }
        if (error != null) {
            this.setErrorMessage(error);
            this.authTokenWizard.setCanFinish(false);
            this.getWizard().getContainer().updateButtons();
            return false;
        }
        this.setErrorMessage(null);
        this.authTokenWizard.setCanFinish(true);
        this.getWizard().getContainer().updateButtons();
        return true;
    }

    private VoSelectionWizardPage getVoSelectionPage() {
        IWizardPage page = this.getPreviousPage();
        while (page != null && !(page instanceof VoSelectionWizardPage)) {
            page = page.getPreviousPage();
        }
        return (VoSelectionWizardPage)page;
    }

    public void registerFormListener() {
        this.accessIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AWSAuthTokenWizardPage.this.isValid();
            }
        });
        this.secretIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AWSAuthTokenWizardPage.this.isValid();
            }
        });
    }
}

