/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.ui.wizards;

import eu.geclipse.aws.IAWSService;
import eu.geclipse.aws.ui.Messages;
import eu.geclipse.aws.ui.internal.Activator;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.aws.vo.AWSVoCreator;
import eu.geclipse.aws.vo.AWSVoProperties;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IVoManager;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class AWSVoWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "eu.geclipse.aws.ui.awsVoWizardPage";
    private Text voNameText;
    private Text awsAccessIdText;
    private AWSVirtualOrganization initialVo;
    private Table tableServices;
    private List<IConfigurationElement> configurationElements;

    protected AWSVoWizardPage() {
        super(WIZARD_PAGE_ID, Messages.getString("AWSVoWizardPage.page_title"), null);
        this.setDescription(Messages.getString("AWSVoWizardPage.page_description"));
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/wizban/vomsvo_wiz.gif");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        Group settingsGroup = new Group(mainComp, 0);
        settingsGroup.setLayout((Layout)new GridLayout(2, false));
        settingsGroup.setText(Messages.getString("AWSVoWizardPage.label_vo_settings"));
        GridData gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        settingsGroup.setLayoutData((Object)gData);
        Label nameLabel = new Label((Composite)settingsGroup, 16384);
        nameLabel.setText(Messages.getString("AWSVoWizardPage.label_vo_name"));
        nameLabel.setLayoutData((Object)new GridData());
        this.voNameText = new Text((Composite)settingsGroup, 18436);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.voNameText.setLayoutData((Object)gData);
        this.voNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AWSVoWizardPage.this.validateInput();
            }
        });
        Label awsAccessIdLabel = new Label((Composite)settingsGroup, 16384);
        awsAccessIdLabel.setText(Messages.getString("AWSVoWizardPage.label_aws_access_id"));
        awsAccessIdLabel.setLayoutData((Object)new GridData());
        this.awsAccessIdText = new Text((Composite)settingsGroup, 18436);
        gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.awsAccessIdText.setLayoutData((Object)gData);
        this.awsAccessIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AWSVoWizardPage.this.validateInput();
            }
        });
        Group servicesGroup = new Group(mainComp, 0);
        servicesGroup.setLayout((Layout)new GridLayout(2, false));
        servicesGroup.setText(Messages.getString("AWSVoWizardPage.group_title_services"));
        gData = new GridData(4, 4, true, true);
        gData.grabExcessVerticalSpace = true;
        servicesGroup.setLayoutData((Object)gData);
        this.tableServices = new Table((Composite)servicesGroup, 68356);
        this.tableServices.setLinesVisible(true);
        this.tableServices.setHeaderVisible(true);
        gData = new GridData(4, 4, true, true);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        this.tableServices.setLayoutData((Object)gData);
        TableColumn tableColumnService = new TableColumn(this.tableServices, 0);
        tableColumnService.setText(Messages.getString("AWSVoWizardPage.table_services_column_service_title"));
        tableColumnService.setWidth(200);
        TableColumn tableColumnUrl = new TableColumn(this.tableServices, 0);
        tableColumnUrl.setText(Messages.getString("AWSVoWizardPage.table_services_column_url_title"));
        tableColumnUrl.setWidth(150);
        this.setControl((Control)mainComp);
        if (this.initialVo != null) {
            try {
                AWSVoProperties properties = this.initialVo.getProperties();
                if (properties != null) {
                    this.voNameText.setText(this.initialVo.getName());
                    this.voNameText.setEnabled(false);
                    this.awsAccessIdText.setText(properties.getAwsAccessId());
                }
            }
            catch (ProblemException problemEx) {
                Activator.log("Could not load properties from initial AWS Vo", (Exception)((Object)problemEx));
            }
        } else {
            this.voNameText.setEnabled(true);
        }
        try {
            this.populateServiceTable(this.initialVo);
            tableColumnUrl.pack();
            tableColumnService.pack();
        }
        catch (InvalidRegistryObjectException invalidRegObjEx) {
            Activator.log("Could not populate services table", (Exception)((Object)invalidRegObjEx));
        }
        catch (ProblemException problemEx) {
            Activator.log("Could not populate services table from stored definitons", (Exception)((Object)problemEx));
        }
    }

    private void populateServiceTable(AWSVirtualOrganization awsVo) throws InvalidRegistryObjectException, ProblemException {
        if (awsVo == null) {
            this.configurationElements = GridModel.getCreatorRegistry().getConfigurations(null, IAWSService.class);
            String url = null;
            for (IConfigurationElement element : this.configurationElements) {
                IConfigurationElement[] sourceChildern;
                String name = element.getAttribute("name");
                IConfigurationElement[] iConfigurationElementArray = sourceChildern = element.getChildren("source");
                int n = sourceChildern.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement sourceElement = iConfigurationElementArray[n2];
                    String defaultSource = sourceElement.getAttribute("default");
                    boolean isDefaultSource = Boolean.parseBoolean(defaultSource);
                    if (isDefaultSource) {
                        url = sourceElement.getAttribute("pattern");
                    }
                    ++n2;
                }
                TableItem tableItem = new TableItem(this.tableServices, 0);
                tableItem.setData((Object)element);
                tableItem.setText(new String[]{name, url});
            }
        } else {
            List awsServices = awsVo.getChildren((IProgressMonitor)new NullProgressMonitor(), IAWSService.class);
            for (IAWSService service : awsServices) {
                TableItem tableItem = new TableItem(this.tableServices, 0);
                tableItem.setData((Object)service);
                tableItem.setText(new String[]{service.getName(), service.getHostName()});
            }
        }
    }

    protected void validateInput() {
        String name = this.voNameText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(Messages.getString("AWSVoWizardPage.error_vo_name_required"));
            this.setPageComplete(false);
        } else if (this.initialVo == null && GridModel.getVoManager().findChild(name) != null) {
            this.setErrorMessage(Messages.getString("AWSVoWizardPage.error_vo_already_exists"));
            this.setPageComplete(false);
        } else if (this.awsAccessIdText.getText().trim().length() == 0) {
            this.setErrorMessage(Messages.getString("AWSVoWizardPage.error_acces_id_required"));
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public void setInitialVo(AWSVirtualOrganization initialVo) {
        this.initialVo = initialVo;
    }

    protected boolean createVo() {
        AWSVoCreator voCreator = new AWSVoCreator();
        voCreator.setVoName(this.voNameText.getText().trim());
        voCreator.setAwsAccessId(this.awsAccessIdText.getText().trim());
        IVoManager voManager = GridModel.getVoManager();
        AWSVirtualOrganization awsVo = null;
        if (this.initialVo == null) {
            try {
                awsVo = (AWSVirtualOrganization)voManager.create((IGridElementCreator)voCreator);
            }
            catch (ProblemException problemEx) {
                Activator.log("Could not create AWSVo with provided AWSVoCreator via VOManager", (Exception)((Object)problemEx));
                try {
                    voManager.delete((IGridElement)awsVo);
                }
                catch (ProblemException problemExDel) {
                    ProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("AWSVoWizardPage.error_dialog_title"), (String)Messages.getString("AWSVoWizardPage.error_dialog_description"), (Throwable)problemExDel);
                    Activator.log("Could not delete rudimentary AWSVo", (Exception)((Object)problemEx));
                }
                return false;
            }
        }
        voCreator.apply(this.initialVo);
        return true;
    }
}

