/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.auth;

import eu.geclipse.aws.auth.AWSAuthToken;
import eu.geclipse.aws.internal.Activator;
import eu.geclipse.aws.internal.Messages;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.core.auth.AuthenticationException;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.auth.IAuthenticationTokenDescription;
import eu.geclipse.core.auth.PasswordManager;
import eu.geclipse.core.reporting.ProblemException;

public class AWSAuthTokenDescription
implements IAuthenticationTokenDescription {
    public static final String SECURE_STORAGE_NODE = "/eu/geclipse/aws/";
    private static final String TOKEN_TYPE_NAME = Messages.getString("AWSAuthTokenDescription.token_type_name");
    private static final String WIZARD_ID = "eu.geclipse.aws.ui.wizards.awsAuthTokenWizard";
    private static final String PROBLEM_CHECK_VO_SETTINGS_ID = "eu.geclipse.core.solution.auth.checkVoSettings";
    private String awsAccessId;
    private String awsSecretId;
    private AWSVirtualOrganization awsVo;

    public AWSAuthTokenDescription(AWSVirtualOrganization awsVo) {
        if (awsVo != null) {
            this.awsVo = awsVo;
            try {
                this.awsAccessId = awsVo.getProperties().getAwsAccessId();
            }
            catch (ProblemException problemEx) {
                Activator.log("Could not obtain aws properties", (Exception)((Object)problemEx));
            }
        }
    }

    public AWSAuthTokenDescription(String awsAccessId) {
        this.awsAccessId = awsAccessId;
    }

    public IAuthenticationToken createToken() throws AuthenticationException {
        if (this.awsVo == null) {
            throw new AuthenticationException(PROBLEM_CHECK_VO_SETTINGS_ID, Messages.getString("AWSAuthTokenDescription.problem_description_no_aws_vo"), "eu.geclipse.aws");
        }
        return new AWSAuthToken(this);
    }

    public String getTokenTypeName() {
        return TOKEN_TYPE_NAME;
    }

    public String getWizardId() {
        return WIZARD_ID;
    }

    public boolean matches(IAuthenticationTokenDescription otherToken) {
        boolean result = true;
        if (otherToken instanceof AWSAuthTokenDescription) {
            AWSAuthTokenDescription awsAuthTokenDesc = (AWSAuthTokenDescription)otherToken;
            if (this.awsAccessId != null && !this.awsAccessId.equals(awsAuthTokenDesc.getAwsAccessId())) {
                result = false;
            }
            if (this.awsSecretId != null && !this.awsSecretId.equals(awsAuthTokenDesc.getAwsSecretId())) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public String getAwsAccessId() {
        return this.awsAccessId;
    }

    public String getAwsSecretId() {
        String secretId;
        if (this.awsAccessId != null && (secretId = PasswordManager.getPassword((String)(SECURE_STORAGE_NODE + this.awsAccessId))) != null) {
            return secretId;
        }
        return this.awsSecretId;
    }

    public AWSVirtualOrganization getAwsVo() {
        return this.awsVo;
    }

    public void setAwsVo(AWSVirtualOrganization awsVo) {
        this.awsVo = awsVo;
    }
}

