/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.aws.vo;

import eu.geclipse.aws.internal.Activator;
import eu.geclipse.aws.vo.AWSVirtualOrganization;
import eu.geclipse.aws.vo.AWSVoCreator;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IStorableElement;
import eu.geclipse.core.model.impl.AbstractGridElement;
import eu.geclipse.core.reporting.ProblemException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class AWSVoProperties
extends AbstractGridElement
implements IStorableElement {
    public static final String STORAGE_NAME = ".aws_vo_properties";
    private AWSVirtualOrganization vo;
    private String awsAccessId;

    public AWSVoProperties(AWSVirtualOrganization virtualOrganization, AWSVoCreator voCreator) {
        this.vo = virtualOrganization;
        if (voCreator != null) {
            this.awsAccessId = voCreator.getAwsAccessId();
        }
    }

    public AWSVoProperties(AWSVirtualOrganization virtualOrganization) {
        this(virtualOrganization, null);
    }

    public void load() throws ProblemException {
        BufferedReader bufferedReader = null;
        try {
            try {
                IFileStore fileStore = this.getFileStore();
                InputStream iStream = fileStore.openInputStream(0, null);
                InputStreamReader iReader = new InputStreamReader(iStream);
                bufferedReader = new BufferedReader(iReader);
                this.awsAccessId = bufferedReader.readLine();
            }
            catch (CoreException cExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)cExc, "eu.geclipse.aws");
            }
            catch (IOException ioEx) {
                Activator.log("Could not load aws vo properties", ioEx);
                throw new ProblemException("eu.geclipse.core.problem.model.elementSaveFailed", (Throwable)ioEx, "eu.geclipse.aws");
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ioExc) {
                    throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)ioExc, "eu.geclipse.aws");
                }
            }
        }
    }

    public void save() throws ProblemException {
        IFileStore fileStore = this.getFileStore();
        OutputStreamWriter osWriter = null;
        try {
            try {
                OutputStream oStream = fileStore.openOutputStream(0, null);
                osWriter = new OutputStreamWriter(oStream);
                if (this.awsAccessId != null) {
                    osWriter.write(String.valueOf(this.awsAccessId) + "\n");
                }
            }
            catch (CoreException cExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementSaveFailed", (Throwable)cExc, "eu.geclipse.aws");
            }
            catch (IOException ioEx) {
                Activator.log("Could not save aws vo properties", ioEx);
                throw new ProblemException("eu.geclipse.core.problem.model.elementSaveFailed", (Throwable)ioEx, "eu.geclipse.aws");
            }
        }
        finally {
            try {
                if (osWriter != null) {
                    osWriter.close();
                }
            }
            catch (IOException ioExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementSaveFailed", (Throwable)ioExc, "eu.geclipse.aws");
            }
        }
    }

    public IFileStore getFileStore() {
        return this.getParent().getFileStore().getChild(this.getName());
    }

    public String getName() {
        return STORAGE_NAME;
    }

    public IGridContainer getParent() {
        return this.vo;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(this.getName());
    }

    public IResource getResource() {
        return null;
    }

    public boolean isLocal() {
        return true;
    }

    public String getAwsAccessId() {
        return this.awsAccessId;
    }

    public void setAwsAccessId(String awsAccessId) {
        this.awsAccessId = awsAccessId;
    }
}

