/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal;

import eu.geclipse.batch.IBatchJobInfo;
import eu.geclipse.batch.IBatchJobManager;
import eu.geclipse.batch.IBatchService;
import eu.geclipse.batch.IQueueInfo;
import eu.geclipse.batch.IWorkerNodeInfo;
import eu.geclipse.batch.ui.dialogs.ProgressDialog;
import eu.geclipse.batch.ui.editors.BatchEditor;
import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.BatchJobManager;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.model.BatchDiagram;
import eu.geclipse.batch.ui.internal.model.BatchResource;
import eu.geclipse.batch.ui.internal.model.Box;
import eu.geclipse.batch.ui.internal.model.ComputingElement;
import eu.geclipse.batch.ui.internal.model.Connection;
import eu.geclipse.batch.ui.internal.model.Queue;
import eu.geclipse.batch.ui.internal.model.WorkerNode;
import eu.geclipse.core.reporting.ProblemException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchUpdate {
    protected Job updateJob;
    private final int nMaxElements = 6;
    private List<BatchResource> Qlist = new ArrayList<BatchResource>();
    private List<BatchResource> Nlist = new ArrayList<BatchResource>();
    private ScheduledExecutorService executor;
    private Runnable updateRunnable;
    private int updateInterval;
    private IBatchService batchWrapper;
    private BatchDiagram diagram;
    private String batchName;
    private String batchType;
    private BatchJobManager jobManager;
    private ComputingElement computingElement;
    private Box box_queue;
    private Box box_nodes;
    private LinkedHashMap<String, WorkerNode> workerNodes = new LinkedHashMap();
    private LinkedHashMap<String, Queue> queues = new LinkedHashMap();
    private List<BatchResource> removedResources = new ArrayList<BatchResource>();
    private boolean firstTime;
    private ProgressDialog initProgress;
    private int xCE = 0;
    private int maxX = 0;
    private int maxY = 0;
    private int count = 0;
    private int EnableQ = 0;
    private int DisabledQ = 0;
    private int freeN = 0;
    private int job_exclusiveN = 0;
    private int busyN = 0;
    private int downN = 0;
    private int addNewQueue = 89;
    private BatchEditor editor;
    private int[] queue_dim = new int[]{-1, -1, -1};
    private int[] nodes_dim = new int[]{-1, -1, -1};

    public BatchUpdate(Shell shell, BatchDiagram diagram, IBatchService batchWrapper, String batchName, String batchType, int updateInterval, BatchEditor editor) {
        this.diagram = diagram;
        this.batchWrapper = batchWrapper;
        this.batchName = batchName;
        this.batchType = batchType;
        this.updateInterval = updateInterval;
        this.updateRunnable = null;
        this.updateJob = null;
        this.jobManager = new BatchJobManager();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.firstTime = true;
        this.editor = editor;
        this.initProgress = new ProgressDialog(shell);
        String[] description = new String[]{"Worker Nodes", "Queues", "Sort Queue", "Computing Element", "Sort Worker Nodes", "Connections"};
        this.initProgress.initInformation(6, description, Messages.getString("BatchUpdate.ProgressDialogTitle"));
    }

    private WorkerNode updateWN(IWorkerNodeInfo wni) {
        String name = wni.getWnFQN();
        WorkerNode wn = this.workerNodes.get(name);
        if (wn != null) {
            wn.updateState(wni);
            wn = null;
        } else {
            Dimension dimWN = new Dimension(100, 40);
            wn = new WorkerNode(this.jobManager, this.editor);
            wn.setFQDN(wni.getWnFQN());
            wn.setKernelVersion(wni.getKernelVersion());
            wn.setNumProcessors(wni.getNp());
            wn.setTotalMem(wni.getTotalMem());
            wn.setState(wni.getState());
            wn.setJobIds(wni.getJobs());
            wn.setSize(dimWN);
            this.workerNodes.put(wni.getWnFQN(), wn);
        }
        return wn;
    }

    private Queue updateQueue(IQueueInfo queuei, List<IBatchJobInfo> jobis) {
        String name = queuei.getQueueName();
        Queue queue = this.queues.get(name);
        if (queue != null) {
            queue.updateState(queuei);
            queue = null;
        } else {
            Dimension dimQ = new Dimension(100, 55);
            queue = new Queue(this.jobManager, this.editor);
            queue.setQueueName(queuei.getQueueName());
            queue.setState(queuei.getState());
            queue.setRunState(queuei.getRunState());
            queue.setMemory(queuei.getMemory());
            queue.setTimeCPU(queuei.getTimeCPU());
            queue.setTimeWall(queuei.getTimeWall());
            queue.setRun(queuei.getRun());
            queue.setLm(queuei.getLm());
            queue.setQue(queuei.getQue());
            queue.setNode(queuei.getNode());
            queue.setSize(dimQ);
            this.queues.put(queuei.getQueueName(), queue);
        }
        return queue;
    }

    public synchronized void stopUpdate() {
        if (this.updateJob != null) {
            this.executor.shutdownNow();
            this.updateJob.cancel();
        }
        if (this.jobManager != null) {
            this.jobManager.removeAll();
        }
    }

    public synchronized void startUpdate() {
        if (this.updateJob == null) {
            this.initProgress.open();
            this.updateJob = new Job(this.batchName){

                protected IStatus run(IProgressMonitor monitor) {
                    Status status = null;
                    try {
                        BatchUpdate.this.drawBatchInfo();
                        status = new Status(0, "eu.geclipse.batch.ui", Messages.getString("BatchUpdate.Ok.StatusUpdate"));
                    }
                    catch (Exception exc) {
                        Activator.logException(exc);
                        status = new Status(4, "eu.geclipse.batch.ui", Messages.getString("BatchUpdate.Error.StatusUpdate"));
                    }
                    return status;
                }
            };
            this.updateRunnable = new Runnable(){

                public void run() {
                    if (BatchUpdate.this.updateJob.getState() == 0) {
                        BatchUpdate.this.updateJob.schedule();
                    }
                }
            };
            this.executor.scheduleWithFixedDelay(this.updateRunnable, 3L, this.updateInterval, TimeUnit.SECONDS);
        }
    }

    public void drawBatchInfo() {
        List queueis = null;
        List wnis = null;
        ArrayList<ComputingElement> newReses = null;
        List<IBatchJobInfo> jobis = null;
        Dimension dimBox_queue = null;
        Dimension dimBox_nodes = null;
        Dimension dimCE = new Dimension(140, 110);
        Point pointBox_queue = new Point(100, 55);
        Point pointBox_nodes = new Point(100, 400);
        Point pointCE = new Point(200, 100);
        Point pointWN = new Point(400, 10);
        Point pointQ = new Point(100, 1000);
        try {
            wnis = this.batchWrapper.getWorkerNodes();
        }
        catch (ProblemException exc) {
            Activator.logException((Exception)((Object)exc));
        }
        if (wnis != null) {
            if (this.firstTime) {
                this.initProgress.moveNextMajorTask(wnis.size());
            }
            int loc_y = 0;
            int newfreeN = 0;
            int newjob_exclusiveN = 0;
            int newbusyN = 0;
            int newdownN = 0;
            boolean changeN = false;
            boolean flag_notes = true;
            int j = 0;
            int i = 0;
            while (i < wnis.size()) {
                IWorkerNodeInfo wni = (IWorkerNodeInfo)wnis.get(i);
                WorkerNode wn = this.updateWN(wni);
                if (wni.getState().toString().equals("free")) {
                    ++newfreeN;
                } else if (wni.getState().toString().equals("job_exclusive")) {
                    ++newjob_exclusiveN;
                } else if (wni.getState().toString().equals("busy")) {
                    ++newbusyN;
                } else {
                    ++newdownN;
                }
                if (this.firstTime) {
                    this.freeN = newfreeN;
                    this.job_exclusiveN = newjob_exclusiveN;
                    this.busyN = newbusyN;
                    this.downN = newdownN;
                }
                if ((this.freeN != newfreeN || this.job_exclusiveN != newjob_exclusiveN || this.busyN != newbusyN || this.downN != newdownN) && i == wnis.size() - 1) {
                    changeN = true;
                    this.freeN = newfreeN;
                    this.job_exclusiveN = newjob_exclusiveN;
                    this.busyN = newbusyN;
                    this.downN = newdownN;
                }
                if (wn != null) {
                    int loc = 10 + 120 * j;
                    ++j;
                    if (i == 0) {
                        this.nodes_dim[0] = loc;
                    }
                    if (i % 6 == 0 && i > 0) {
                        loc = this.nodes_dim[0];
                        this.nodes_dim[2] = loc_y += 45;
                        j = 0;
                    }
                    if (i == 6 - 1) {
                        this.nodes_dim[1] = loc + 40;
                        flag_notes = false;
                    }
                    if (i == wnis.size() - 1 && flag_notes) {
                        this.nodes_dim[1] = loc + 100;
                    }
                    pointWN = pointWN.setLocation(loc, loc_y);
                    wn.setLocation(pointWN);
                    this.Nlist.add(wn);
                    if (this.firstTime) {
                        this.initProgress.moveNextMinor();
                    }
                }
                ++i;
            }
            if (changeN && this.editor.workerNodeByName != 1) {
                this.editor.sortedN = 2;
                this.editor.workerNodeByState = 2;
                changeN = false;
            }
        }
        try {
            this.batchWrapper.getJobs((IBatchJobManager)this.jobManager);
            queueis = this.batchWrapper.getQueues();
        }
        catch (ProblemException exc) {
            Activator.logException((Exception)((Object)exc));
        }
        int loc_y = 0;
        int newenabledQ = 0;
        int newdisabledQ = 0;
        boolean changeQ = false;
        if (queueis != null) {
            IQueueInfo queuei;
            if (this.firstTime) {
                this.initProgress.moveNextMajorTask(queueis.size());
            }
            boolean flag_queue = true;
            int j = 0;
            boolean add = false;
            int i = 0;
            while (i < queueis.size()) {
                queuei = (IQueueInfo)queueis.get(i);
                Queue queue = this.updateQueue(queuei, jobis);
                if (queuei.getState().toString().equals("enabled")) {
                    ++newenabledQ;
                } else {
                    ++newdisabledQ;
                }
                if (this.firstTime) {
                    this.EnableQ = newenabledQ;
                    this.DisabledQ = newdisabledQ;
                }
                if ((this.EnableQ != newenabledQ || this.DisabledQ != newdisabledQ) && i == queueis.size() - 1) {
                    changeQ = true;
                    this.EnableQ = newenabledQ;
                    this.DisabledQ = newdisabledQ;
                }
                if (queue != null) {
                    this.count = queueis.size();
                    if (!this.firstTime) {
                        add = true;
                    }
                    int loc_x = 50 + 120 * j;
                    ++j;
                    if (i == 0) {
                        this.queue_dim[0] = loc_x;
                    }
                    if (i % 6 == 0 && i > 0) {
                        this.addNewQueue += 70;
                        loc_x = this.queue_dim[0];
                        this.queue_dim[2] = loc_y += 70;
                        j = 0;
                    }
                    if (this.maxX < loc_x) {
                        this.maxX = loc_x;
                    }
                    if (this.maxY <= loc_y) {
                        this.maxY = loc_y;
                    }
                    if (i == 6 - 1) {
                        this.queue_dim[1] = loc_x + 50;
                        flag_queue = false;
                    }
                    if (i == queueis.size() - 1 && flag_queue) {
                        this.queue_dim[1] = loc_x + 50;
                    }
                    pointQ = pointQ.setLocation(loc_x, loc_y);
                    queue.setLocation(pointQ);
                    this.Qlist.add(queue);
                    if (this.firstTime) {
                        this.initProgress.moveNextMinor();
                    }
                }
                ++i;
            }
            boolean values = true;
            if (changeQ && this.editor.queueByName != 1) {
                this.editor.queueByState = 2;
                this.editor.sortedQ = 2;
                changeQ = false;
                values = false;
            }
            if (!this.firstTime) {
                try {
                    if (add) {
                        this.addQueue(values, dimBox_queue, pointCE, pointBox_nodes);
                    }
                }
                catch (Exception exception) {}
            }
            for (String queueName : this.queues.keySet()) {
                boolean found = false;
                int i2 = 0;
                while (i2 < queueis.size()) {
                    queuei = (IQueueInfo)queueis.get(i2);
                    if (queueName.equals(queuei.getQueueName())) {
                        found = true;
                    }
                    ++i2;
                }
                if (found) continue;
                this.removedResources.add(this.queues.get(queueName));
            }
        }
        this.Sort(this.editor.sortedQ, this.Qlist, this.box_queue, true);
        this.Sort(this.editor.sortedN, this.Nlist, this.box_nodes, false);
        if (this.box_queue == null) {
            int startx = this.queue_dim[1] - this.queue_dim[0];
            int starty = this.queue_dim[2];
            if (this.firstTime) {
                this.initProgress.moveNextMajorTask(1);
            }
            dimBox_queue = new Dimension(startx, starty + 95);
            this.box_queue = new Box(this.jobManager);
            this.box_queue.setSize(dimBox_queue);
            this.box_queue.setName(Messages.getString("BoxElementQueues"));
            pointBox_queue = pointBox_queue.setLocation(25, 25);
            this.box_queue.setLocation(pointBox_queue);
            this.box_queue.addChildren(this.Qlist);
            newReses = new ArrayList();
            newReses.add((ComputingElement)((Object)this.box_queue));
            if (this.firstTime) {
                this.initProgress.moveNextMinor();
            }
        }
        int X = this.queue_dim[0];
        int Y = this.queue_dim[2] + 200;
        this.xCE = X;
        if (this.computingElement == null) {
            if (this.firstTime) {
                this.initProgress.moveNextMajorTask(1);
            }
            this.computingElement = new ComputingElement(this.jobManager);
            this.computingElement.setSize(dimCE);
            this.computingElement.setFQDN(this.batchName);
            this.computingElement.setType(this.batchType);
            pointCE = pointCE.setLocation(X + 205, Y);
            this.computingElement.setLocation(pointCE);
            if (newReses == null) {
                newReses = new ArrayList<ComputingElement>();
            }
            newReses.add(this.computingElement);
            if (this.firstTime) {
                this.initProgress.moveNextMinor();
            }
        }
        if (this.box_nodes == null) {
            if (this.firstTime) {
                this.initProgress.moveNextMajorTask(1);
            }
            int startx = this.nodes_dim[1] - this.nodes_dim[0];
            int starty = this.nodes_dim[2];
            dimBox_nodes = new Dimension(startx, starty + 70);
            this.box_nodes = new Box(this.jobManager);
            this.box_nodes.setSize(dimBox_nodes);
            this.box_nodes.setName(Messages.getString("BoxElementNodes"));
            this.box_nodes.setIsNodes(true);
            pointBox_nodes = pointBox_nodes.setLocation(X, Y + 200);
            this.box_nodes.setLocation(pointBox_nodes);
            if (newReses == null) {
                newReses = new ArrayList();
            }
            newReses.add((ComputingElement)((Object)this.box_nodes));
            this.box_nodes.addChildren(this.Nlist);
            if (this.firstTime) {
                this.initProgress.moveNextMinor();
            }
            if (this.firstTime) {
                this.initProgress.moveNextMajorTask(2);
            }
            Connection conn = new Connection(this.computingElement, this.box_nodes, 1);
            conn.reconnect();
            Connection conn1 = new Connection(this.box_queue, this.computingElement, 2);
            conn1.reconnect();
        }
        if (newReses != null) {
            this.diagram.addChildren(newReses);
        }
        if (queueis != null && queueis.size() != this.computingElement.getNumQueues()) {
            this.computingElement.setNumQueues(queueis.size());
        } else if (queueis == null && this.computingElement.getNumQueues() > 0) {
            this.computingElement.setNumQueues(0);
        }
        if (wnis != null && wnis.size() != this.computingElement.getNumWNs()) {
            this.computingElement.setNumWNs(wnis.size());
        } else if (wnis == null && this.computingElement.getNumWNs() > 0) {
            this.computingElement.setNumWNs(0);
        }
        if (this.jobManager.getJobCount() != this.computingElement.getNumJobs()) {
            this.computingElement.setNumJobs(this.jobManager.getJobCount());
        }
        if (!this.removedResources.isEmpty()) {
            for (BatchResource resource : this.removedResources) {
                this.box_queue.removeChildren(this.Qlist);
                this.Qlist.remove(resource);
                if (resource instanceof WorkerNode) continue;
                if (resource instanceof Queue) {
                    Queue q = (Queue)resource;
                    this.queues.remove(q.getQueneName());
                    continue;
                }
                assert (false);
            }
            this.diagram.removeChild(this.box_queue);
            this.box_queue.addChildren(this.Qlist);
            this.diagram.addChild(this.box_queue);
            this.removedResources.clear();
            this.editor.sortedQ = 0;
        }
        if (this.firstTime) {
            this.initProgress.close();
            this.firstTime = false;
        }
    }

    private void addQueue(boolean values, Dimension dimBox_queue, Point pointCE, Point pointBoxnodes) {
        this.box_queue.removeChildren(this.Qlist);
        this.diagram.removeChild(this.box_queue);
        this.box_queue.addChildren(this.Qlist);
        boolean newsize = false;
        if (this.count % 6 == 1) {
            this.count = 0;
            Dimension dimBox_new = new Dimension(this.maxX, this.addNewQueue);
            this.box_queue.setSize(dimBox_new);
            this.diagram.addChild(this.box_queue);
            int temp = this.addNewQueue + 100;
            pointCE.setLocation(this.xCE + 205, temp);
            this.computingElement.setLocation(pointCE);
            pointBoxnodes.setLocation(this.xCE, temp + 150);
            this.box_nodes.setLocation(pointBoxnodes);
            newsize = true;
        }
        if (!newsize) {
            this.box_queue.setSize(dimBox_queue);
            this.diagram.addChild(this.box_queue);
        }
        if (this.editor.queueByName == 1 && values) {
            this.editor.sortedQ = 1;
            this.editor.queueByName = 0;
        } else if (this.editor.queueByState == 2 && values) {
            this.editor.sortedQ = 2;
            this.editor.queueByName = 0;
        } else {
            this.editor.sortedQ = 0;
        }
    }

    private void Sort(int cont, List list, Box box, boolean x) {
        if (cont == 1) {
            Collections.sort(list);
            if (x) {
                box.setName(Messages.getString("BoxQueue.SortedByName"));
            } else {
                box.setName(Messages.getString("BoxNode.SortedByName"));
            }
            this.Refresh(box, list);
            this.ResetValues();
        } else if (cont == 2) {
            Collections.sort(list);
            if (x) {
                box.setName(Messages.getString("BoxQueue.SortedByState"));
            } else {
                box.setName(Messages.getString("BoxNode.SortedByState"));
            }
            this.Refresh(box, list);
            this.ResetValues();
        }
    }

    private void Refresh(Box box, List list) {
        box.removeChildren(list);
        this.diagram.removeChild(box);
        box.addChildren(list);
        this.diagram.addChild(box);
    }

    private void ResetValues() {
        this.editor.sortedQ = 0;
        this.editor.sortedN = 0;
    }
}

