/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal;

import eu.geclipse.batch.IBatchService;
import eu.geclipse.batch.IQueueInfo;
import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.model.Queue;
import eu.geclipse.batch.ui.internal.parts.BatchTreeEditPart;
import eu.geclipse.batch.ui.internal.parts.QueueEditPart;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.dialogs.ProblemDialog;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class QueueEnDisAction
extends SelectionAction {
    public static final String PROPERTY_QUEUE_ACTION_ENABLE_DISABLE = "QueueEnDisAction.EnableDisable";
    private IBatchService batchWrapper;
    private boolean enable;
    private ImageDescriptor imgEnable;
    private ImageDescriptor imgDrain;

    public QueueEnDisAction(IWorkbenchPart part, IBatchService batchWrapper) {
        super(part);
        this.batchWrapper = batchWrapper;
        this.setId(PROPERTY_QUEUE_ACTION_ENABLE_DISABLE);
        this.setToolTipText(Messages.getString("QueueEnDisAction.Msg.EnableDisableTips"));
        this.imgEnable = Activator.getDefault().getImageRegistry().getDescriptor("enableResource");
        this.imgDrain = Activator.getDefault().getImageRegistry().getDescriptor("drainQueue");
    }

    public void run() {
        for (Object o : this.getSelectedObjects()) {
            Queue q;
            if (o instanceof BatchTreeEditPart) {
                BatchTreeEditPart treeEditPart = (BatchTreeEditPart)o;
                q = (Queue)treeEditPart.getModel();
            } else {
                if (!(o instanceof QueueEditPart)) break;
                QueueEditPart qEdit = (QueueEditPart)o;
                q = (Queue)qEdit.getModel();
            }
            String strName = q.getQueneName();
            try {
                if (this.enable) {
                    this.batchWrapper.enableQueue(strName);
                    continue;
                }
                this.batchWrapper.disableQueue(strName);
            }
            catch (ProblemException excp) {
                ProblemDialog.openProblem((Shell)this.getWorkbenchPart().getSite().getShell(), (String)Messages.getString("QueueEnDisAction.error_manipulate_title"), (String)Messages.getString("QueueEnDisAction.error_manipulate_message"), (Throwable)excp);
            }
        }
    }

    protected boolean calculateEnabled() {
        boolean result;
        boolean firstTime = true;
        boolean enableAll = true;
        Queue q = null;
        boolean bl = result = !this.getSelectedObjects().isEmpty();
        if (result) {
            for (Object o : this.getSelectedObjects()) {
                if (o instanceof BatchTreeEditPart) {
                    BatchTreeEditPart treeEditPart = (BatchTreeEditPart)o;
                    Object oModel = treeEditPart.getModel();
                    if (!(oModel instanceof Queue)) {
                        result = false;
                        break;
                    }
                    q = (Queue)oModel;
                } else if (o instanceof QueueEditPart) {
                    QueueEditPart qEdit = (QueueEditPart)o;
                    q = (Queue)qEdit.getModel();
                } else {
                    result = false;
                    break;
                }
                if (firstTime) {
                    if (q.getState() == IQueueInfo.QueueState.E) {
                        enableAll = false;
                    }
                    firstTime = false;
                    continue;
                }
                if ((!enableAll || q.getState() != IQueueInfo.QueueState.E) && (enableAll || q.getState() != IQueueInfo.QueueState.D)) continue;
                result = false;
                break;
            }
            if (enableAll) {
                this.setText(Messages.getString("QueueEnDisAction.Msg.EnableText"));
                this.setImageDescriptor(this.imgEnable);
                this.enable = true;
            } else {
                this.setText(Messages.getString("QueueEnDisAction.Msg.DisableText"));
                this.setImageDescriptor(this.imgDrain);
                this.enable = false;
            }
        }
        return result;
    }
}

