/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal;

import eu.geclipse.batch.IQueueInfo;
import eu.geclipse.batch.ui.IQueueFigure;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.SimpleRaisedBorder;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.geometry.Dimension;

public final class QueueFigure
extends Figure
implements IQueueFigure {
    private static final Dimension SIZE = new Dimension(100, 65);
    private TitleBarBorder border;
    private Label labState;
    private Label labRunState;

    public QueueFigure() {
        this.setLayoutManager((LayoutManager)new FlowLayout(false));
        this.border = new TitleBarBorder();
        this.border.setBackgroundColor(ColorConstants.menuBackground);
        this.border.setTextColor(ColorConstants.menuForeground);
        CompoundBorder iBorder = new CompoundBorder((Border)new SimpleRaisedBorder(), (Border)new LineBorder(ColorConstants.white));
        this.setBorder((Border)new CompoundBorder((Border)iBorder, (Border)this.border));
        this.setOpaque(true);
        this.setBackgroundColor(ColorConstants.green);
        this.setForegroundColor(ColorConstants.black);
        this.labState = new Label();
        this.add((IFigure)this.labState);
        this.labRunState = new Label();
        this.add((IFigure)this.labRunState);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    public void setQueueName(String name) {
        this.border.setLabel(name);
    }

    public void setState(IQueueInfo.QueueState state, IQueueInfo.QueueRunState runState) {
        this.labState.setText(state.toString());
        switch (state) {
            case E: {
                if (IQueueInfo.QueueRunState.R == runState) {
                    this.setBackgroundColor(ColorConstants.green);
                    break;
                }
                this.setBackgroundColor(ColorConstants.yellow);
                break;
            }
            case D: {
                if (IQueueInfo.QueueRunState.R == runState) {
                    this.setBackgroundColor(ColorConstants.orange);
                    break;
                }
                this.setBackgroundColor(ColorConstants.red);
            }
        }
    }

    public void setRunState(IQueueInfo.QueueRunState runState, IQueueInfo.QueueState state) {
        this.labRunState.setText(runState.toString());
        switch (runState) {
            case R: {
                if (IQueueInfo.QueueState.E == state) {
                    this.setBackgroundColor(ColorConstants.green);
                    break;
                }
                this.setBackgroundColor(ColorConstants.orange);
                break;
            }
            case S: {
                if (IQueueInfo.QueueState.E == state) {
                    this.setBackgroundColor(ColorConstants.yellow);
                    break;
                }
                this.setBackgroundColor(ColorConstants.red);
            }
        }
    }
}

