/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.model;

import eu.geclipse.batch.ui.internal.model.BatchResource;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class BatchSetConstraintCommand
extends Command {
    private final Rectangle newBounds;
    private Rectangle oldBounds;
    private final ChangeBoundsRequest request;
    private final BatchResource resource;

    public BatchSetConstraintCommand(BatchResource resource, ChangeBoundsRequest req, Rectangle newBounds) {
        if (resource == null || req == null || newBounds == null) {
            throw new IllegalArgumentException();
        }
        this.resource = resource;
        this.request = req;
        this.newBounds = newBounds.getCopy();
        this.setLabel("move / resize");
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        return "move".equals(type) || "move children".equals(type) || "resize".equals(type) || "resize children".equals(type);
    }

    public void execute() {
        this.oldBounds = new Rectangle(this.resource.getLocation(), this.resource.getSize());
        this.redo();
    }

    public void redo() {
        this.resource.setSize(this.newBounds.getSize());
        this.resource.setLocation(this.newBounds.getLocation());
    }

    public void undo() {
        this.resource.setSize(this.oldBounds.getSize());
        this.resource.setLocation(this.oldBounds.getLocation());
    }
}

