/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.model;

import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.BatchJobManager;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.model.BatchResource;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Box
extends BatchResource {
    public static final String CHILD_ADDED_PROP = "BatchDiagram.ChildAdded";
    public static final String CHILDREN_ADDED_PROP = "BatchDiagram.ChildrenAdded";
    public static final String CHILD_REMOVED_PROP = "BatchDiagram.ChildRemoved";
    private String name;
    private final Image BoxIcon = Activator.getDefault().getImageRegistry().get("computingElementIcon");
    private List<BatchResource> resources = new ArrayList<BatchResource>();
    private boolean IsNodes = false;

    public Box(BatchJobManager jobManager) {
        super(jobManager);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.removePropertyChangeListener(listener);
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean addChild(BatchResource resource) {
        boolean ret = false;
        if (resource != null && this.resources.add(resource)) {
            ret = true;
            this.firePropertyChange(CHILD_ADDED_PROP, null, resource);
        }
        return ret;
    }

    public boolean addChildren(List<BatchResource> reses) {
        boolean ret = false;
        if (reses != null && this.resources.addAll(reses)) {
            ret = true;
            this.firePropertyChange(CHILDREN_ADDED_PROP, null, reses);
        }
        return ret;
    }

    public void setIsNodes(boolean v) {
        this.IsNodes = v;
    }

    public boolean getIsNodes() {
        return this.IsNodes;
    }

    public boolean removeChild(BatchResource resource) {
        boolean ret = false;
        if (resource != null && this.resources.remove(resource)) {
            this.firePropertyChange(CHILD_REMOVED_PROP, null, resource);
            ret = true;
        }
        return ret;
    }

    public boolean removeChildren(List<BatchResource> reses) {
        boolean ret = false;
        if (reses != null && this.resources.removeAll(reses)) {
            this.firePropertyChange(CHILD_REMOVED_PROP, null, reses);
            ret = true;
        }
        return ret;
    }

    public List<BatchResource> getChildren() {
        return this.resources;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Image getIcon() {
        return this.BoxIcon;
    }

    @Override
    public String getOutlineString() {
        return String.valueOf(Messages.getString("BoxElement")) + this.name;
    }

    public int compareTo(Object o) {
        return 0;
    }
}

