/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.model;

import eu.geclipse.batch.IBatchJobInfo;
import eu.geclipse.batch.IQueueInfo;
import eu.geclipse.batch.ui.editors.BatchEditor;
import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.BatchJobManager;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.model.BatchResource;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public final class Queue
extends BatchResource
implements Comparable {
    public static final String PROPERTY_NAME = "Queue.name";
    public static final String PROPERTY_STATE = "Queue.state";
    public static final String PROPERTY_RUN_STATE = "Queue.runState";
    public static final String PROPERTY_MEM = "Queue.memory";
    public static final String PROPERTY_TIME_CPU = "Queue.timeCPU";
    public static final String PROPERTY_TIME_WALL = "Queue.timeWall";
    public static final String PROPERTY_NODE = "Queue.node";
    public static final String PROPERTY_RUN = "Queue.run";
    public static final String PROPERTY_QUE = "Queue.que";
    public static final String PROPERTY_LM = "Queue.lm";
    private static final long serialVersionUID = 1L;
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new PropertyDescriptor((Object)"Queue.name", Messages.getString("Queue.Name")), new TextPropertyDescriptor((Object)"Queue.state", Messages.getString("Queue.State")), new PropertyDescriptor((Object)"Queue.runState", Messages.getString("Queue.RunState")), new TextPropertyDescriptor((Object)"Queue.memory", Messages.getString("Queue.Memory")), new TextPropertyDescriptor((Object)"Queue.timeCPU", Messages.getString("Queue.TimeCPU")), new TextPropertyDescriptor((Object)"Queue.timeWall", Messages.getString("Queue.TimeWall")), new TextPropertyDescriptor((Object)"Queue.node", Messages.getString("Queue.Node")), new PropertyDescriptor((Object)"Queue.run", Messages.getString("Queue.Run")), new PropertyDescriptor((Object)"Queue.que", Messages.getString("Queue.Que")), new TextPropertyDescriptor((Object)"Queue.lm", Messages.getString("Queue.Lm"))};
    private final Image queueIcon = Activator.getDefault().getImageRegistry().get("queueIcon");
    private BatchEditor editor;
    private String queueName;
    private IQueueInfo.QueueState state;
    private IQueueInfo.QueueRunState runState;
    private int memory;
    private String timeCPU;
    private String timeWall;
    private String node;
    private int run;
    private int que;
    private String lm;

    static {
        int i = 0;
        while (i < descriptors.length) {
            ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    int intValue = -1;
                    String str = null;
                    try {
                        intValue = Integer.parseInt((String)value);
                        str = intValue >= 0 ? null : Messages.getString("Queue.Error.LTZero");
                    }
                    catch (NumberFormatException numberFormatException) {
                        str = Messages.getString("Queue.Error.NotANumber");
                    }
                    return str;
                }
            });
            ++i;
        }
    }

    public Queue(BatchJobManager jobManager, BatchEditor editor) {
        super(jobManager);
        this.editor = editor;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    public Object getPropertyValue(Object propertyId) {
        Object str = null;
        if (PROPERTY_NAME.equals(propertyId)) {
            str = this.queueName;
        } else if (PROPERTY_STATE.equals(propertyId)) {
            str = this.state.toString();
        } else if (PROPERTY_RUN_STATE.equals(propertyId)) {
            str = this.runState.toString();
        } else if (PROPERTY_TIME_CPU.equals(propertyId)) {
            str = this.timeCPU;
        } else if (PROPERTY_TIME_WALL.equals(propertyId)) {
            str = this.timeWall;
        } else if (PROPERTY_MEM.equals(propertyId)) {
            str = Integer.toString(this.memory);
        } else if (PROPERTY_NODE.equals(propertyId)) {
            str = this.node;
        } else if (PROPERTY_RUN.equals(propertyId)) {
            str = Integer.toString(this.run);
        } else if (PROPERTY_QUE.equals(propertyId)) {
            str = Integer.toString(this.que);
        } else if (PROPERTY_LM.equals(propertyId)) {
            str = this.lm;
        }
        if (str == null) {
            str = super.getPropertyValue(propertyId);
        }
        return str;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcsDelegate.removePropertyChangeListener(listener);
    }

    public void setQueueName(String newName) {
        String oldName = this.queueName;
        this.queueName = newName;
        this.pcsDelegate.firePropertyChange(PROPERTY_NAME, oldName, newName);
    }

    public void setMemory(int newMemory) {
        this.memory = newMemory;
    }

    public void setTimeCPU(String newTimeCPU) {
        this.timeCPU = newTimeCPU;
    }

    public void setTimeWall(String newTimeWall) {
        this.timeWall = newTimeWall;
    }

    public void setNode(String newNode) {
        this.node = newNode;
    }

    public void setRun(int newRun) {
        this.run = newRun;
    }

    public void setLm(String newLm) {
        this.lm = newLm;
    }

    public void setQue(int newQue) {
        this.que = newQue;
    }

    public void setState(IQueueInfo.QueueState newState) {
        IQueueInfo.QueueState oldState = this.state;
        this.state = newState;
        this.pcsDelegate.firePropertyChange(PROPERTY_STATE, oldState, newState);
    }

    public void setRunState(IQueueInfo.QueueRunState newRunState) {
        IQueueInfo.QueueRunState oldRunState = this.runState;
        this.runState = newRunState;
        this.pcsDelegate.firePropertyChange(PROPERTY_RUN_STATE, oldRunState, newRunState);
    }

    public String getQueneName() {
        return this.queueName;
    }

    public IQueueInfo.QueueState getState() {
        return this.state;
    }

    public IQueueInfo.QueueRunState getRunState() {
        return this.runState;
    }

    public boolean isQueueEmpty() {
        List<IBatchJobInfo> jobs = this.jobManager.getJobs(this.queueName);
        return jobs.isEmpty();
    }

    public Image getIcon() {
        return this.queueIcon;
    }

    public void updateState(IQueueInfo queuei) {
        if (queuei.getState() != this.state) {
            this.setState(queuei.getState());
        }
        if (queuei.getRunState() != this.runState) {
            this.setRunState(queuei.getRunState());
        }
        if (queuei.getMemory() != this.memory) {
            this.setMemory(queuei.getMemory());
        }
        if (queuei.getTimeCPU().compareTo(this.timeCPU) != 0) {
            this.setTimeCPU(queuei.getTimeCPU());
        }
        if (queuei.getTimeWall().compareTo(this.timeWall) != 0) {
            this.setTimeWall(queuei.getTimeWall());
        }
        if (queuei.getNode().compareTo(this.node) != 0) {
            this.setNode(queuei.getNode());
        }
        if (queuei.getRun() != this.run) {
            this.setRun(queuei.getRun());
        }
        if (queuei.getQue() != this.que) {
            this.setQue(queuei.getQue());
        }
        if (queuei.getLm().compareTo(this.lm) != 0) {
            this.setLm(queuei.getLm());
        }
    }

    public String getOutlineString() {
        return String.valueOf(Messages.getString("Queue.Name")) + this.queueName;
    }

    public int compareTo(Object o) {
        int value;
        if (this.editor.sortedQ == 2) {
            String tempName = ((Queue)o).state.toString();
            value = this.getState().toString().compareTo(tempName);
        } else {
            String tempName = ((Queue)o).getQueneName();
            value = this.getQueneName().compareTo(tempName);
        }
        return value;
    }
}

