/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.parts;

import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.internal.model.BatchResource;
import eu.geclipse.batch.ui.internal.model.Box;
import eu.geclipse.batch.ui.internal.model.ComputingElement;
import eu.geclipse.batch.ui.internal.model.Connection;
import eu.geclipse.batch.ui.internal.model.ModelElement;
import eu.geclipse.batch.ui.internal.model.Queue;
import eu.geclipse.batch.ui.internal.model.WorkerNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.EllipseAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatchEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart {
    protected Display display;
    private ConnectionAnchor anchor;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
            this.display = this.getRoot().getViewer().getControl().getDisplay();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    protected void createEditPolicies() {
    }

    protected abstract IFigure createFigure();

    private BatchResource getCastedModel() {
        return (BatchResource)this.getModel();
    }

    protected ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            if (this.getModel() instanceof WorkerNode) {
                this.anchor = new EllipseAnchor(this.getFigure());
            } else if (this.getModel() instanceof Queue) {
                this.anchor = new EllipseAnchor(this.getFigure());
            } else if (this.getModel() instanceof Box) {
                this.anchor = new EllipseAnchor(this.getFigure());
            } else if (this.getModel() instanceof ComputingElement) {
                this.anchor = new ChopboxAnchor(this.getFigure());
            } else {
                throw new IllegalArgumentException(Messages.getString("BatchEditPart.Error.UnexpectedModel"));
            }
        }
        return this.anchor;
    }

    protected List<Connection> getModelSourceConnections() {
        return this.getCastedModel().getSourceConnections();
    }

    protected List<Connection> getModelTargetConnections() {
        return this.getCastedModel().getTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("BatchResource.Size".equals(prop) || "BatchResource.Location".equals(prop)) {
            this.refreshVisuals();
        } else if ("BatchResource.SourceConn".equals(prop)) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    BatchEditPart.this.refreshSourceConnections();
                }
            });
        } else if ("BatchResource.TargetConn".equals(prop)) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    BatchEditPart.this.refreshTargetConnections();
                }
            });
        }
    }

    protected void refreshVisuals() {
        Rectangle bounds = new Rectangle(this.getCastedModel().getLocation(), this.getCastedModel().getSize());
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
    }
}

