/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.parts;

import eu.geclipse.batch.ui.internal.model.Connection;
import eu.geclipse.batch.ui.internal.model.ModelElement;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.swt.widgets.Display;

public class ConnectionEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    protected Display display;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
            this.display = this.getRoot().getViewer().getControl().getDisplay();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
    }

    protected IFigure createFigure() {
        PolylineConnection connection = (PolylineConnection)super.createFigure();
        connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        connection.setLineStyle(this.getCastedModel().getLineStyle());
        return connection;
    }

    private Connection getCastedModel() {
        return (Connection)this.getModel();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if ("LineStyle".equals(property)) {
            ((PolylineConnection)this.getFigure()).setLineStyle(this.getCastedModel().getLineStyle());
        }
    }
}

