/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.internal.parts;

import eu.geclipse.batch.ui.internal.model.BatchDiagram;
import eu.geclipse.batch.ui.internal.model.BatchResource;
import eu.geclipse.batch.ui.internal.model.ModelElement;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramTreeEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener {
    protected Display display;

    public DiagramTreeEditPart(BatchDiagram model) {
        super((Object)model);
    }

    private BatchDiagram getCastedModel() {
        return (BatchDiagram)this.getModel();
    }

    private EditPart getEditPartForChild(Object child) {
        return (EditPart)this.getViewer().getEditPartRegistry().get(child);
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
            this.display = this.getRoot().getViewer().getControl().getDisplay();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    protected void createEditPolicies() {
        if (this.getParent() instanceof RootEditPart) {
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        }
    }

    protected List<BatchResource> getModelChildren() {
        return this.getCastedModel().getChildren();
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("BatchDiagram.ChildAdded".equals(prop)) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    DiagramTreeEditPart.this.addChild(DiagramTreeEditPart.this.createChild(evt.getNewValue()), -1);
                }
            });
        } else if ("BatchDiagram.ChildrenAdded".equals(prop)) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    List childrenTmp = (List)evt.getNewValue();
                    for (BatchResource child : childrenTmp) {
                        DiagramTreeEditPart.this.addChild(DiagramTreeEditPart.this.createChild(child), -1);
                    }
                }
            });
        } else if ("BatchDiagram.ChildRemoved".equals(prop)) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    DiagramTreeEditPart.this.removeChild(DiagramTreeEditPart.this.getEditPartForChild(evt.getNewValue()));
                }
            });
        } else {
            this.display.syncExec(new Runnable(){

                public void run() {
                    DiagramTreeEditPart.this.refreshVisuals();
                }
            });
        }
    }
}

