/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.wizards;

import eu.geclipse.batch.BatchQueueDescription;
import eu.geclipse.batch.model.qdl.BoundaryType;
import eu.geclipse.batch.model.qdl.QdlFactory;
import eu.geclipse.batch.model.qdl.QueueTypeEnumeration;
import eu.geclipse.batch.model.qdl.RangeValueType;
import eu.geclipse.batch.ui.dialogs.AllowedVOsDialog;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddQueueWizardRequiredPage
extends WizardPage {
    protected Text nameText;
    protected Combo typeCombo;
    protected Button enabledButton;
    protected Button disabledButton;
    protected Spinner timeCPUHourSpin;
    protected Spinner timeCPUMinSpin;
    protected Spinner timeWallHourSpin;
    protected Spinner timeWallMinSpin;
    protected Table allowedVoTable;
    protected Button editVoButton;
    protected Button deleteVoButton;
    private Composite mainComp;
    private Label nameLabel;
    private Label typeLabel;
    private Label timeCPULabel;
    private Label timeWallLabel;
    private Group statusGroup;
    private Composite tableButtonsComp;
    private Button addVoButton;

    protected AddQueueWizardRequiredPage() {
        super("addQueueRequiredPage");
        this.setTitle(Messages.getString("AddQueueRequiredPage.Title"));
        this.setDescription(Messages.getString("AddQueueRequiredPage.Description"));
    }

    public void createControl(Composite parent) {
        this.mainComp = new Composite(parent, 0);
        this.mainComp.setLayout((Layout)new GridLayout(4, false));
        GridData longData = new GridData(4, 4, true, false);
        longData.horizontalSpan = 3;
        this.nameLabel = new Label(this.mainComp, 0);
        this.nameLabel.setText(Messages.getString("AddQueueRequiredPage.Name"));
        this.nameText = new Text(this.mainComp, 2048);
        this.nameText.setLayoutData((Object)longData);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddQueueWizardRequiredPage.this.updateUI();
            }
        });
        this.typeLabel = new Label(this.mainComp, 0);
        this.typeLabel.setText(Messages.getString("AddQueueRequiredPage.Type"));
        this.typeCombo = new Combo(this.mainComp, 4);
        this.typeCombo.add(Messages.getString("AddQueueRequiredPage.Type_Execution"), 0);
        this.typeCombo.add(Messages.getString("AddQueueRequiredPage.Type_Route"), 1);
        this.typeCombo.select(0);
        this.typeCombo.setLayoutData((Object)longData);
        this.statusGroup = new Group(this.mainComp, 0);
        this.statusGroup.setText(Messages.getString("AddQueueRequiredPage.Status"));
        this.statusGroup.setLayout((Layout)new GridLayout(1, false));
        this.statusGroup.setLayoutData((Object)new GridData(4, 4, true, false, 4, 1));
        this.enabledButton = new Button((Composite)this.statusGroup, 16);
        this.enabledButton.setText(Messages.getString("AddQueueRequiredPage.Enabled"));
        this.enabledButton.setSelection(true);
        this.disabledButton = new Button((Composite)this.statusGroup, 16);
        this.disabledButton.setText(Messages.getString("AddQueueRequiredPage.Disabled"));
        this.timeCPULabel = new Label(this.mainComp, 0);
        this.timeCPULabel.setText(Messages.getString("AddQueueRequiredPage.TimeCPU"));
        Composite timeComp = new Composite(this.mainComp, 0);
        timeComp.setLayout((Layout)new GridLayout(3, false));
        this.timeCPUHourSpin = new Spinner(timeComp, 2048);
        this.timeCPUHourSpin.setValues(172800, 0, 9999999, 0, 1000, 2000);
        this.timeWallLabel = new Label(this.mainComp, 0);
        this.timeWallLabel.setText(Messages.getString("AddQueueRequiredPage.TimeWall"));
        timeComp = new Composite(this.mainComp, 0);
        timeComp.setLayout((Layout)new GridLayout(3, false));
        this.timeWallHourSpin = new Spinner(timeComp, 2048);
        this.timeWallHourSpin.setValues(172800, 0, 9999999, 0, 1000, 2000);
        GridLayout compLayout = new GridLayout(2, false);
        compLayout.marginHeight = 0;
        compLayout.marginWidth = 0;
        Composite tableComp = new Composite(this.mainComp, 0);
        this.allowedVoTable = new Table(tableComp, 2818);
        this.allowedVoTable.setHeaderVisible(true);
        this.allowedVoTable.setLinesVisible(true);
        this.allowedVoTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddQueueWizardRequiredPage.this.editVoButton.setEnabled(true);
                AddQueueWizardRequiredPage.this.deleteVoButton.setEnabled(true);
            }
        });
        GridData gd = new GridData(4, 4, true, true);
        this.allowedVoTable.setLayoutData((Object)gd);
        tableComp.setLayout((Layout)compLayout);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        TableColumn hostColumn = new TableColumn(this.allowedVoTable, 16384);
        hostColumn.setText(Messages.getString("AddQueueRequiredPage.AllowedVos"));
        hostColumn.setWidth(250);
        GridLayout buttonCompLayout = new GridLayout();
        buttonCompLayout.marginHeight = 0;
        buttonCompLayout.marginWidth = 0;
        this.tableButtonsComp = new Composite(tableComp, 0);
        this.tableButtonsComp.setLayout((Layout)buttonCompLayout);
        this.tableButtonsComp.setLayoutData((Object)new GridData(4, 4, false, false));
        GridData voButtonData = new GridData(4, 4, true, false);
        this.addVoButton = new Button(this.tableButtonsComp, 8);
        this.addVoButton.setText(Messages.getString("AddQueueRequiredPage.AddVo"));
        this.addVoButton.setLayoutData((Object)voButtonData);
        this.addVoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AllowedVOsDialog dialog = new AllowedVOsDialog(AddQueueWizardRequiredPage.this.getShell(), Messages.getString("AddQueueRequiredPage.AddNewVOTitle"));
                if (dialog.open() == 0) {
                    new TableItem(AddQueueWizardRequiredPage.this.allowedVoTable, 0).setText(dialog.getValue());
                }
            }
        });
        this.editVoButton = new Button(this.tableButtonsComp, 8);
        this.editVoButton.setText(Messages.getString("AddQueueRequiredPage.EditVo"));
        this.editVoButton.setLayoutData((Object)voButtonData);
        this.editVoButton.setEnabled(false);
        this.editVoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] selectedItems = AddQueueWizardRequiredPage.this.allowedVoTable.getSelection();
                if (selectedItems.length == 1) {
                    AllowedVOsDialog dialog = new AllowedVOsDialog(AddQueueWizardRequiredPage.this.getShell(), Messages.getString("AddQueueRequiredPage.AddNewVOTitle"));
                    dialog.setInput(selectedItems[0].getText());
                    if (dialog.open() == 0) {
                        selectedItems[0].setText(dialog.getValue());
                    }
                }
            }
        });
        this.deleteVoButton = new Button(this.tableButtonsComp, 8);
        this.deleteVoButton.setText(Messages.getString("AddQueueRequiredPage.DeleteVo"));
        this.deleteVoButton.setLayoutData((Object)voButtonData);
        this.deleteVoButton.setEnabled(false);
        this.deleteVoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectedItems = AddQueueWizardRequiredPage.this.allowedVoTable.getSelectionIndices();
                if (selectedItems.length > 0) {
                    AddQueueWizardRequiredPage.this.allowedVoTable.remove(selectedItems);
                }
            }
        });
        this.setControl((Control)this.mainComp);
    }

    protected void updateUI() {
        this.setPageComplete(this.isInputValid());
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.isInputValid();
    }

    public boolean isInputValid() {
        boolean isValid = true;
        if (this.nameText.getText().length() == 0) {
            this.setErrorMessage(Messages.getString("AddQueueRequiredPage.Error.QueueName"));
            isValid = false;
        } else {
            this.setErrorMessage(null);
        }
        return isValid;
    }

    protected List<String> getVONames() {
        ArrayList<String> voList = null;
        if (this.allowedVoTable.getItemCount() != 0) {
            voList = new ArrayList<String>();
            TableItem[] tableItemArray = this.allowedVoTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                voList.add(item.getText());
                ++n2;
            }
        }
        return voList;
    }

    protected int getTimeCPU() {
        return this.timeCPUHourSpin.getSelection();
    }

    protected int getTimeWall() {
        return this.timeWallHourSpin.getSelection();
    }

    protected boolean finish(IFile qdlFile) {
        boolean ret = false;
        BatchQueueDescription batchQueueDescription = new BatchQueueDescription(qdlFile);
        try {
            batchQueueDescription.setQueueName(this.nameText.getText().trim());
            String str = this.typeCombo.getText();
            if (str.equals(Messages.getString("AddQueueRequiredPage.Type_Execution"))) {
                batchQueueDescription.queueType(QueueTypeEnumeration.EXECUTION);
            } else {
                batchQueueDescription.queueType(QueueTypeEnumeration.ROUTE);
            }
            if (this.enabledButton.getSelection()) {
                batchQueueDescription.enableQueue(true);
            } else {
                batchQueueDescription.enableQueue(false);
            }
            RangeValueType rangeValueType = QdlFactory.eINSTANCE.createRangeValueType();
            BoundaryType boundaryType = QdlFactory.eINSTANCE.createBoundaryType();
            boundaryType.setValue((double)this.getTimeCPU());
            rangeValueType.setUpperBoundedRange(boundaryType);
            batchQueueDescription.getRoot().getQueue().setCPUTimeLimit(rangeValueType);
            rangeValueType = QdlFactory.eINSTANCE.createRangeValueType();
            boundaryType = QdlFactory.eINSTANCE.createBoundaryType();
            boundaryType.setValue((double)this.getTimeWall());
            rangeValueType.setUpperBoundedRange(boundaryType);
            batchQueueDescription.getRoot().getQueue().setWallTimeLimit(rangeValueType);
            if (this.allowedVoTable.getItemCount() > 0) {
                ArrayList<String> allowedVoList = new ArrayList<String>();
                int i = 0;
                while (i < this.allowedVoTable.getItemCount()) {
                    allowedVoList.add(this.allowedVoTable.getItem(i).getText());
                    ++i;
                }
                batchQueueDescription.setAllowedVirtualOrganizations(allowedVoList);
            }
            batchQueueDescription.save(qdlFile);
            ret = true;
        }
        catch (Exception excp) {
            ProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("AddQueueWizard.error_manipulate_title"), (String)Messages.getString("AddQueueWizard.error_manipulate_message"), (Throwable)excp);
        }
        return ret;
    }
}

