/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch.ui.wizards;

import eu.geclipse.batch.ui.internal.Activator;
import eu.geclipse.batch.ui.internal.Messages;
import eu.geclipse.batch.ui.wizards.MoveJobWizard;
import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.AbstractVirtualOrganization;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.ui.widgets.StoredCombo;
import java.util.Arrays;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MoveJobWizardPage
extends WizardPage {
    private static final String HOSTNAME_STRINGS = "hostname_string";
    private Composite mainComp;
    private Label computingElementLabel;
    private Label queueLabel;
    private StoredCombo computingElementCombo;
    private Text queueText;

    public MoveJobWizardPage() {
        super("MoveJobWizardPage");
        this.setTitle(Messages.getString("MoveJobWizardPage.WindowTitle"));
        this.setDescription(Messages.getString("MoveJobWizardPage.Description"));
    }

    public void createControl(Composite parent) {
        GridData lData = new GridData();
        lData.minimumHeight = 0;
        this.mainComp = new Composite(parent, 0);
        this.mainComp.setLayout((Layout)new GridLayout(2, false));
        GridData gData = new GridData(768);
        gData.grabExcessHorizontalSpace = true;
        this.mainComp.setLayoutData((Object)gData);
        this.computingElementLabel = new Label(this.mainComp, 0);
        this.computingElementLabel.setText(Messages.getString("MoveJobWizardPage.ComputingElementName"));
        this.computingElementLabel.setLayoutData((Object)lData);
        Activator activator = Activator.getDefault();
        IPreferenceStore preferenceStore = activator.getPreferenceStore();
        this.computingElementCombo = new StoredCombo(this.mainComp, 4);
        this.computingElementCombo.setPreferences(preferenceStore, HOSTNAME_STRINGS);
        this.computingElementCombo.setLayoutData((Object)gData);
        this.addComputingElements();
        this.computingElementCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MoveJobWizardPage.this.updateUI();
            }
        });
        this.queueLabel = new Label(this.mainComp, 0);
        this.queueText = this.createEditorField(this.mainComp, this.queueLabel, Messages.getString("MoveJobWizardPage.QueueName"));
        this.queueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MoveJobWizardPage.this.updateUI();
            }
        });
        this.setControl((Control)this.mainComp);
    }

    protected Text createEditorField(Composite parent, Label label, String text) {
        label.setText(text);
        GridData lData = new GridData();
        lData.minimumHeight = 0;
        label.setLayoutData((Object)lData);
        Text editor = new Text(parent, 2048);
        editor.setTextLimit(40);
        GridData eData = new GridData(768);
        eData.grabExcessHorizontalSpace = true;
        eData.minimumHeight = 0;
        editor.setLayoutData((Object)eData);
        return editor;
    }

    protected String getComputingElementName() {
        return this.computingElementCombo.getText().trim();
    }

    protected String getQueueName() {
        return this.queueText.getText().trim();
    }

    protected void updateUI() {
        this.setPageComplete(this.isInputValid());
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.isInputValid();
    }

    public boolean isInputValid() {
        boolean isValid = true;
        if (this.getComputingElementName().length() == 0 && this.getQueueName().length() == 0) {
            this.setErrorMessage(Messages.getString("MoveJobWizardPage.EmptyFieldError"));
            isValid = false;
        } else {
            this.setErrorMessage(null);
        }
        return isValid;
    }

    private void addComputingElements() {
        IVirtualOrganization vo;
        IGridElement[] elements = null;
        IGridProject pro = ((MoveJobWizard)this.getWizard()).getGridProject();
        if (pro != null && (vo = (IVirtualOrganization)pro.getVO().getAdapter(AbstractVirtualOrganization.class)) != null) {
            try {
                IGridInfoService infoService = vo.getInfoService();
                IGridElement[] iGridElementArray = elements = infoService.fetchResources(null, vo, GridResourceCategoryFactory.getCategory((String)"eu.geclipse.core.model.category.computing"), null);
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridComputing comp;
                    String hostname;
                    IGridElement elem = iGridElementArray[n2];
                    if (elem instanceof IGridComputing && (hostname = (comp = (IGridComputing)elem).getHostName()) != null && this.computingElementCombo.indexOf(hostname) == -1) {
                        this.computingElementCombo.add(hostname);
                    }
                    ++n2;
                }
                Object[] items = this.computingElementCombo.getItems();
                if (items != null && items.length > 0) {
                    Arrays.sort(items);
                    this.computingElementCombo.removeAll();
                    this.computingElementCombo.setItems((String[])items);
                }
            }
            catch (ProblemException problemException) {}
        }
    }
}

