/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch;

import eu.geclipse.core.model.IGridSiteConfig;
import eu.geclipse.core.model.impl.ResourceGridContainer;
import eu.geclipse.core.reporting.ProblemException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class BatchConnectionInfo
extends ResourceGridContainer
implements IGridSiteConfig {
    private static final long serialVersionUID = 1L;
    private String batchName;
    private String account;
    private String batchType;
    private int updateInterval;

    public BatchConnectionInfo(IFile file) {
        super((IResource)file);
    }

    public void setConnectionInfo(String bName, String acc, String type, int interval) {
        this.batchName = bName;
        this.account = acc;
        this.batchType = type;
        this.updateInterval = interval;
    }

    public String getAccount() {
        return this.account;
    }

    public String getBatchName() {
        return this.batchName;
    }

    public String getBatchType() {
        return this.batchType;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public void load() throws ProblemException {
        BufferedReader bReader = null;
        try {
            try {
                IFileStore fileStore = this.getFileStore();
                InputStream iStream = fileStore.openInputStream(0, null);
                InputStreamReader iReader = new InputStreamReader(iStream);
                bReader = new BufferedReader(iReader);
                this.batchName = bReader.readLine();
                this.account = bReader.readLine();
                this.batchType = bReader.readLine();
                String str = bReader.readLine();
                if (str == null) {
                    throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", "eu.geclipse.batch");
                }
                this.updateInterval = Integer.parseInt(str);
            }
            catch (IOException ioExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)ioExc, "eu.geclipse.batch");
            }
            catch (CoreException cExc) {
                throw new ProblemException("eu.geclipse.core.problem.model.elementLoadFailed", (Throwable)cExc, "eu.geclipse.batch");
            }
        }
        catch (Throwable throwable) {
            if (bReader != null) {
                try {
                    bReader.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (bReader != null) {
            try {
                bReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void save() throws ProblemException {
        IFileStore fileStore = this.getFileStore();
        try {
            OutputStream oStream = fileStore.openOutputStream(0, null);
            OutputStreamWriter osWriter = new OutputStreamWriter(oStream);
            BufferedWriter bWriter = new BufferedWriter(osWriter);
            bWriter.write(this.batchName);
            bWriter.newLine();
            bWriter.write(this.account);
            bWriter.newLine();
            bWriter.write(this.batchType);
            bWriter.newLine();
            bWriter.write(String.valueOf(this.updateInterval));
            bWriter.close();
        }
        catch (CoreException cExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementSaveFailed", (Throwable)cExc, "eu.geclipse.batch");
        }
        catch (IOException ioExc) {
            throw new ProblemException("eu.geclipse.core.problem.model.elementSaveFailed", (Throwable)ioExc, "eu.geclipse.batch");
        }
    }
}

