/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.batch;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import eu.geclipse.batch.ISSHConnectionInfo;
import eu.geclipse.batch.internal.Activator;
import eu.geclipse.core.IBidirectionalConnection;
import eu.geclipse.core.portforward.ForwardType;
import eu.geclipse.core.portforward.IForward;
import eu.geclipse.core.reporting.IProblem;
import eu.geclipse.core.reporting.ISolution;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.reporting.ReportingPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.jsch.core.IJSchService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSHPersistantConnection
implements IBidirectionalConnection {
    private Session session = null;
    private ISSHConnectionInfo userInfo;
    private ChannelShell channel;

    public void createSession(ISSHConnectionInfo sshConnectionInfo, List<IForward> forwards) throws ProblemException {
        try {
            IJSchService service = Activator.getDefault().getJSchService();
            if (service == null) {
                IProblem problem = ReportingPlugin.getReportingService().getProblem("eu.geclipse.batch.problem.get_ssh_service_failed", null, null, "eu.geclipse.batch");
                throw new ProblemException(problem);
            }
            this.userInfo = sshConnectionInfo;
            this.session = service.createSession(this.userInfo.getHostname(), this.userInfo.getPort(), this.userInfo.getUsername());
            this.session.setUserInfo((UserInfo)this.userInfo);
            if (forwards != null) {
                for (IForward forward : forwards) {
                    if (ForwardType.LOCAL == forward.getType()) {
                        this.session.setPortForwardingL(forward.getBindPort(), forward.getHostname(), forward.getPort());
                        continue;
                    }
                    this.session.setPortForwardingR(forward.getBindPort(), forward.getHostname(), forward.getPort());
                }
            }
            this.session.connect();
        }
        catch (JSchException exception) {
            if (!sshConnectionInfo.getCanceledPWValue()) {
                IProblem problem = ReportingPlugin.getReportingService().getProblem("eu.geclipse.batch.problem.login_failed", null, (Throwable)exception, "eu.geclipse.batch");
                ISolution solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.batch.solution.check_username_password", null);
                problem.addSolution(solution);
                solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.batch.solution.check_ssh_server_config", null);
                problem.addSolution(solution);
                throw new ProblemException(problem);
            }
        }
        catch (Exception exception) {
            Activator.logException(exception);
        }
    }

    public boolean isSessionActive() {
        boolean status = false;
        if (this.session != null) {
            status = this.session.isConnected();
        }
        return status;
    }

    public void close() {
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    public InputStream getInputStream() throws IOException {
        InputStream ret = null;
        if (this.channel != null) {
            ret = this.channel.getInputStream();
        }
        return ret;
    }

    public OutputStream getOutputStream() throws IOException {
        OutputStream ret = null;
        if (this.channel != null) {
            ret = this.channel.getOutputStream();
        }
        return ret;
    }

    public InputStream getErrorStream() throws IOException {
        InputStream ret = null;
        if (this.channel != null) {
            ret = this.channel.getExtInputStream();
        }
        return ret;
    }

    public void connect() throws ProblemException {
        if (!this.isSessionActive()) {
            IProblem problem = ReportingPlugin.getReportingService().getProblem("eu.geclipse.core.problem.net.connectionFailed", null, null, "eu.geclipse.batch");
            ISolution solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.core.solution.net.checkInternetConnection", null);
            problem.addSolution(solution);
            throw new ProblemException(problem);
        }
        try {
            this.channel = (ChannelShell)this.session.openChannel("shell");
            this.channel.connect();
        }
        catch (JSchException jschExc) {
            IProblem problem = ReportingPlugin.getReportingService().getProblem("eu.geclipse.core.problem.net.connectionFailed", null, (Throwable)jschExc, "eu.geclipse.batch");
            ISolution solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.core.solution.net.checkInternetConnection", null);
            problem.addSolution(solution);
            solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.batch.solution.check_username_password", null);
            problem.addSolution(solution);
            solution = ReportingPlugin.getReportingService().getSolution("eu.geclipse.core.solution.net.checkFirewall", null);
            problem.addSolution(solution);
            throw new ProblemException(problem);
        }
    }
}

