/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem;

import eu.geclipse.core.filesystem.internal.Activator;
import eu.geclipse.core.filesystem.internal.filesystem.FileSystemManager;
import eu.geclipse.core.filesystem.internal.filesystem.GEclipseFileStore;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.IFileTree;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class GEclipseFileSystem
extends FileSystem
implements IFileSystem {
    private IFileSystem slave;

    public static IFileStore assureFileStoreIsActive(IFileStore fileStore) {
        if (fileStore instanceof GEclipseFileStore) {
            ((GEclipseFileStore)fileStore).setActive(7);
        }
        return fileStore;
    }

    public static IFileStore setFileStoreActive(IFileStore fileStore, boolean fetchChildren, boolean fetchInfo, boolean modeCopy) {
        if (fileStore instanceof GEclipseFileStore) {
            int active = 0;
            int notactive = 0;
            if (fetchChildren) {
                active |= 1;
            } else {
                notactive |= 1;
            }
            if (fetchInfo) {
                active |= 2;
            } else {
                notactive |= 2;
            }
            if (modeCopy) {
                active |= 4;
            } else {
                notactive |= 4;
            }
            ((GEclipseFileStore)fileStore).setActive(active);
            ((GEclipseFileStore)fileStore).clearActive(notactive);
        }
        return fileStore;
    }

    public int attributes() {
        return this.slave != null ? this.slave.attributes() : super.attributes();
    }

    public boolean canDelete() {
        return this.slave != null ? this.slave.canDelete() : super.canDelete();
    }

    public boolean canWrite() {
        return this.slave != null ? this.slave.canWrite() : super.canWrite();
    }

    public IFileTree fetchFileTree(IFileStore root, IProgressMonitor monitor) {
        IFileTree fileTree = null;
        if (this.slave != null && root instanceof GEclipseFileStore) {
            IFileStore slaveStore = ((GEclipseFileStore)root).getSlave();
            try {
                fileTree = this.slave.fetchFileTree(slaveStore, monitor);
            }
            catch (CoreException cExc) {
                Activator.logException(cExc);
            }
        }
        if (fileTree == null) {
            fileTree = super.fetchFileTree(root, monitor);
        }
        return fileTree;
    }

    public IFileStore getStore(URI uri) {
        GEclipseFileStore result = null;
        FileSystemManager manager = FileSystemManager.getInstance();
        result = manager.getStore(this, uri);
        this.slave = result.getSlave().getFileSystem();
        return result;
    }

    public boolean isCaseSensitive() {
        return this.slave != null ? this.slave.isCaseSensitive() : super.isCaseSensitive();
    }
}

