/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem;

import eu.geclipse.core.ExtensionManager;
import eu.geclipse.core.filesystem.GEclipseFileSystem;
import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.filesystem.Messages;
import eu.geclipse.core.filesystem.TransferInformation;
import eu.geclipse.core.filesystem.TransferRepository;
import eu.geclipse.core.filesystem.internal.Activator;
import eu.geclipse.core.filesystem.internal.filesystem.ConnectionElement;
import eu.geclipse.core.filesystem.internal.filesystem.GEclipseFileStore;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.ITransferInformation;
import eu.geclipse.core.model.ITransferManager;
import eu.geclipse.core.model.ITransferService;
import eu.geclipse.core.reporting.ProblemException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferManager
implements ITransferManager {
    private static final int INF = 10;
    private static final int HIGH = 1;
    private static final int MID = 2;
    private static final int LOW = 3;
    private static TransferManager singleton;
    int counter = 1;
    private List<TransferInformation> pendingTransfers;
    private final boolean useRepo = true;

    private TransferManager() {
        TransferRepository repo = TransferRepository.getTransferRepository();
        this.pendingTransfers = repo.getOperations();
    }

    public static TransferManager getManager() {
        if (singleton == null) {
            singleton = new TransferManager();
        }
        return singleton;
    }

    public List<TransferInformation> getPendingTransfers() {
        return this.pendingTransfers;
    }

    public IStatus resumeTransfer(ITransferInformation transfer, IProgressMonitor monitor) {
        Status status = new Status(0, "eu.geclipse.core.filesystem", "Transfer status", null);
        ITransferService service = this.findService(transfer.getSource().toURI().getScheme(), transfer.getDestination().toURI().getScheme());
        status = service.transfer(transfer, transfer.isMove(), monitor);
        try {
            IContainer[] findContainersForLocationURI;
            IGridElement[] children = GridModel.getConnectionManager().getChildren(monitor);
            IContainer[] iContainerArray = findContainersForLocationURI = GridModel.getRoot().getResource().getWorkspace().getRoot().findContainersForLocationURI(transfer.getDestination().toURI());
            int n = findContainersForLocationURI.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer cont = iContainerArray[n2];
                cont.refreshLocal(1, monitor);
                ++n2;
            }
            if (status.isOK()) {
                iContainerArray = children;
                n = children.length;
                n2 = 0;
                while (n2 < n) {
                    IContainer elem = iContainerArray[n2];
                    if (elem instanceof ConnectionElement) {
                        this.recursiveRefreshChild(transfer.getDestination().toURI(), (ConnectionElement)elem, monitor);
                    }
                    ++n2;
                }
            }
        }
        catch (ProblemException e) {
            Activator.logException(e);
        }
        catch (CoreException e) {
            Activator.logException(e);
        }
        TransferRepository repo = TransferRepository.getTransferRepository();
        repo.delete(transfer.getId());
        return status;
    }

    private void recursiveRefreshChild(URI uri, ConnectionElement element, IProgressMonitor monitor) {
        ConnectionElement resultElement = null;
        try {
            String slaveScheme = new GEclipseURI(element.getConnectionFileStore().toURI()).toSlaveURI().getScheme().toString();
            if (uri.getScheme().equalsIgnoreCase(slaveScheme) && element.hasChildren()) {
                IGridElement[] children;
                IGridElement[] iGridElementArray = children = element.getChildren(monitor);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement child = iGridElementArray[n2];
                    if (child instanceof ConnectionElement) {
                        URI slaveURI = new GEclipseURI(((ConnectionElement)child).getConnectionFileStore().toURI()).toSlaveURI();
                        if (slaveURI.equals(uri)) {
                            resultElement = (ConnectionElement)child;
                            resultElement.refresh(monitor);
                        } else if (((ConnectionElement)child).hasChildren()) {
                            Path uriPath = new Path(uri.getPath());
                            Path slavePath = new Path(slaveURI.getPath());
                            boolean continueSearch = true;
                            int i = 0;
                            while (i < slavePath.segmentCount() && i < uriPath.segmentCount()) {
                                if (!slavePath.segment(i).equals(uriPath.segment(i))) {
                                    continueSearch = false;
                                }
                                ++i;
                            }
                            if (continueSearch) {
                                this.recursiveRefreshChild(uri, (ConnectionElement)child, monitor);
                            }
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (ProblemException e) {
            Activator.logException(e);
        }
        catch (CoreException e) {
            Activator.logException(e);
        }
    }

    public IStatus startTransfer(IFileStore sourceGecl, IFileStore destinationGecl, boolean moveFlag, IProgressMonitor monitor) {
        Status status = new Status(0, "eu.geclipse.core.filesystem", "Transfer status", null);
        IFileStore source = sourceGecl instanceof GEclipseFileStore ? ((GEclipseFileStore)sourceGecl).getSlave() : sourceGecl;
        IFileStore destination = destinationGecl instanceof GEclipseFileStore ? ((GEclipseFileStore)destinationGecl).getSlave() : destinationGecl;
        ITransferService service = this.findService(source.toURI().getScheme(), destination.toURI().getScheme());
        Integer transferId = this.getNextKey();
        TransferInformation op = new TransferInformation(transferId, source, destination, "", source.fetchInfo().getLength());
        Assert.isNotNull((Object)service, (String)"No operation defined for this type of transfer");
        TransferRepository repo = TransferRepository.getTransferRepository();
        repo.save(op);
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        status = service.transfer((ITransferInformation)op, moveFlag, monitor);
        repo.delete(transferId);
        return status;
    }

    private ITransferService findService(String scheme1, String scheme2) {
        DefaultTransferService operation = null;
        ExtensionManager manager = new ExtensionManager();
        List transfers = manager.getConfigurationElements("eu.geclipse.core.filesystem.transferService", "transfer");
        int priority = 10;
        for (IConfigurationElement provider : transfers) {
            if (!provider.getAttribute("source").equalsIgnoreCase(scheme1) || !provider.getAttribute("target").equalsIgnoreCase(scheme2) || Integer.valueOf(provider.getAttribute("priority")) >= priority) continue;
            try {
                operation = (ITransferService)provider.createExecutableExtension("class");
                priority = Integer.valueOf(provider.getAttribute("priority"));
            }
            catch (CoreException e) {
                Activator.logException(e);
            }
        }
        if (operation == null) {
            operation = new DefaultTransferService();
        }
        return operation;
    }

    private synchronized Integer getNextKey() {
        return this.counter++;
    }

    public int registerTransfer(IFileStore source, IFileStore destination) {
        TransferRepository repo = TransferRepository.getTransferRepository();
        Integer transferId = this.getNextKey();
        TransferInformation op = new TransferInformation(transferId, source, destination, "", 0L);
        repo.save(op);
        return transferId;
    }

    public void unregisterTransfer(Integer transferID) {
        TransferRepository repo = TransferRepository.getTransferRepository();
        repo.delete(transferID);
    }

    private class DefaultTransferService
    implements ITransferService {
        private DefaultTransferService() {
        }

        public Status transfer(ITransferInformation transfer, boolean isMove, IProgressMonitor monitor) {
            Status status;
            block38: {
                OutputStream outStream;
                InputStream inStream;
                block37: {
                    status = new Status(0, "eu.geclipse.core.filesystem", "Transfer status", null);
                    boolean transferStatus = true;
                    IFileStore from = transfer.getSource();
                    IFileStore to = transfer.getDestination();
                    IFileStore targetFile = null;
                    monitor.beginTask(String.valueOf(Messages.getString("TransferManager.copying_progress")) + from.getName(), 100);
                    monitor.setTaskName(String.valueOf(Messages.getString("TransferManager.copying_progress")) + from.getName());
                    inStream = null;
                    outStream = null;
                    if (from instanceof GEclipseFileStore) {
                        ((GEclipseFileStore)from).setActive(2);
                    }
                    try {
                        try {
                            IFileInfo sourceFileInfo = from.fetchInfo(0, (IProgressMonitor)new NullProgressMonitor());
                            if (!sourceFileInfo.exists()) break block37;
                            if (!sourceFileInfo.isDirectory()) {
                                long length = sourceFileInfo.getLength();
                                if (transferStatus) {
                                    try {
                                        inStream = from.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                                    }
                                    catch (CoreException cExc) {
                                        transferStatus = false;
                                        status = new Status(4, "eu.geclipse.core.filesystem", String.format("Error opening input stream for %s", from.toURI()), (Throwable)cExc);
                                    }
                                }
                                if (transferStatus) {
                                    try {
                                        IFileInfo fileInfo = to.fetchInfo();
                                        if (fileInfo.exists()) {
                                            targetFile = fileInfo.isDirectory() ? to.getChild(from.getName()) : to.getParent().getChild(from.getName());
                                            outStream = targetFile.openOutputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 8));
                                        } else {
                                            transferStatus = false;
                                            status = new Status(4, "eu.geclipse.core.filesystem", String.format("Error opening input stream for %s", from.toURI()), null);
                                        }
                                    }
                                    catch (CoreException cExc) {
                                        transferStatus = false;
                                        status = new Status(4, "eu.geclipse.core.filesystem", String.format("Error opening output stream for %s", targetFile.toURI()), (Throwable)cExc);
                                    }
                                }
                                if (!transferStatus || inStream == null || outStream == null) break block37;
                                byte[] buffer = new byte[0x100000];
                                Integer totalKb = (int)Math.ceil((double)length / 1024.0);
                                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 84);
                                subMonitor.beginTask(String.valueOf(Messages.getString("TransferManager.copying_progress")) + from.getName(), (int)length);
                                subMonitor.subTask(String.valueOf(Messages.getString("TransferManager.copying_progress")) + from.getName());
                                long byteCounter = 0L;
                                while (!subMonitor.isCanceled() && transferStatus) {
                                    int bytesRead = -1;
                                    try {
                                        bytesRead = inStream.read(buffer);
                                    }
                                    catch (IOException ioExc) {
                                        transferStatus = false;
                                        status = new Status(4, "eu.geclipse.core.filesystem", String.format("Error reading from %s", from.toURI()), (Throwable)ioExc);
                                    }
                                    if (bytesRead == -1) break;
                                    try {
                                        outStream.write(buffer, 0, bytesRead);
                                    }
                                    catch (IOException ioExc) {
                                        transferStatus = false;
                                        status = new Status(4, "eu.geclipse.core.filesystem", String.format("Error writing to %s", to.toURI()), (Throwable)ioExc);
                                    }
                                    subMonitor.worked(bytesRead);
                                    subMonitor.subTask(String.format(Messages.getString("TransferManager.transfer_progress_format"), sourceFileInfo.getName(), (int)(100.0 * (double)(byteCounter += (long)bytesRead) / (double)length), (int)(byteCounter / 1024L), totalKb));
                                }
                                subMonitor.done();
                                break block37;
                            }
                            this.copyDirectory(from, to, isMove, monitor);
                        }
                        catch (Exception exc) {
                            status = new Status(4, "eu.geclipse.core.filesystem", String.format("Error during transfering %s", from.toURI()), (Throwable)exc);
                            monitor.subTask(Messages.getString("TransferManager.closing_streams"));
                            if (outStream != null) {
                                try {
                                    outStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (inStream != null) {
                                try {
                                    inStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            monitor.done();
                            break block38;
                        }
                    }
                    catch (Throwable throwable) {
                        monitor.subTask(Messages.getString("TransferManager.closing_streams"));
                        if (outStream != null) {
                            try {
                                outStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (inStream != null) {
                            try {
                                inStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        monitor.done();
                        throw throwable;
                    }
                }
                monitor.subTask(Messages.getString("TransferManager.closing_streams"));
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {}
                }
                monitor.done();
            }
            return status;
        }

        private IStatus copyDirectory(IFileStore from, IFileStore to, boolean isMove, IProgressMonitor monitor) {
            IStatus status;
            block11: {
                status = Status.OK_STATUS;
                monitor.beginTask(String.valueOf(Messages.getString("TransferManager.copying_progress")) + from.getName(), 10);
                try {
                    IFileStore[] children = null;
                    try {
                        GEclipseFileSystem.assureFileStoreIsActive(from);
                        children = from.childStores(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException cExc) {
                        status = new Status(4, "eu.geclipse.core.filesystem", 0, String.valueOf(Messages.getString("TransferManager.fetching_children_error")) + from.getName(), (Throwable)cExc);
                    }
                    if (!status.isOK() || children == null) break block11;
                    IFileStore newTo = null;
                    newTo = to.fetchInfo().isDirectory() ? to.getChild(from.getName()) : to.getParent().getChild(from.getName());
                    IFileInfo newToInfo = newTo.fetchInfo();
                    boolean mkdir = !newToInfo.exists();
                    SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 9);
                    subMonitor.beginTask(String.valueOf(Messages.getString("TransferManager.copying_progress")) + from.getName(), mkdir ? children.length + 1 : children.length);
                    if (mkdir) {
                        try {
                            newTo.mkdir(0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1));
                        }
                        catch (CoreException cExc) {
                            status = new Status(4, "eu.geclipse.core.filesystem", 0, String.valueOf(Messages.getString("TransferManager.create_dir_error")) + newTo.getName(), (Throwable)cExc);
                        }
                    }
                    if (status.isOK()) {
                        MultiStatus mStatus = new MultiStatus("eu.geclipse.core.filesystem", 0, String.valueOf(Messages.getString("TransferManager.copying_members_status")) + from.getName(), null);
                        IFileStore[] iFileStoreArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFileStore child = iFileStoreArray[n2];
                            TransferInformation childTransfer = new TransferInformation(0, child, newTo, "", 0L);
                            status = this.transfer(childTransfer, isMove, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1));
                            if (subMonitor.isCanceled()) break;
                            ++n2;
                        }
                        if (!mStatus.isOK()) {
                            status = mStatus;
                        }
                    }
                }
                finally {
                    monitor.done();
                }
            }
            return status;
        }
    }
}

