/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem.internal.filesystem;

import eu.geclipse.core.filesystem.GEclipseFileSystem;
import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.filesystem.internal.Activator;
import eu.geclipse.core.filesystem.internal.filesystem.FileStoreRegistry;
import eu.geclipse.core.filesystem.internal.filesystem.GEclipseFileStore;
import eu.geclipse.core.filesystem.internal.filesystem.Messages;
import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IMountable;
import eu.geclipse.core.model.IProtectable;
import eu.geclipse.core.model.impl.AbstractGridContainer;
import eu.geclipse.core.model.impl.ContainerMarker;
import eu.geclipse.core.reporting.ProblemException;
import java.net.URI;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionElement
extends AbstractGridContainer
implements IGridConnectionElement {
    private static Hashtable<Class<? extends IGridElement>, List<IGridElementCreator>> adapters;
    private static String MOUNT_UID;
    private IResource resource;
    private Throwable fetchError;

    static {
        MOUNT_UID = Messages.getString("ConnectionElement.mount_uid");
    }

    public ConnectionElement(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.resource = resource;
    }

    public boolean canAdaptToElement(Class<? extends IGridElement> type) {
        List<IGridElementCreator> elementAdapters = ConnectionElement.getElementAdapters(this, type);
        return !elementAdapters.isEmpty();
    }

    public boolean canContain(IGridElement element) {
        return this.isFolder();
    }

    public void dispose() {
        try {
            IFileStore fileStore = this.getConnectionFileStore();
            if (fileStore != null) {
                FileStoreRegistry registry = FileStoreRegistry.getInstance();
                registry.removeStore(fileStore);
            }
        }
        catch (CoreException cExc) {
            Activator.logException(cExc);
        }
        super.dispose();
    }

    public IGridElement getElementAdapter(Class<? extends IGridElement> type) {
        IGridElement result = null;
        List<IGridElementCreator> elementAdapters = ConnectionElement.getElementAdapters(this, type);
        IResource res = this.getResource();
        for (IGridElementCreator adapter : elementAdapters) {
            try {
                adapter.setSource((Object)res);
                result = adapter.create(this.getParent());
            }
            catch (ProblemException problemException) {}
        }
        return result;
    }

    public IFileInfo getConnectionFileInfo() throws CoreException {
        return this.getConnectionFileStore().fetchInfo();
    }

    public IFileStore getCachedConnectionFileStore(IProgressMonitor monitor) throws CoreException {
        IFileStore result = null;
        SubMonitor sMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            result = this.getConnectionFileStore();
            sMonitor.worked(1);
            ((GEclipseFileStore)result).cacheInputStream(this, monitor);
            sMonitor.worked(9);
        }
        finally {
            sMonitor.done();
        }
        return result;
    }

    public IFileStore getConnectionFileStore() throws CoreException {
        URI uri;
        IFileStore result = null;
        IResource res = this.getResource();
        if (res != null && (uri = res.getLocationURI()) != null) {
            GEclipseFileSystem fileSystem = (GEclipseFileSystem)EFS.getFileSystem((String)GEclipseURI.getScheme());
            result = fileSystem.getStore(uri);
        }
        return result;
    }

    public String getError() {
        String error = null;
        if (this.fetchError != null) {
            error = this.fetchError.getLocalizedMessage();
        }
        return error;
    }

    public IMountable.MountPoint getMountPoint(IMountable.MountPointID mountID) {
        IMountable.MountPoint result = null;
        if (MOUNT_UID.equals(mountID.getUID())) {
            result = new IMountable.MountPoint(this.getName(), this.getURI());
        }
        return result;
    }

    public IMountable.MountPointID[] getMountPointIDs() {
        IMountable.MountPointID[] result = null;
        result = new IMountable.MountPointID[]{new IMountable.MountPointID(MOUNT_UID, this.getURI().getScheme())};
        return result;
    }

    public URI getURI() {
        URI result = null;
        try {
            GEclipseFileStore fileStore = (GEclipseFileStore)this.getConnectionFileStore();
            result = fileStore.getSlave().toURI();
        }
        catch (CoreException cExc) {
            Activator.logException(cExc);
        }
        return result;
    }

    public boolean hasChildren() {
        return this.isFolder() ? super.hasChildren() : false;
    }

    public boolean isFolder() {
        return this.getResource().getType() == 2;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isLazy() {
        return true;
    }

    public boolean isLocal() {
        boolean result = false;
        try {
            GEclipseFileStore fileStore = (GEclipseFileStore)this.getConnectionFileStore();
            result = fileStore.isLocal();
        }
        catch (CoreException cExc) {
            Activator.logException(cExc);
        }
        return result;
    }

    public boolean isValid() {
        return this.getError() == null;
    }

    public void releaseCachedConnectionFileStore(IFileStore fileStore) {
        if (fileStore instanceof GEclipseFileStore) {
            ((GEclipseFileStore)fileStore).discardCachedInputStream();
        }
    }

    protected IStatus fetchChildren(IProgressMonitor monitor) {
        IStatus result;
        SubMonitor sMonitor;
        block11: {
            sMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)String.format(Messages.getString("ConnectionElement.fetching_children_progress"), this.getName()), (int)100);
            result = Status.CANCEL_STATUS;
            this.fetchError = null;
            try {
                try {
                    IResource res = this.getResource();
                    GEclipseFileStore fileStore = (GEclipseFileStore)this.getConnectionFileStore();
                    fileStore.setActive(1);
                    fileStore.childNames(0, (IProgressMonitor)sMonitor.newChild(90));
                    SubMonitor ssMonitor = sMonitor.newChild(10);
                    ssMonitor.subTask(Messages.getString("ConnectionElement.task_refreshing"));
                    fileStore.setExternalMonitor((IProgressMonitor)ssMonitor);
                    res.refreshLocal(1, (IProgressMonitor)ssMonitor);
                    fileStore.setExternalMonitor(null);
                    result = Status.OK_STATUS;
                    if (res instanceof IContainer) {
                        IResource[] members = ((IContainer)res).members();
                        if (members == null || members.length == 0) {
                            this.addElement((IGridElement)ContainerMarker.getEmptyFolderMarker((IGridContainer)this));
                        } else {
                            IResource[] iResourceArray = members;
                            int n = members.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IResource member = iResourceArray[n2];
                                this.addElement((IGridElement)new ConnectionElement(member));
                                ++n2;
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    this.fetchError = t;
                    result = new Status(4, "eu.geclipse.core.filesystem", Messages.getString("ConnectionElement.fetch_error"), t);
                    try {
                        this.addElement((IGridElement)ContainerMarker.getErrorMarker((IGridContainer)this, (Throwable)t));
                    }
                    catch (ProblemException pExc) {
                        Activator.logException(pExc);
                    }
                    sMonitor.done();
                    break block11;
                }
            }
            catch (Throwable throwable) {
                sMonitor.done();
                throw throwable;
            }
            sMonitor.done();
        }
        return sMonitor.isCanceled() ? Status.CANCEL_STATUS : result;
    }

    public IFileStore getFileStore() {
        IResource res = this.getResource();
        IPath path = res.getWorkspace().getRoot().getLocation().append(res.getFullPath());
        IFileSystem fileSystem = EFS.getLocalFileSystem();
        IFileStore fileStore = fileSystem.getStore(path);
        return fileStore;
    }

    public String getName() {
        return this.getResource().getName();
    }

    public IGridContainer getParent() {
        IGridContainer parent = null;
        IPath parentPath = this.getPath().removeLastSegments(1);
        IGridElement parentElement = GridModel.getRoot().findElement(parentPath);
        if (parentElement instanceof IGridContainer) {
            parent = (IGridContainer)parentElement;
        }
        return parent;
    }

    public IPath getPath() {
        return this.getResource().getFullPath();
    }

    public IResource getResource() {
        return this.resource;
    }

    private static List<IGridElementCreator> getElementAdapters(IGridConnectionElement source, Class<? extends IGridElement> target) {
        List result = null;
        if (adapters != null) {
            result = adapters.get(target);
        }
        if (result == null) {
            IResource resource = source.getResource();
            result = GridModel.getCreatorRegistry().getCreators(resource.getClass(), target);
            if (!result.isEmpty()) {
                if (adapters == null) {
                    adapters = new Hashtable();
                }
                adapters.put(target, result);
            }
        }
        return result;
    }

    public void refresh(IProgressMonitor monitor) throws ProblemException {
        try {
            IFileStore fileStore = this.getConnectionFileStore();
            if (fileStore instanceof GEclipseFileStore) {
                GEclipseFileStore geclFS = (GEclipseFileStore)fileStore;
                geclFS.setActive(1);
            }
        }
        catch (CoreException exception) {
            Activator.logException(exception);
        }
        super.refresh(monitor);
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        if (adapter == IProtectable.class) {
            try {
                result = this.getConnectionFileStore().getAdapter(adapter);
            }
            catch (CoreException ce) {
                Activator.logException(ce);
            }
        }
        if (result == null) {
            result = super.getAdapter(adapter);
        }
        return result;
    }
}

