/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.filesystem.internal.filesystem;

import eu.geclipse.core.filesystem.GEclipseFileSystem;
import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.filesystem.internal.Activator;
import eu.geclipse.core.filesystem.internal.filesystem.FileStoreRegistry;
import eu.geclipse.core.filesystem.internal.filesystem.GEclipseFileStore;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;

public class FileSystemManager {
    private static FileSystemManager instance;

    private FileSystemManager() {
    }

    public static FileSystemManager getInstance() {
        if (instance == null) {
            instance = new FileSystemManager();
        }
        return instance;
    }

    public GEclipseFileStore getStore(GEclipseFileSystem fileSystem, URI uri) {
        GEclipseURI geclURI = new GEclipseURI(uri);
        FileStoreRegistry registry = FileStoreRegistry.getInstance();
        GEclipseFileStore result = registry.getStore(geclURI);
        if (result == null) {
            try {
                IFileStore slaveStore = FileSystemManager.getSlaveStore(geclURI);
                result = new GEclipseFileStore(fileSystem, slaveStore);
                registry.putStore(result);
            }
            catch (CoreException cExc) {
                Activator.logException(cExc);
            }
        }
        return result;
    }

    private static IFileStore getSlaveStore(GEclipseURI uri) throws CoreException {
        IFileSystem slaveSystem = FileSystemManager.getSlaveSystem(uri);
        return slaveSystem.getStore(uri.toSlaveURI());
    }

    private static IFileSystem getSlaveSystem(GEclipseURI uri) throws CoreException {
        return EFS.getFileSystem((String)uri.getSlaveScheme());
    }
}

