/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.reporting.internal;

import eu.geclipse.core.reporting.IProblem;
import eu.geclipse.core.reporting.ISolution;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.core.reporting.internal.Solution;
import eu.geclipse.core.reporting.internal.SolutionFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class Problem
implements IProblem {
    private String description;
    private Throwable exception;
    private String id;
    private String mailto;
    private String pluginID;
    private List<String> reasons;
    private List<ISolution> solutions;

    public Problem(String id, String description, Throwable exception, String mailto, String pluginID) {
        this.id = id;
        this.description = description;
        this.exception = exception;
        this.mailto = mailto;
        this.pluginID = pluginID;
    }

    public void addReason(String reason) {
        if (this.reasons == null) {
            this.reasons = new ArrayList<String>();
        }
        if (!this.reasons.contains(reason)) {
            this.reasons.add(reason);
        }
    }

    public void addSolution(ISolution solution) {
        String solutionID;
        if (this.solutions == null) {
            this.solutions = new ArrayList<ISolution>();
        }
        if ((solutionID = solution.getID()) != null) {
            for (ISolution s : this.solutions) {
                if (!solutionID.equals(s.getID())) continue;
                this.solutions.remove(s);
                break;
            }
        }
        this.solutions.add(solution);
    }

    public void addSolution(String solutionID, String desc) {
        SolutionFactory factory = SolutionFactory.getFactory();
        Solution solution = factory.getSolution(solutionID, desc);
        if (solution != null) {
            this.addSolution(solution);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getID() {
        return this.id;
    }

    public String getMailTo() {
        return this.mailto;
    }

    public String getPluginID() {
        return this.pluginID;
    }

    public String[] getReasons() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.reasons != null) {
            result.addAll(this.reasons);
        }
        if (this.exception != null && this.exception instanceof ProblemException) {
            IProblem slave = ((ProblemException)((Object)this.exception)).getProblem();
            result.addAll((Collection)Arrays.asList(slave.getReasons()));
        }
        return result.toArray(new String[result.size()]);
    }

    public ISolution[] getSolutions() {
        ArrayList<ISolution> result = new ArrayList<ISolution>();
        if (this.solutions != null) {
            result.addAll(this.solutions);
        }
        if (this.exception != null && this.exception instanceof ProblemException) {
            IProblem slave = ((ProblemException)((Object)this.exception)).getProblem();
            ISolution[] iSolutionArray = slave.getSolutions();
            int n = iSolutionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ISolution solution = iSolutionArray[n2];
                if (!result.contains(solution)) {
                    result.add(solution);
                }
                ++n2;
            }
        }
        return result.toArray(new ISolution[result.size()]);
    }

    public boolean hasReasons() {
        return this.reasons != null && !this.reasons.isEmpty();
    }

    public boolean hasSolutions() {
        return this.solutions != null && !this.solutions.isEmpty();
    }

    public IStatus getStatus() {
        Status result = null;
        String pid = this.getPluginID();
        if (pid == null) {
            pid = "eu.geclipse.core.reporting";
        }
        int code = 0;
        if (this.getID() != null) {
            code = this.getID().hashCode();
        }
        if (this.hasReasons()) {
            String[] reasonList = this.getReasons();
            result = new MultiStatus(pid, code, this.getDescription(), this.getException());
            String[] stringArray = reasonList;
            int n = reasonList.length;
            int n2 = 0;
            while (n2 < n) {
                String reason = stringArray[n2];
                Status status = new Status(4, pid, code, reason, null);
                ((MultiStatus)result).add((IStatus)status);
                ++n2;
            }
        } else {
            result = new Status(4, pid, code, this.getDescription(), this.getException());
        }
        return result;
    }

    public void merge(IProblem problem) {
        ISolution[] sols;
        int n;
        String[] reas;
        String desc = problem.getDescription();
        if (desc != null) {
            this.addReason(desc);
        }
        if ((reas = problem.getReasons()) != null) {
            String[] stringArray = reas;
            n = reas.length;
            int n2 = 0;
            while (n2 < n) {
                String r = stringArray[n2];
                this.addReason(r);
                ++n2;
            }
        }
        if ((sols = problem.getSolutions()) != null) {
            ISolution[] iSolutionArray = sols;
            int n3 = sols.length;
            n = 0;
            while (n < n3) {
                ISolution sol = iSolutionArray[n];
                this.addSolution(sol);
                ++n;
            }
        }
    }
}

