/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.info.ui;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.info.InfoCacheListenerHandler;
import eu.geclipse.info.glue.AbstractGlueTable;
import eu.geclipse.info.glue.GlueCE;
import eu.geclipse.info.glue.GlueCEAccessControlBaseRule;
import eu.geclipse.info.glue.GlueQuery;
import eu.geclipse.info.model.FetchJob;
import eu.geclipse.info.model.IExtendedGridInfoService;
import eu.geclipse.info.model.IGlueStoreChangeListerner;
import eu.geclipse.info.model.InfoTopTreeCategory;
import eu.geclipse.info.model.InfoTopTreeElement;
import eu.geclipse.info.ui.FilterAction;
import eu.geclipse.info.ui.GlueInfoComparator;
import eu.geclipse.info.ui.InfoViewFilterShowFilledElements;
import eu.geclipse.info.ui.InfoViewerFilter;
import eu.geclipse.info.ui.internal.Activator;
import eu.geclipse.info.ui.internal.Messages;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class GlueInfoViewer
extends ViewPart
implements ISelectionProvider,
IGlueStoreChangeListerner,
IGridModelListener {
    FetchJob fetchJob;
    TreeViewer viewer;
    boolean showOnlyFilledInfoElements = false;
    private String currentVO = null;
    private DrillDownAdapter drillDownAdapter;
    private boolean SHOW_VO_LIST = false;
    private Combo comboVOList;
    private Label label = null;

    public GlueInfoViewer() {
        InfoCacheListenerHandler.getInstance().addListener((IGlueStoreChangeListerner)this);
        GridModel.getRoot().addGridModelListener((IGridModelListener)this);
        this.fetchJob = FetchJob.getInstance((String)" Retrieving Information");
        this.showOnlyFilledInfoElements = false;
        this.fetchJob.schedule();
    }

    public void createPartControl(Composite parent) {
        GridData gData;
        GridLayout parentLayout = new GridLayout(3, false);
        parentLayout.marginBottom = parentLayout.marginTop = 0;
        parentLayout.marginLeft = parentLayout.marginTop;
        parentLayout.marginRight = parentLayout.marginTop;
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parent.setLayout((Layout)parentLayout);
        if (this.SHOW_VO_LIST) {
            this.label = new Label(parent, 0);
            this.label.setText("VO:");
            gData = new GridData();
            this.label.setLayoutData((Object)gData);
            this.comboVOList = new Combo(parent, 0);
            gData = new GridData(768);
            gData.widthHint = 150;
            gData.verticalAlignment = 2;
            this.comboVOList.setLayoutData((Object)gData);
        }
        this.viewer = new TreeViewer(parent, 770);
        gData = new GridData(1808);
        gData.grabExcessHorizontalSpace = true;
        gData.grabExcessVerticalSpace = true;
        gData.horizontalSpan = 3;
        this.viewer.getTree().setLayoutData((Object)gData);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.setComparer((IElementComparer)new GlueInfoComparator());
        ViewerFilter[] initialFilters = new ViewerFilter[]{new InfoViewerFilter(), new InfoViewerFilter()};
        this.viewer.setFilters(initialFilters);
        if (this.SHOW_VO_LIST) {
            this.comboVOList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    GlueInfoViewer.this.updateVOList();
                }

                public void widgetSelected(SelectionEvent arg0) {
                    GlueInfoViewer.this.setCurrentVO(GlueInfoViewer.this.comboVOList.getText());
                    GlueInfoViewer.this.viewer.refresh();
                }
            });
        }
        this.hookContextMenu();
        this.contributeToActionBars();
        this.setCurrentVO("none");
    }

    void updateVOList() {
        ArrayList agtList = GlueQuery.getGlueTable((String)"GlueCEAccessControlBaseRule", (String)"GlueCEAccessControlBaseRule", null);
        ArrayList<String> vos = new ArrayList<String>();
        int i = 0;
        for (AbstractGlueTable table : agtList) {
            GlueCEAccessControlBaseRule rule = (GlueCEAccessControlBaseRule)table;
            String[] s = rule.Value.split(":");
            if (!s[0].equals("VO") || s[1] == null) continue;
            vos.add(s[1]);
        }
        Object[] voArray = new String[vos.size()];
        i = 0;
        for (String voString : vos) {
            voArray[i++] = voString;
        }
        Arrays.sort(voArray);
        this.comboVOList.setItems((String[])voArray);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("Information Source");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GlueInfoViewer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        ArrayList<InfoViewerFilter> infoFilterArray = new ArrayList<InfoViewerFilter>();
        InfoViewerFilter infoFilter = null;
        IExtensionRegistry myRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = myRegistry.getExtensionPoint("eu.geclipse.info.infoViewerFilter");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements;
            IExtension extension = extensions[i];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    infoFilter = (InfoViewerFilter)((Object)element.createExecutableExtension("class"));
                    if (infoFilter != null) {
                        infoFilterArray.add(infoFilter);
                    }
                }
                catch (CoreException coreException) {}
                ++n2;
            }
            ++i;
        }
        FilterAction filterAction = new FilterAction(null, this.viewer);
        filterAction.setText("Show everything");
        filterAction.setToolTipText("Show everything");
        filterAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        manager.add((IAction)filterAction);
        int i2 = 0;
        while (i2 < infoFilterArray.size()) {
            filterAction = new FilterAction((InfoViewerFilter)((Object)infoFilterArray.get(i2)), this.viewer);
            filterAction.setText(((InfoViewerFilter)((Object)infoFilterArray.get(i2))).getText());
            filterAction.setToolTipText(((InfoViewerFilter)((Object)infoFilterArray.get(i2))).getText());
            filterAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
            manager.add((IAction)filterAction);
            ++i2;
        }
    }

    void fillContextMenu(IMenuManager manager) {
        TreeParent tp;
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof TreeParent && (tp = (TreeParent)obj).getAgt() instanceof GlueCE) {
            manager.add((IContributionItem)new Separator());
        }
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        Action refreshAction = new Action(){

            public void run() {
                GlueInfoViewer.this.fetchJob.schedule();
            }
        };
        refreshAction.setToolTipText(Messages.getString("GlueInfoView.refresh"));
        URL imgUrl = Activator.getDefault().getBundle().getEntry("icons/elcl16/refresh_nav.gif");
        refreshAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        manager.add((IAction)refreshAction);
        Action showFilledInfoElementsAction = new Action(){

            public void run() {
                URL imageURL = null;
                if (GlueInfoViewer.this.showOnlyFilledInfoElements) {
                    GlueInfoViewer.this.showOnlyFilledInfoElements = false;
                    this.setToolTipText(Messages.getString("GlueInfoView.showOnlyFilledInfoElements"));
                    imageURL = Activator.getDefault().getBundle().getEntry("icons/elcl16/hide.png");
                    this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imageURL));
                    ViewerFilter[] myViewerFilter = GlueInfoViewer.this.viewer.getFilters();
                    myViewerFilter[0] = new InfoViewerFilter();
                    GlueInfoViewer.this.viewer.setFilters(myViewerFilter);
                } else {
                    GlueInfoViewer.this.showOnlyFilledInfoElements = true;
                    this.setToolTipText(Messages.getString("GlueInfoView.showAllInfoElements"));
                    imageURL = Activator.getDefault().getBundle().getEntry("icons/elcl16/show_all.png");
                    this.setImageDescriptor(ImageDescriptor.createFromURL((URL)imageURL));
                    ViewerFilter[] myViewerFilter = GlueInfoViewer.this.viewer.getFilters();
                    myViewerFilter[0] = new InfoViewFilterShowFilledElements();
                    GlueInfoViewer.this.viewer.setFilters(myViewerFilter);
                }
                GlueInfoViewer.this.viewer.refresh();
            }
        };
        imgUrl = Activator.getDefault().getBundle().getEntry("icons/elcl16/hide.png");
        showFilledInfoElementsAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)imgUrl));
        showFilledInfoElementsAction.setToolTipText(Messages.getString("GlueInfoView.showOnlyFilledInfoElements"));
        manager.add((IAction)showFilledInfoElementsAction);
        this.drillDownAdapter.addNavigationActions(manager);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public String getCurrentVO() {
        return this.currentVO;
    }

    public void setCurrentVO(String currentVO) {
        this.currentVO = currentVO;
    }

    public void addSelectionChangedListener(ISelectionChangedListener arg0) {
        this.viewer.addSelectionChangedListener(arg0);
    }

    public ISelection getSelection() {
        this.viewer.getSelection();
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener arg0) {
        this.viewer.removeSelectionChangedListener(arg0);
    }

    public void setSelection(ISelection arg0) {
        this.viewer.setSelection(arg0);
    }

    public void infoChanged() {
        this.getSite().getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                if (GlueInfoViewer.this.SHOW_VO_LIST) {
                    GlueInfoViewer.this.updateVOList();
                }
                Object[] currentExpanded = GlueInfoViewer.this.viewer.getExpandedElements();
                GlueInfoViewer.this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
                GlueInfoViewer.this.viewer.refresh();
                GlueInfoViewer.this.viewer.setExpandedElements(currentExpanded);
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)"Grid Information View", (String)message);
    }

    public void dispose() {
        InfoCacheListenerHandler.getInstance().removeListener((IGlueStoreChangeListerner)this);
        GridModel.getRoot().removeGridModelListener((IGridModelListener)this);
    }

    public void gridModelChanged(IGridModelEvent event) {
        int type = event.getType();
        block0 : switch (type) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                IGridElement[] iGridElementArray = event.getElements();
                int n = iGridElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridElement gridElement = iGridElementArray[n2];
                    if (gridElement instanceof IGridProject) {
                        FetchJob myFetchJob = FetchJob.getInstance((String)" Retrieving Information");
                        myFetchJob.schedule();
                        break block0;
                    }
                    ++n2;
                }
                break;
            }
        }
    }

    static class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }

        public int compare(Viewer myViewer, Object p1, Object p2) {
            int result = 0;
            result = p1 instanceof TreeParent && !(p2 instanceof TreeParent) || p2 instanceof TreeParent && !(p1 instanceof TreeParent) ? (p1 instanceof TreeParent ? -1 : (p2 instanceof TreeParent ? 1 : super.compare(myViewer, p1, p2))) : super.compare(myViewer, p1, p2);
            return result;
        }
    }

    public class TreeObject
    implements IAdaptable {
        private String prefix;
        private String name;
        private TreeParent parent;

        public TreeObject(String name, String prefix) {
            this.name = name;
            this.prefix = prefix;
        }

        public String getName() {
            return this.name;
        }

        public void setParent(TreeParent parent) {
            this.parent = parent;
        }

        public TreeParent getParent() {
            return this.parent;
        }

        public String toString() {
            return String.valueOf(this.prefix != null ? String.valueOf(this.prefix) + ": " : "") + this.getName();
        }

        public Object getAdapter(Class key) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TreeParent
    extends TreeObject {
        private AbstractGlueTable agt;
        private ArrayList<AbstractGlueTable> agtList;
        private ArrayList<InfoTopTreeElement> queries;
        private InfoTopTreeElement query;

        public TreeParent(AbstractGlueTable agt, String prefix) {
            super(agt.getDisplayName(), prefix);
            this.setAgt(agt);
        }

        public TreeParent(String name, InfoTopTreeElement query, ArrayList<AbstractGlueTable> agtList) {
            super(name, null);
            this.agtList = agtList;
            this.query = query;
        }

        public TreeParent(String name, ArrayList<AbstractGlueTable> agtList) {
            super(name, null);
            this.agtList = agtList;
        }

        public TreeParent(ArrayList<InfoTopTreeElement> queries) {
            super("", null);
            this.queries = queries;
        }

        public InfoTopTreeElement getQuery() {
            return this.query;
        }

        public TreeObject[] getChildren() {
            ArrayList<TreeParent> toList = new ArrayList<TreeParent>();
            if (this.queries != null) {
                for (InfoTopTreeElement s : this.queries) {
                    toList.add(new TreeParent(s.getDisplayName(), s, null));
                }
            }
            if (this.query != null) {
                this.agtList = new ArrayList();
                int i = 0;
                while (i < this.query.getGlueInfoTopTreeCategory().size()) {
                    String myObjectTableName = ((InfoTopTreeCategory)this.query.getGlueInfoTopTreeCategory().get(i)).getObjectTableName();
                    String myGlueObjectName = ((InfoTopTreeCategory)this.query.getGlueInfoTopTreeCategory().get(i)).getGlueObjectName();
                    this.agtList.addAll(GlueQuery.getGlueTable((String)myGlueObjectName, (String)myObjectTableName, (String)GlueInfoViewer.this.getCurrentVO()));
                    ++i;
                }
            }
            if (this.getAgt() != null) {
                Field[] fields = this.getAgt().getClass().getFields();
                int i = 0;
                while (i < fields.length) {
                    Field field = fields[i];
                    try {
                        TreeObject to;
                        String fieldName = field.getName();
                        Object value = field.get(this.getAgt());
                        if (fieldName.endsWith("List")) {
                            ArrayList list = (ArrayList)value;
                            to = new TreeParent(fieldName, list);
                            toList.add((TreeParent)to);
                        } else if (value instanceof AbstractGlueTable) {
                            AbstractGlueTable agt1 = (AbstractGlueTable)value;
                            toList.add(new TreeParent(agt1, agt1.tableName));
                        } else if (!(fieldName.equals("byRefOnly") || fieldName.equals("key") || fieldName.equals("keyName") || fieldName.equals("tableName") || fieldName.equals("glueIndex") || fieldName.equals("glueService") || fieldName.equals("displayName"))) {
                            String s = String.valueOf(fieldName) + " = " + (value == null || value == "" ? "Not available from the information service" : value.toString());
                            to = new TreeObject(s, null);
                            toList.add((TreeParent)to);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Activator.logException(e);
                    }
                    catch (IllegalAccessException e) {
                        Activator.logException(e);
                    }
                    ++i;
                }
            }
            if (this.agtList != null) {
                for (AbstractGlueTable table : this.agtList) {
                    if (table.getID() == null || table.byRefOnly) continue;
                    toList.add(new TreeParent(table, null));
                }
            }
            TreeObject[] treeObjectArray = toList.toArray(new TreeObject[toList.size()]);
            return treeObjectArray;
        }

        public boolean hasChildren() {
            boolean hc = true;
            return hc;
        }

        public void setAgt(AbstractGlueTable agt) {
            this.agt = agt;
        }

        public AbstractGlueTable getAgt() {
            return this.agt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        private TreeParent glueRoot;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            Object[] result;
            if (parent.equals(GlueInfoViewer.this.getViewSite())) {
                if (this.glueRoot == null) {
                    this.initialize();
                }
                result = this.getChildren(this.glueRoot);
            } else {
                result = this.getChildren(parent);
            }
            return result;
        }

        public Object getParent(Object child) {
            TreeParent result = null;
            if (child instanceof TreeObject) {
                result = ((TreeObject)child).getParent();
            }
            return result;
        }

        public Object[] getChildren(Object parent) {
            Object[] result = parent instanceof TreeParent ? ((TreeParent)parent).getChildren() : new Object[]{};
            return result;
        }

        public boolean hasChildren(Object parent) {
            boolean result = false;
            if (parent instanceof TreeParent) {
                result = ((TreeParent)parent).hasChildren();
            }
            return result;
        }

        private void initialize() {
            this.buildTopLevel();
        }

        private void addObjectTablename(HashSet<InfoTopTreeElement> uniqueList, InfoTopTreeElement otherElement) {
            if (uniqueList != null && otherElement != null) {
                for (InfoTopTreeElement currentElement : uniqueList) {
                    if (currentElement == null || currentElement.getGlueInfoTopTreeCategory() == null || otherElement.getGlueInfoTopTreeCategory() == null || !currentElement.equals((Object)otherElement)) continue;
                    ArrayList currentGlueInfoTopTreeCategory = currentElement.getGlueInfoTopTreeCategory();
                    int i = 0;
                    while (i < otherElement.getGlueInfoTopTreeCategory().size()) {
                        if (!currentGlueInfoTopTreeCategory.contains(otherElement.getGlueInfoTopTreeCategory().get(i))) {
                            currentGlueInfoTopTreeCategory.add((InfoTopTreeCategory)otherElement.getGlueInfoTopTreeCategory().get(i));
                        }
                        ++i;
                    }
                }
            }
        }

        private void buildTopLevel() {
            ArrayList<InfoTopTreeElement> list = new ArrayList<InfoTopTreeElement>();
            HashSet<InfoTopTreeElement> uniqueList = new HashSet<InfoTopTreeElement>();
            try {
                IGridElement[] projectElements;
                IGridElement[] iGridElementArray = projectElements = GridModel.getRoot().getChildren(null);
                int n = projectElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IGridInfoService infoService;
                    IGridElement element = iGridElementArray[n2];
                    IGridProject igp = (IGridProject)element;
                    if (igp.isOpen() && igp.getVO() != null && (infoService = igp.getVO().getInfoService()) != null && infoService instanceof IExtendedGridInfoService) {
                        ArrayList result = ((IExtendedGridInfoService)infoService).getTopTreeElements();
                        int i = 0;
                        while (result != null && i < result.size()) {
                            InfoTopTreeElement currentElement = (InfoTopTreeElement)result.get(i);
                            if (!uniqueList.contains(currentElement)) {
                                uniqueList.add(currentElement);
                            } else {
                                this.addObjectTablename(uniqueList, currentElement);
                            }
                            ++i;
                        }
                    }
                    ++n2;
                }
            }
            catch (ProblemException e) {
                Activator.logException((Exception)((Object)e));
            }
            Iterator it = uniqueList.iterator();
            while (it.hasNext()) {
                list.add((InfoTopTreeElement)it.next());
            }
            this.glueRoot = new TreeParent(list);
        }
    }

    static class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            String result = obj instanceof AbstractGlueTable ? ((AbstractGlueTable)obj).getID() : obj.toString();
            return result;
        }

        public Image getImage(Object obj) {
            String imageKey = "IMG_OBJ_ELEMENTS";
            if (obj instanceof TreeParent) {
                imageKey = "IMG_OBJ_FOLDER";
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
        }
    }
}

