/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.info.glue;

import eu.geclipse.info.glue.AbstractGlueTable;
import eu.geclipse.info.glue.GlueCE;
import eu.geclipse.info.glue.GlueCEAccessControlBaseRule;
import eu.geclipse.info.glue.GlueCluster;
import eu.geclipse.info.glue.GlueIndex;
import eu.geclipse.info.glue.GlueSA;
import eu.geclipse.info.glue.GlueSAAccessControlBaseRule;
import eu.geclipse.info.glue.GlueSE;
import eu.geclipse.info.glue.GlueService;
import eu.geclipse.info.glue.GlueServiceAccessControlRule;
import eu.geclipse.info.glue.GlueSite;
import java.util.ArrayList;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlueQuery {
    public static ArrayList<AbstractGlueTable> getGlueTable(String glueObjectName, String objectTableName, String vo) {
        ArrayList<AbstractGlueTable> inArray = GlueIndex.getInstance().getList(glueObjectName, objectTableName);
        ArrayList<Object> outArray = new ArrayList();
        ArrayList<AbstractGlueTable> result = null;
        if (vo == null || vo.equals("none")) {
            result = inArray;
        } else {
            if (glueObjectName.equals("GlueCE")) {
                for (AbstractGlueTable table : inArray) {
                    GlueCE ce = (GlueCE)table;
                    if (!GlueQuery.ceSupportsVO(ce, vo)) continue;
                    outArray.add(ce);
                }
            } else if (glueObjectName.equals("GlueSE")) {
                for (AbstractGlueTable table : inArray) {
                    GlueSE se = (GlueSE)table;
                    if (!GlueQuery.seSupportsVO(se, vo)) continue;
                    outArray.add(se);
                }
            } else if (glueObjectName.equals("GlueService")) {
                for (AbstractGlueTable table : inArray) {
                    GlueService service = (GlueService)table;
                    if (!GlueQuery.serviceSupportsVO(service, vo)) continue;
                    outArray.add(service);
                }
            } else if (glueObjectName.equals("GlueSite")) {
                for (AbstractGlueTable table : inArray) {
                    GlueSite site = (GlueSite)table;
                    if (!GlueQuery.siteSupportsVO(site, vo)) continue;
                    outArray.add(site);
                }
            } else if (glueObjectName.equals("GlueSA")) {
                for (AbstractGlueTable table : inArray) {
                    GlueSA sa = (GlueSA)table;
                    if (!GlueQuery.saSupportsVO(sa, vo)) continue;
                    outArray.add(sa);
                }
            } else {
                outArray = inArray;
            }
            result = outArray;
        }
        return result;
    }

    public static boolean seSupportsVO(GlueSE se, String vo) {
        boolean found = false;
        for (GlueSA sa : se.glueSAList) {
            for (GlueSAAccessControlBaseRule rule : sa.glueSAAccessControlBaseRuleList) {
                if (!rule.Value.equals(vo)) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        return found;
    }

    public static boolean ceSupportsVO(GlueCE ce, String vo) {
        boolean found = false;
        for (GlueCEAccessControlBaseRule rule : ce.glueCEAccessControlBaseRuleList) {
            if (!rule.Value.equals("VO:" + vo)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static boolean serviceSupportsVO(GlueService service, String vo) {
        boolean found = false;
        for (GlueServiceAccessControlRule rule : service.glueServiceAccessControlRuleList) {
            if (!rule.value.equals(vo)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static boolean saSupportsVO(GlueSA sa, String vo) {
        boolean found = false;
        for (GlueSAAccessControlBaseRule rule : sa.glueSAAccessControlBaseRuleList) {
            if (!rule.Value.equalsIgnoreCase(vo)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static boolean siteSupportsVO(GlueSite site, String vo) {
        boolean found = false;
        for (GlueSE se : site.glueSEList) {
            if (!GlueQuery.seSupportsVO(se, vo)) continue;
            found = true;
            break;
        }
        if (!found) {
            for (GlueCluster gc : site.glueClusterList) {
                for (GlueCE ce : gc.glueCEList) {
                    if (!GlueQuery.ceSupportsVO(ce, vo)) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
        }
        return found;
    }

    public static ArrayList<AbstractGlueTable> getStorageElements(String vo) {
        ArrayList<AbstractGlueTable> agtList = new ArrayList<AbstractGlueTable>();
        Enumeration<GlueSE> enSE = GlueIndex.getInstance().glueSE.elements();
        while (enSE.hasMoreElements()) {
            GlueSE se = enSE.nextElement();
            agtList.add(se);
        }
        return agtList;
    }
}

