/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.info.model;

import eu.geclipse.core.model.IGridApplication;
import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.IGridResourceCategory;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.AbstractGridContainer;
import eu.geclipse.core.model.impl.ContainerMarker;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.info.glue.AbstractGlueTable;
import eu.geclipse.info.glue.GlueCE;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GridGlueComputing
extends AbstractGridContainer
implements IGridComputing {
    private IGridContainer parent;
    private GlueCE glueTable;

    public GridGlueComputing(IGridContainer parent, GlueCE glueCE) {
        this.parent = parent;
        this.glueTable = glueCE;
    }

    public boolean canContain(IGridElement element) {
        return IGridApplication.class.isAssignableFrom(element.getClass()) || ContainerMarker.class.isAssignableFrom(element.getClass());
    }

    public GlueCE getGlueCe() {
        return (GlueCE)this.getGlueElement();
    }

    public AbstractGlueTable getGlueElement() {
        return this.glueTable;
    }

    public IFileStore getFileStore() {
        return this.getParent().getFileStore().getChild(this.getName());
    }

    public String getHostName() {
        String str = null;
        URI uri = this.getURI();
        if (uri != null && (str = uri.getHost()) == null) {
            str = uri.getScheme();
        }
        return str;
    }

    public String getName() {
        GlueCE ce = this.getGlueCe();
        return "CE @ " + ce.UniqueID;
    }

    public IGridContainer getParent() {
        return this.parent;
    }

    public IPath getPath() {
        return this.getParent().getPath().append(this.getName());
    }

    public IResource getResource() {
        return null;
    }

    public URI getURI() {
        URI uri = null;
        try {
            uri = new URI(this.getGlueCe().UniqueID);
        }
        catch (URISyntaxException uRISyntaxException) {}
        return uri;
    }

    public boolean isLazy() {
        return true;
    }

    public boolean isLocal() {
        return false;
    }

    protected IStatus fetchChildren(IProgressMonitor monitor) throws ProblemException {
        IGridResourceCategory category;
        IStatus status = Status.OK_STATUS;
        IVirtualOrganization vo = this.getVO();
        IGridInfoService infoService = vo.getInfoService();
        IGridResource[] applications = infoService.fetchResources((IGridContainer)this, vo, category = GridResourceCategoryFactory.getCategory((String)"eu.geclipse.core.model.category.applications"), false, IGridApplication.class, monitor);
        if (applications != null && applications.length > 0) {
            IGridResource[] iGridResourceArray = applications;
            int n = applications.length;
            int n2 = 0;
            while (n2 < n) {
                IGridResource app = iGridResourceArray[n2];
                this.addElement((IGridElement)app);
                ++n2;
            }
        } else {
            this.addElement((IGridElement)new ContainerMarker((IGridContainer)this, ContainerMarker.MarkerType.INFO, "No matching elements found"));
        }
        return status;
    }

    private IVirtualOrganization getVO() {
        IVirtualOrganization result = null;
        IGridProject project = this.getProject();
        if (project != null) {
            result = project.getVO();
        } else {
            IGridContainer container = this.getParent();
            while (container != null) {
                if (container instanceof IVirtualOrganization) {
                    result = (IVirtualOrganization)container;
                    break;
                }
                container = container.getParent();
            }
        }
        return result;
    }
}

