/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.info.model;

import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridInfoService;
import eu.geclipse.core.model.IGridResource;
import eu.geclipse.core.model.IGridService;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.core.model.IMountable;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.impl.GridResourceCategoryFactory;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.info.glue.GlueService;
import eu.geclipse.info.internal.Activator;
import eu.geclipse.info.model.GridGlueElement;
import eu.geclipse.info.model.GridGlueStorage;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class GridGlueService
extends GridGlueElement
implements IGridService,
IMountable {
    private static final IMountable.MountPointID LFC_MOUNT_ID = new IMountable.MountPointID("LCG File Catalog (LFC)", "lfn");
    private static final IMountable.MountPointID SRM_MOUNT_ID = new IMountable.MountPointID("Storage Resource Manager (SRM)", "srm");

    public GridGlueService(IGridContainer parent, GlueService glueService) {
        super(parent, glueService);
    }

    public String getName() {
        GlueService gs = (GlueService)this.getGlueElement();
        String name = String.valueOf(gs.type) + " @ ";
        URI uri = null;
        try {
            uri = new URI(gs.endpoint);
            name = String.valueOf(name) + uri.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            name = String.valueOf(name) + "[Unknown Endpoint] (invalid URI \"" + gs.endpoint + "\")";
        }
        return name;
    }

    public URI getURI() {
        GlueService gs = (GlueService)this.getGlueElement();
        URI uri = null;
        try {
            String endpoint = this.validateEndpoint(gs.endpoint);
            uri = new URI(endpoint);
        }
        catch (URISyntaxException uRISyntaxException) {}
        return uri;
    }

    public String getHostName() {
        String str = null;
        URI uriTmp = this.getURI();
        if (uriTmp != null && (str = uriTmp.getHost()) == null) {
            str = uriTmp.getScheme();
        }
        return str;
    }

    public GlueService getGlueService() {
        return (GlueService)this.getGlueElement();
    }

    public IMountable.MountPointID[] getMountPointIDs() {
        ArrayList<IMountable.MountPointID> result = new ArrayList<IMountable.MountPointID>();
        if (this.isLfcService()) {
            result.add(LFC_MOUNT_ID);
        } else if (this.isSrmService()) {
            result.add(SRM_MOUNT_ID);
        }
        return result.toArray(new IMountable.MountPointID[result.size()]);
    }

    public IMountable.MountPoint getMountPoint(IMountable.MountPointID mountID) {
        IMountable.MountPoint result = null;
        if (SRM_MOUNT_ID.equals((Object)mountID)) {
            try {
                IGridResource[] resources;
                IVirtualOrganization vo = this.getProject().getVO();
                IGridInfoService infoService = vo.getInfoService();
                IGridResource[] iGridResourceArray = resources = infoService.fetchResources((IGridContainer)vo, vo, GridResourceCategoryFactory.getCategory((String)"eu.geclipse.core.model.category.storage"), true, IGridStorage.class, null);
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    GridGlueStorage ggs;
                    IGridResource resource = iGridResourceArray[n2];
                    if (resource instanceof GridGlueStorage && (ggs = (GridGlueStorage)resource).getHostName().equals(this.getHostName())) {
                        result = ggs.getSrmMountPoint(this);
                    }
                    ++n2;
                }
            }
            catch (ProblemException pExc) {
                Activator.logException((Exception)((Object)pExc));
            }
        } else if (LFC_MOUNT_ID.equals((Object)mountID)) {
            String name = String.format("lfc @ %s", this.getURI().toString());
            String suri = String.format("lfn://%s:5010/grid/%s/", this.getURI(), this.getProject().getVO().getName());
            try {
                URI uri = new URI(suri);
                result = new IMountable.MountPoint(name, uri);
            }
            catch (URISyntaxException uriExc) {
                Activator.logException(uriExc);
            }
        }
        return result;
    }

    public String getType() {
        return this.getGlueService().type;
    }

    public boolean isLfcService() {
        String type = this.getType();
        return "lcg-file-catalog".equalsIgnoreCase(type) || "lcg-local-file-catalog".equalsIgnoreCase(type);
    }

    public boolean isSrmService() {
        return "srm".equalsIgnoreCase(this.getType());
    }

    private String validateEndpoint(String endpoint) {
        String result = endpoint;
        if (result.endsWith(":")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

