/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.editors;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.jsdl.model.base.DocumentRoot;
import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.ui.adapters.posix.PosixAdaptersFactory;
import eu.geclipse.jsdl.ui.editors.Messages;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.pages.DataStagingPage;
import eu.geclipse.jsdl.ui.internal.pages.JobApplicationPage;
import eu.geclipse.jsdl.ui.internal.pages.JobDefinitionPage;
import eu.geclipse.jsdl.ui.internal.pages.NewParametricPage;
import eu.geclipse.jsdl.ui.internal.pages.OverviewPage;
import eu.geclipse.jsdl.ui.internal.pages.ResourcesPage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public final class JsdlEditor
extends FormEditor
implements IEditingDomainProvider {
    protected AdapterFactoryEditingDomain editingDomain;
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected ComposedAdapterFactory adapterFactory;
    protected JobDefinitionType jobDefType = null;
    protected DocumentRoot documentRoot = null;
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedRes;
                    protected Collection<Resource> removedRes;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).JsdlEditor.this.editingDomain.getResourceSet();
                        this.changedRes = new ArrayList<Resource>();
                        this.removedRes = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta visitDelta) {
                        Resource resource;
                        if (visitDelta.getFlags() != 131072 && visitDelta.getResource().getType() == 1 && (visitDelta.getKind() & 6) != 0 && (resource = this.resourceSet.getResource(URI.createURI((String)visitDelta.getFullPath().toString()), false)) != null) {
                            if ((visitDelta.getKind() & 2) != 0) {
                                this.removedRes.add(resource);
                            } else if (!(this).JsdlEditor.this.savedResources.remove(resource)) {
                                this.changedRes.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedRes;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedRes;
                    }
                }
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    JsdlEditor.this.removedResources.addAll(visitor.getRemovedResources());
                    if (!JsdlEditor.this.isDirty()) {
                        JsdlEditor.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                            public void run() {
                                JsdlEditor.this.getSite().getPage().closeEditor((IEditorPart)JsdlEditor.this, false);
                            }
                        });
                    }
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    JsdlEditor.this.changedResources.addAll(visitor.getChangedResources());
                    if (JsdlEditor.this.getSite().getPage().getActiveEditor() == JsdlEditor.this) {
                        JsdlEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                JsdlEditor.this.handleActivate();
                            }
                        });
                    }
                }
            }
            catch (CoreException exception) {
                Activator.logException(exception);
            }
        }
    };
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = JsdlEditor.this.analyzeResourceProblems((Resource)notification.getNotifier(), null);
                        if (diagnostic.getSeverity() != 0) {
                            JsdlEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            JsdlEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!JsdlEditor.this.updateProblemIndication) return;
                        JsdlEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                JsdlEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource unSetTarget) {
            this.basicUnsetTarget((Notifier)unSetTarget);
        }
    };
    private StructuredTextEditor editor = null;
    private int sourcePageIndex;
    private boolean refreshedModel = false;
    private boolean isDirtyFlag = false;
    private OverviewPage overviewPage = new OverviewPage(this);
    private JobDefinitionPage jobDefPage = new JobDefinitionPage(this);
    private JobApplicationPage jobApplicationPage = new JobApplicationPage(this);
    private DataStagingPage dataStagingPage = new DataStagingPage(this);
    private ResourcesPage resourcesPage = new ResourcesPage(this);
    private NewParametricPage parametricPage = new NewParametricPage(this);
    private IHyperlinkListener messageHyperLinkListener;
    private JSDLJobDescription jsdlJobDescription;

    public JsdlEditor() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add((Object)new PosixAdaptersFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Composite container2 = JsdlEditor.this.getContainer();
                container2.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        JsdlEditor.this.firePropertyChange(257);
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void cleanDirtyState() {
        this.overviewPage.setDirty(false);
        this.jobDefPage.setDirty(false);
        this.jobApplicationPage.setDirty(false);
        this.resourcesPage.setDirty(false);
        this.dataStagingPage.setDirty(false);
        this.parametricPage.setDirty(false);
    }

    public void setDirty(boolean dirtyFlag) {
        if (this.isDirtyFlag != dirtyFlag) {
            this.isDirtyFlag = dirtyFlag;
            this.editorDirtyStateChanged();
        }
    }

    public void dispose() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.adapterFactory.dispose();
        super.dispose();
        if (this.documentRoot != null) {
            this.documentRoot.eResource().unload();
            this.documentRoot = null;
        }
        if (this.jobDefType != null) {
            this.jobDefType.eResource().unload();
            this.jobDefType = null;
        }
        if (this.editor != null) {
            this.editor = null;
        }
    }

    protected void addPages() {
        try {
            if (this.getJsdlModel()) {
                this.addPage((IFormPage)this.overviewPage);
                this.addPage((IFormPage)this.jobDefPage);
                this.addPage((IFormPage)this.jobApplicationPage);
                this.addPage((IFormPage)this.dataStagingPage);
                this.addPage((IFormPage)this.resourcesPage);
                this.addPage((IFormPage)this.parametricPage);
                this.pushContentToPages();
            }
            this.updateProblemIndication();
            this.addResourceEditorPage();
        }
        catch (PartInitException e) {
            Activator.logException(e);
        }
    }

    public IManagedForm getHeaderForm() {
        return this.getActivePageInstance().getManagedForm();
    }

    private void setMessage(String message, int type, IHyperlinkListener listener) {
        if (this.getHeaderForm() != null && this.getHeaderForm().getForm() != null && !this.getHeaderForm().getForm().isDisposed()) {
            this.getTopForm().setMessage(message, type);
            if (this.messageHyperLinkListener != null) {
                this.getTopForm().removeMessageHyperlinkListener(this.messageHyperLinkListener);
            }
            if (listener != null) {
                this.getTopForm().addMessageHyperlinkListener(listener);
            }
            this.messageHyperLinkListener = listener;
        }
    }

    public void setMessage(String message, int type) {
        this.setMessage(message, type, null);
    }

    public Form getTopForm() {
        return this.getHeaderForm().getForm().getForm();
    }

    private void pushContentToPages() {
        if (this.overviewPage != null) {
            this.overviewPage.setPageContent(this.jobDefType, this.isModelRefreshed());
        }
        if (this.jobDefPage != null) {
            this.jobDefPage.setPageContent(this.jobDefType, this.isModelRefreshed());
        }
        if (this.jobApplicationPage != null) {
            this.jobApplicationPage.setPageContent(this.jobDefType, this.isModelRefreshed());
        }
        if (this.resourcesPage != null) {
            this.resourcesPage.setPageContent(this.jobDefType, this.isModelRefreshed());
        }
        if (this.dataStagingPage != null) {
            this.dataStagingPage.setPageContent(this.jobDefType, this.isModelRefreshed());
        }
        if (this.parametricPage != null) {
            this.parametricPage.setPageContent(this.jobDefType, this.isModelRefreshed(), this.jsdlJobDescription);
        }
    }

    public boolean isModelRefreshed() {
        return this.refreshedModel;
    }

    private void addResourceEditorPage() throws PartInitException {
        this.sourcePageIndex = this.addPage((IEditorPart)this.getSourceEditor(), this.getEditorInput());
        this.setPageText(this.sourcePageIndex, this.getEditorInput().getName());
        this.getSourceEditor().setInput(this.getEditorInput());
    }

    private StructuredTextEditor getSourceEditor() {
        if (this.editor == null) {
            this.editor = new StructuredTextEditor();
            this.editor.setEditorPart((IEditorPart)this);
        }
        return this.editor;
    }

    protected IEditorSite createSite(IEditorPart page) {
        Object site = null;
        site = page == this.editor ? new MultiPageEditorSite((MultiPageEditorPart)this, page){

            public String getId() {
                return "org.eclipse.core.runtime.xml.source";
            }
        } : super.createSite(page);
        return site;
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                this.dispose();
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
            this.getJsdlModel();
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"JsdlEditor_FileConflict_label", (String)"JsdlEditor_WARN_FileConflict");
    }

    public void doSave(IProgressMonitor monitor) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : JsdlEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !JsdlEditor.this.isPersisted(resource) || JsdlEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        JsdlEditor.this.savedResources.add(resource);
                        resource.save(Collections.EMPTY_MAP);
                    }
                    catch (Exception exception) {
                        JsdlEditor.this.resourceToDiagnosticMap.put(resource, JsdlEditor.this.analyzeResourceProblems(resource, exception));
                        JsdlEditor.this.doTextEditorSave();
                        JsdlEditor.this.cleanDirtyState();
                        JsdlEditor.this.refreshEditor();
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.doTextEditorSave();
            this.cleanDirtyState();
            this.refreshEditor();
        }
        catch (Exception exception) {
            Activator.logException(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    protected void doTextEditorSave() {
        try {
            this.editor.doSave(null);
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "eu.geclipse.jsdl.ui", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
                try {
                    this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    if (this.editor == null) continue;
                    this.setActivePage(this.getPageCount());
                    this.editor.update();
                }
                catch (CoreException e) {
                    Activator.logException(e);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        Activator.logException(exception);
                    }
                }
            }
        }
    }

    public boolean getJsdlModel() {
        IFileEditorInput modelFile;
        boolean result = false;
        URI resourceURI = null;
        if (this.getEditorInput() instanceof IFileEditorInput) {
            modelFile = (IFileEditorInput)this.getEditorInput();
            resourceURI = URI.createPlatformResourceURI((String)modelFile.getFile().getFullPath().toString(), (boolean)false);
            this.jsdlJobDescription = (JSDLJobDescription)GridModel.getRoot().findElement((IPath)new Path(modelFile.getFile().getFullPath().toString()));
        } else if (this.getEditorInput() instanceof FileStoreEditorInput) {
            modelFile = (FileStoreEditorInput)this.getEditorInput();
            resourceURI = URI.createFileURI((String)modelFile.getURI().getPath());
            GridModel.getRoot().findElement((IPath)new Path(modelFile.getURI().toString()));
        }
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
            result = false;
        } else {
            this.getResourceRoot(resource);
            result = true;
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
        if (!this.changedResources.isEmpty()) {
            this.refreshEditor();
        }
        return result;
    }

    protected void refreshEditor() {
        this.refreshedModel = true;
        this.pushContentToPages();
        this.refreshedModel = false;
    }

    private void getResourceRoot(Resource resource) {
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            EObject testElement = (EObject)iterator.next();
            if (!(testElement instanceof JobDefinitionType)) continue;
            this.jobDefType = (JobDefinitionType)testElement;
        }
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        Object basicDiagnostic = null;
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            basicDiagnostic = new BasicDiagnostic(4, "eu.geclipse.jsdl.ui", 0, String.format(Messages.getString("JsdlEditor.CreateModelErrorMessage"), resource.getURI()), new Object[]{exception == null ? resource : exception});
            ((BasicDiagnostic)basicDiagnostic).merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
        } else {
            basicDiagnostic = exception != null ? new BasicDiagnostic(4, "eu.geclipse.jsdl.ui", 0, Messages.getString("JsdlMultiPageEditor.CreateModelErrorMessage"), new Object[]{exception}) : Diagnostic.OK_INSTANCE;
        }
        return basicDiagnostic;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException e) {
            Activator.logException(e);
        }
        return result;
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
    }
}

