/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal;

import eu.geclipse.jsdl.parametric.IGeneratedJsdl;
import eu.geclipse.jsdl.parametric.IParametricJsdlHandler;
import eu.geclipse.jsdl.parametric.ParametricJsdlException;
import eu.geclipse.jsdl.ui.internal.pages.sections.SweepIterationsSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorParametricJsdlHandler
implements IParametricJsdlHandler,
IStructuredContentProvider {
    private List<List<String>> content = Collections.emptyList();
    private SweepIterationsSection section;
    private SubMonitor monitor;

    public EditorParametricJsdlHandler(SweepIterationsSection section) {
        this.section = section;
    }

    public void generationFinished() throws ParametricJsdlException {
        this.monitor.done();
    }

    public void generationStarted(int generatedJsdls, List<String> paramNames) throws ParametricJsdlException {
        this.content = new ArrayList<List<String>>(generatedJsdls);
        this.monitor.subTask("Generating non-parametric JSDLs");
        this.monitor.setWorkRemaining(generatedJsdls);
    }

    public void newJsdlGenerated(IGeneratedJsdl generatedJsdl) throws ParametricJsdlException {
        List<String> columnNames = this.section.getLabelProvider().getColumnNames();
        ArrayList<String> values = null;
        for (String paramName : columnNames) {
            if (values == null) {
                values = new ArrayList<String>(columnNames.size());
                values.add(generatedJsdl.getIterationName());
                continue;
            }
            values.add(generatedJsdl.getParamValue(paramName));
        }
        this.content.add(values);
        this.section.iterationGenerated(values);
        this.monitor.worked(1);
    }

    public Object[] getElements(Object inputElement) {
        return this.content.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = SubMonitor.convert((IProgressMonitor)monitor);
    }

    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }
}

