/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.dialogs;

import eu.geclipse.jsdl.model.base.CreationFlagEnumeration;
import eu.geclipse.jsdl.model.base.DataStagingType;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.model.base.JsdlPackage;
import eu.geclipse.jsdl.model.base.SourceTargetType;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.widgets.Messages;
import eu.geclipse.ui.dialogs.GridFileDialog;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStagingOutDialog
extends Dialog {
    public static final int SIMPLE_DIALOG = 0;
    public static final int ADVANCED_DIALOG = 1;
    protected Text pathText;
    protected URI[] uris;
    protected String[] filename;
    protected Text nameText;
    protected boolean editMode = false;
    private int dialogStyle;
    private Combo creationFlagCombo;
    private Combo deleteOnTerminationCombo;
    private DataStagingType dataStagingType;
    private ArrayList<DataStagingType> dataStageList = new ArrayList();
    private SourceTargetType sourceTargetType;

    public DataStagingOutDialog(Shell parentShell, int style) {
        super(parentShell);
        this.dialogStyle = style;
    }

    public DataStagingOutDialog(Shell parentShell, int style, DataStagingType existingDataStage) {
        super(parentShell);
        this.dialogStyle = style;
        this.editMode = true;
        this.dataStagingType = existingDataStage;
        this.uris = new URI[1];
        this.filename = new String[1];
        this.uris[0] = URI.create(this.dataStagingType.getTarget().getURI());
        this.filename[0] = this.dataStagingType.getFileName();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("DataStageOutTable.dialog_title"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Composite panel = new Composite(composite, 0);
        this.initializeDialogUnits((Control)composite);
        GridLayout gLayout = new GridLayout(3, false);
        panel.setLayout((Layout)gLayout);
        GridData gd = new GridData(768);
        panel.setLayoutData((Object)gd);
        Label nameLabel = new Label(panel, 16384);
        nameLabel.setText(Messages.getString("DataStageInDialog.name_field_label"));
        nameLabel.setLayoutData((Object)new GridData());
        this.nameText = new Text(panel, 2048);
        gd = new GridData();
        gd.widthHint = 260;
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 4;
        this.nameText.setLayoutData((Object)gd);
        if (this.dataStagingType != null) {
            this.nameText.setText(this.dataStagingType.getFileName());
        }
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DataStagingOutDialog.this.editMode) {
                    DataStagingOutDialog.this.filename[0] = DataStagingOutDialog.this.nameText.getText();
                }
            }
        });
        Label pathLabel = new Label(panel, 16384);
        pathLabel.setText(Messages.getString("DataStageInDialog.target_location_field_label"));
        gd = new GridData();
        pathLabel.setLayoutData((Object)gd);
        this.pathText = new Text(panel, 2048);
        if (this.dataStagingType != null) {
            this.pathText.setText(this.dataStagingType.getTarget().getURI());
        }
        this.pathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DataStagingOutDialog.this.editMode) {
                    try {
                        DataStagingOutDialog.this.uris[0] = URI.create(DataStagingOutDialog.this.pathText.getText());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        });
        gd = new GridData(768);
        this.pathText.setLayoutData((Object)gd);
        Button browseButton = new Button(panel, 8);
        URL openFileIcon = Activator.getDefault().getBundle().getEntry("icons/obj16/open_file.gif");
        Image openFileImage = ImageDescriptor.createFromURL((URL)openFileIcon).createImage();
        browseButton.setImage(openFileImage);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentURI = null;
                GridFileDialog dialog = new GridFileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8);
                if (dialog.open() == 0) {
                    URI uri;
                    DataStagingOutDialog.this.uris = dialog.getSelectedURIs();
                    int j = 0;
                    while (j < DataStagingOutDialog.this.uris.length) {
                        uri = DataStagingOutDialog.this.uris[j];
                        String query = uri.getQuery();
                        if (query != null && query.trim().length() > 0) {
                            String[] qParts = query.split("&");
                            query = "";
                            int i = 0;
                            while (i < qParts.length) {
                                String qPart = qParts[i];
                                if (!qPart.startsWith("vo")) {
                                    if (query.trim().length() > 0) {
                                        query = String.valueOf(query) + "&";
                                    }
                                    query = String.valueOf(query) + qPart;
                                }
                                ++i;
                            }
                            if (query.trim().length() == 0) {
                                query = null;
                            }
                        }
                        try {
                            DataStagingOutDialog.this.uris[j] = uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), query, uri.getFragment());
                        }
                        catch (URISyntaxException e1) {
                            Activator.logException(e1);
                        }
                        ++j;
                    }
                    if (DataStagingOutDialog.this.uris != null && DataStagingOutDialog.this.uris.length > 0) {
                        DataStagingOutDialog.this.filename = new String[DataStagingOutDialog.this.uris.length];
                        int i = 0;
                        while (i < DataStagingOutDialog.this.uris.length) {
                            currentURI = DataStagingOutDialog.this.uris[i].toString();
                            try {
                                uri = new URI(currentURI);
                                DataStagingOutDialog.this.filename[i] = new Path(uri.getPath()).lastSegment();
                            }
                            catch (URISyntaxException e1) {
                                Activator.logException(e1);
                            }
                            if (i == 0) {
                                DataStagingOutDialog.this.pathText.setText(DataStagingOutDialog.this.uris[i].toString());
                                if (!DataStagingOutDialog.this.editMode) {
                                    DataStagingOutDialog.this.nameText.setText(DataStagingOutDialog.this.filename[i]);
                                }
                            } else {
                                DataStagingOutDialog.this.pathText.setText(String.valueOf(DataStagingOutDialog.this.pathText.getText()) + ", " + DataStagingOutDialog.this.uris[i].toString());
                                DataStagingOutDialog.this.nameText.setText(String.valueOf(DataStagingOutDialog.this.nameText.getText()) + ", " + DataStagingOutDialog.this.filename[i]);
                            }
                            ++i;
                        }
                    }
                }
                DataStagingOutDialog.this.updateButtons();
            }
        });
        if (this.dialogStyle == 1) {
            int indexOfOverwite;
            gd = new GridData();
            Label creationFlagLabel = new Label(panel, 16384);
            creationFlagLabel.setText(Messages.getString("DataStageInTable.CreationFlag_field_label"));
            creationFlagLabel.setLayoutData((Object)gd);
            this.creationFlagCombo = new Combo(panel, 2124);
            gd = new GridData();
            gd.widthHint = 260;
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 4;
            this.creationFlagCombo.setLayoutData((Object)gd);
            EEnum cFEnum = JsdlPackage.Literals.CREATION_FLAG_ENUMERATION;
            int i = 0;
            while (i < cFEnum.getELiterals().size()) {
                this.creationFlagCombo.add(cFEnum.getEEnumLiteral(i).toString());
                ++i;
            }
            if (this.dataStagingType != null) {
                indexOfOverwite = this.creationFlagCombo.indexOf(this.dataStagingType.getCreationFlag().getLiteral());
                this.creationFlagCombo.select(indexOfOverwite);
            } else {
                indexOfOverwite = this.creationFlagCombo.indexOf("overwrite");
                this.creationFlagCombo.select(indexOfOverwite);
            }
            gd = new GridData();
            Label deleteOnTerminationLabel = new Label(panel, 16384);
            deleteOnTerminationLabel.setText(Messages.getString("DataStageInTable.DeleteOnTermination_field_label"));
            deleteOnTerminationLabel.setLayoutData((Object)gd);
            this.deleteOnTerminationCombo = new Combo(panel, 2124);
            this.deleteOnTerminationCombo.add("true");
            this.deleteOnTerminationCombo.add("false");
            if (this.dataStagingType != null) {
                int indexOfDelete = this.deleteOnTerminationCombo.indexOf(Boolean.toString(this.dataStagingType.isDeleteOnTermination()));
                this.deleteOnTerminationCombo.select(indexOfDelete);
            } else {
                this.deleteOnTerminationCombo.select(0);
            }
            gd = new GridData();
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 4;
            this.deleteOnTerminationCombo.setLayoutData((Object)gd);
        }
        UpdateAdapter listener = new UpdateAdapter();
        this.nameText.addModifyListener((ModifyListener)listener);
        this.pathText.addModifyListener((ModifyListener)listener);
        return composite;
    }

    public ArrayList<DataStagingType> getDataStageInList() {
        return this.dataStageList;
    }

    protected void okPressed() {
        if (this.uris != null && this.uris.length > 1) {
            int i = 0;
            while (i < this.uris.length) {
                this.dataStagingType = JsdlFactory.eINSTANCE.createDataStagingType();
                this.sourceTargetType = JsdlFactory.eINSTANCE.createSourceTargetType();
                this.sourceTargetType.setURI(this.uris[i].toString());
                this.dataStagingType.setName(this.filename[i]);
                this.dataStagingType.setSource(null);
                this.dataStagingType.setTarget(this.sourceTargetType);
                this.dataStagingType.setFileName(this.filename[i]);
                if (this.dialogStyle == 1) {
                    this.dataStagingType.setCreationFlag(CreationFlagEnumeration.get((int)this.creationFlagCombo.getSelectionIndex()));
                    if (this.deleteOnTerminationCombo.getSelectionIndex() != -1) {
                        this.dataStagingType.setDeleteOnTermination(Boolean.valueOf(Boolean.parseBoolean(this.deleteOnTerminationCombo.getItem(this.deleteOnTerminationCombo.getSelectionIndex()))).booleanValue());
                    }
                }
                this.dataStageList.add(this.dataStagingType);
                ++i;
            }
        } else {
            this.dataStagingType = JsdlFactory.eINSTANCE.createDataStagingType();
            this.sourceTargetType = JsdlFactory.eINSTANCE.createSourceTargetType();
            this.sourceTargetType.setURI(this.pathText.getText());
            this.dataStagingType.setSource(null);
            this.dataStagingType.setTarget(this.sourceTargetType);
            this.dataStagingType.setFileName(this.nameText.getText());
            this.dataStagingType.setName(this.nameText.getText());
            if (this.dialogStyle == 1) {
                this.dataStagingType.setCreationFlag(CreationFlagEnumeration.get((int)this.creationFlagCombo.getSelectionIndex()));
                if (this.deleteOnTerminationCombo.getSelectionIndex() != -1) {
                    this.dataStagingType.setDeleteOnTermination(Boolean.valueOf(Boolean.parseBoolean(this.deleteOnTerminationCombo.getItem(this.deleteOnTerminationCombo.getSelectionIndex()))).booleanValue());
                }
            }
            this.dataStageList.add(this.dataStagingType);
        }
        super.okPressed();
    }

    void updateButtons() {
        if (!this.nameText.getText().equals("")) {
            super.getButton(0).setEnabled(true);
        } else {
            super.getButton(0).setEnabled(false);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtons();
    }

    class UpdateAdapter
    implements ModifyListener {
        UpdateAdapter() {
        }

        public void modifyText(ModifyEvent e) {
            DataStagingOutDialog.this.updateButtons();
        }
    }
}

