/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.dialogs;

import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.dialogs.Messages;
import eu.geclipse.ui.dialogs.GridFileDialog;
import eu.geclipse.ui.widgets.StoredCombo;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleInputDialog
extends Dialog {
    protected static final String FIELD_NAME = "FIELD_NAME";
    protected Composite panel;
    protected List<FieldSummary> fieldList = new ArrayList<FieldSummary>();
    protected List<StoredCombo> storedComboList = new ArrayList<StoredCombo>();
    protected List<Text> controlList = new ArrayList<Text>();
    protected List<Validator> validators = new ArrayList<Validator>();
    protected List<Combo> combosList = new ArrayList<Combo>();
    protected Map<Object, String> valueMap = new HashMap<Object, String>();
    protected Map<String, ArrayList<String>> combosData = new HashMap<String, ArrayList<String>>();
    private String title;
    private Map<String, String> connectedFields = new HashMap<String, String>();

    public MultipleInputDialog(Shell shell, String title) {
        super(shell);
        this.title = title;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.validateFields();
        return bar;
    }

    public void addBrowseField(String labelText, String initialValue, boolean allowsEmpty, boolean allowLocal) {
        this.fieldList.add(new FieldSummary(FieldType.BROWSE, labelText, initialValue, allowsEmpty, allowLocal));
    }

    public void addComboField(String labelText, ArrayList<String> values, String initialValue) {
        this.combosData.put(labelText, values);
        this.fieldList.add(new FieldSummary(FieldType.COMBO, labelText, initialValue, false));
    }

    private boolean checkReadyToConnect(String name, int positionInDialog) {
        boolean result = false;
        if (this.connectedFields.containsKey(name)) {
            String connectionName = this.connectedFields.get(name);
            int connectionPosition = this.fieldList.size();
            int i = 0;
            while (i < positionInDialog) {
                if (this.fieldList.get((int)i).name.equals(connectionName)) {
                    connectionPosition = i;
                }
                ++i;
            }
            if (connectionPosition < positionInDialog) {
                result = true;
            }
        } else if (this.connectedFields.containsValue(name)) {
            String connectionName = "";
            for (String connName : this.connectedFields.keySet()) {
                if (!this.connectedFields.get(connName).equals(name)) continue;
                connectionName = connName;
            }
            int connectionPosition = this.fieldList.size();
            int i = 0;
            while (i < positionInDialog) {
                if (this.fieldList.get((int)i).name.equals(connectionName)) {
                    connectionPosition = i;
                }
                ++i;
            }
            if (connectionPosition < positionInDialog) {
                result = true;
            }
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        this.panel = new Composite(container, 0);
        GridLayout layout = new GridLayout(2, false);
        this.panel.setLayout((Layout)layout);
        this.panel.setLayoutData((Object)new GridData(768));
        for (FieldSummary field : this.fieldList) {
            boolean connected = this.checkReadyToConnect(field.name, this.fieldList.indexOf(field));
            switch (field.type) {
                case TEXT: {
                    this.createTextField(field.name, field.initialValue, field.allowsEmpty, connected);
                    break;
                }
                case STORED_COMBO: {
                    this.createStoredComboField(field.name, field.initialValue, field.allowsEmpty, connected, field.prefID);
                    break;
                }
                case BROWSE: {
                    this.createBrowseField(field.name, field.initialValue, field.allowsEmpty, connected, field.allowLocal);
                    break;
                }
                case COMBO: {
                    this.createComboField(field.name, field.initialValue, field.allowsEmpty);
                }
            }
        }
        this.fieldList = null;
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    public void validateFields() {
        for (Validator validator : this.validators) {
            if (validator.validate()) continue;
            this.getButton(0).setEnabled(false);
            return;
        }
        this.getButton(0).setEnabled(true);
    }

    protected void createTextField(String labelText, String initialValue, boolean allowEmpty, boolean connected) {
        Label label = new Label(this.panel, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(32));
        final Text text = new Text(this.panel, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setData(FIELD_NAME, (Object)labelText);
        label.setSize(label.getSize().x, text.getSize().y);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        if (!allowEmpty) {
            this.validators.add(new Validator(){

                public boolean validate() {
                    return !text.getText().equals("");
                }
            });
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        this.controlList.add(text);
        if (connected) {
            if (this.connectedFields.containsKey(labelText)) {
                int n;
                String sourceName = this.connectedFields.get(labelText);
                Text sourceControl = null;
                int sourceIndex = -1;
                int n2 = -1;
                for (Control control : this.controlList) {
                    if (control.getData(FIELD_NAME).equals(sourceName)) {
                        sourceControl = (Text)control;
                        sourceIndex = this.controlList.indexOf(control);
                        continue;
                    }
                    if (!control.getData(FIELD_NAME).equals(labelText)) continue;
                    n = this.controlList.indexOf(control);
                }
                void var11_22 = n;
                final int sourcePosition = sourceIndex;
                if (sourceControl != null) {
                    sourceControl.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent event) {
                        }
                    });
                    sourceControl.addFocusListener(new FocusListener((int)var11_22){
                        private final /* synthetic */ int val$targetPosition;
                        {
                            this.val$targetPosition = n2;
                        }

                        public void focusGained(FocusEvent event) {
                        }

                        public void focusLost(FocusEvent event) {
                            String value = "";
                            Path p = new Path(MultipleInputDialog.this.controlList.get(sourcePosition).getText());
                            value = p.lastSegment();
                            if (MultipleInputDialog.this.controlList.get(this.val$targetPosition).getText() != null && MultipleInputDialog.this.controlList.get(this.val$targetPosition).getText().length() == 0) {
                                MultipleInputDialog.this.controlList.get(this.val$targetPosition).setText(value);
                            }
                        }
                    });
                }
            } else {
                String targetName = null;
                for (String name : this.connectedFields.keySet()) {
                    if (!this.connectedFields.get(name).equals(labelText)) continue;
                    targetName = name;
                }
                int sourceIndex = -1;
                int targetIndex = -1;
                for (Control control : this.controlList) {
                    if (control.getData(FIELD_NAME).equals(targetName)) {
                        Text cfr_ignored_0 = (Text)control;
                        targetIndex = this.controlList.indexOf(control);
                        continue;
                    }
                    if (!control.getData(FIELD_NAME).equals(labelText)) continue;
                    sourceIndex = this.controlList.indexOf(control);
                }
                final int n = sourceIndex;
                final int n3 = targetIndex;
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                    }
                });
                text.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent event) {
                    }

                    public void focusLost(FocusEvent event) {
                        String value = "";
                        Path p = new Path(MultipleInputDialog.this.controlList.get(n).getText());
                        value = p.lastSegment();
                        if (MultipleInputDialog.this.controlList.get(n3).getText() != null && MultipleInputDialog.this.controlList.get(n3).getText().length() == 0) {
                            MultipleInputDialog.this.controlList.get(n3).setText(value);
                        }
                    }
                });
            }
        }
    }

    protected void createStoredComboField(String labelText, String initialValue, boolean allowEmpty, boolean connected, String prefID) {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        Label label = new Label(this.panel, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(32));
        final StoredCombo storedCombo = new StoredCombo(this.panel, 2052);
        storedCombo.setLayoutData((Object)new GridData(768));
        storedCombo.setPreferences(prefs, prefID);
        storedCombo.setData(FIELD_NAME, (Object)labelText);
        label.setSize(label.getSize().x, storedCombo.getSize().y);
        if (initialValue != null) {
            storedCombo.setText(initialValue);
        }
        if (!allowEmpty) {
            this.validators.add(new Validator(){

                public boolean validate() {
                    return !storedCombo.getText().equals("");
                }
            });
            storedCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        this.storedComboList.add(storedCombo);
        if (connected) {
            if (this.connectedFields.containsKey(labelText)) {
                int n;
                String sourceName = this.connectedFields.get(labelText);
                Text sourceControl = null;
                int sourceIndex = -1;
                int n2 = -1;
                for (Control control : this.storedComboList) {
                    if (control.getData(FIELD_NAME).equals(sourceName)) {
                        sourceControl = (Text)control;
                        sourceIndex = this.storedComboList.indexOf(control);
                        continue;
                    }
                    if (!control.getData(FIELD_NAME).equals(labelText)) continue;
                    n = this.storedComboList.indexOf(control);
                }
                void var13_24 = n;
                final int sourcePosition = sourceIndex;
                sourceControl.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                    }
                });
                sourceControl.addFocusListener(new FocusListener((int)var13_24){
                    private final /* synthetic */ int val$targetPosition;
                    {
                        this.val$targetPosition = n2;
                    }

                    public void focusGained(FocusEvent event) {
                    }

                    public void focusLost(FocusEvent event) {
                        String value = "";
                        Path p = new Path(MultipleInputDialog.this.storedComboList.get(sourcePosition).getText());
                        value = p.lastSegment();
                        if (MultipleInputDialog.this.storedComboList.get(this.val$targetPosition).getText() != null && MultipleInputDialog.this.storedComboList.get(this.val$targetPosition).getText().length() == 0) {
                            MultipleInputDialog.this.storedComboList.get(this.val$targetPosition).setText(value);
                        }
                    }
                });
            } else {
                String targetName = null;
                for (String name : this.connectedFields.keySet()) {
                    if (!this.connectedFields.get(name).equals(labelText)) continue;
                    targetName = name;
                }
                int sourceIndex = -1;
                int targetIndex = -1;
                for (Control control : this.storedComboList) {
                    if (control.getData(FIELD_NAME).equals(targetName)) {
                        Text cfr_ignored_0 = (Text)control;
                        targetIndex = this.storedComboList.indexOf(control);
                        continue;
                    }
                    if (!control.getData(FIELD_NAME).equals(labelText)) continue;
                    sourceIndex = this.storedComboList.indexOf(control);
                }
                final int n = sourceIndex;
                final int n3 = targetIndex;
                storedCombo.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent event) {
                    }
                });
                storedCombo.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent event) {
                    }

                    public void focusLost(FocusEvent event) {
                        String value = "";
                        Path p = new Path(MultipleInputDialog.this.storedComboList.get(n).getText());
                        value = p.lastSegment();
                        if (MultipleInputDialog.this.storedComboList.get(n3).getText() != null && MultipleInputDialog.this.storedComboList.get(n3).getText().length() == 0) {
                            MultipleInputDialog.this.storedComboList.get(n3).setText(value);
                        }
                    }
                });
            }
        }
    }

    public void setConnectedFields(String sourceFieldName, String targetFieldName) {
        this.connectedFields.put(targetFieldName, sourceFieldName);
    }

    protected void createBrowseField(String labelText, String initialValue, boolean allowEmpty, boolean connected, boolean allowLocal) {
        Label label = new Label(this.panel, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(32));
        Composite comp = new Composite(this.panel, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        final Text text = new Text(comp, 2052);
        GridData data = new GridData(768);
        data.widthHint = 200;
        text.setLayoutData((Object)data);
        text.setData(FIELD_NAME, (Object)labelText);
        label.setSize(label.getSize().x, text.getSize().y);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        if (!allowEmpty) {
            this.validators.add(new Validator(){

                public boolean validate() {
                    return !text.getText().equals("");
                }
            });
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        Button button = this.createButton(comp, 9, Messages.getString("MultilpeInputDialog.browse_button"), false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridFileDialog dialog = new GridFileDialog(MultipleInputDialog.this.getShell(), 0);
                if (dialog.open() == 0) {
                    URI[] uris = dialog.getSelectedURIs();
                    if (uris != null && uris.length > 0) {
                        text.setText(uris[0].toString());
                    } else {
                        text.setText("");
                    }
                }
            }
        });
        this.controlList.add(text);
        if (connected) {
            if (this.connectedFields.containsKey(labelText)) {
                int n;
                String sourceName = this.connectedFields.get(labelText);
                Text sourceControl = null;
                int sourceIndex = -1;
                int n2 = -1;
                for (Control control : this.controlList) {
                    if (control.getData(FIELD_NAME).equals(sourceName)) {
                        sourceControl = (Text)control;
                        sourceIndex = this.controlList.indexOf(control);
                        continue;
                    }
                    if (!control.getData(FIELD_NAME).equals(labelText)) continue;
                    n = this.controlList.indexOf(control);
                }
                void var16_27 = n;
                final int sourcePosition = sourceIndex;
                if (sourceControl != null) {
                    sourceControl.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                        }
                    });
                    sourceControl.addFocusListener(new FocusListener((int)var16_27){
                        private final /* synthetic */ int val$targetPosition;
                        {
                            this.val$targetPosition = n2;
                        }

                        public void focusGained(FocusEvent e) {
                        }

                        public void focusLost(FocusEvent e) {
                            String value = "";
                            Path p = new Path(MultipleInputDialog.this.controlList.get(sourcePosition).getText());
                            value = p.lastSegment();
                            if (MultipleInputDialog.this.controlList.get(this.val$targetPosition).getText() != null && MultipleInputDialog.this.controlList.get(this.val$targetPosition).getText().length() == 0) {
                                MultipleInputDialog.this.controlList.get(this.val$targetPosition).setText(value);
                            }
                        }
                    });
                }
            } else {
                String targetName = null;
                for (String name : this.connectedFields.keySet()) {
                    if (!this.connectedFields.get(name).equals(labelText)) continue;
                    targetName = name;
                }
                int sourceIndex = -1;
                int targetIndex = -1;
                for (Control control : this.controlList) {
                    if (control.getData(FIELD_NAME).equals(targetName)) {
                        targetIndex = this.controlList.indexOf(control);
                        continue;
                    }
                    if (!control.getData(FIELD_NAME).equals(labelText)) continue;
                    sourceIndex = this.controlList.indexOf(control);
                }
                final int n = sourceIndex;
                final int n3 = targetIndex;
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                    }
                });
                text.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent e) {
                    }

                    public void focusLost(FocusEvent e) {
                        String value = "";
                        Path p = new Path(MultipleInputDialog.this.controlList.get(n).getText());
                        value = p.lastSegment();
                        if (MultipleInputDialog.this.controlList.get(n3).getText() != null && MultipleInputDialog.this.controlList.get(n3).getText().length() == 0) {
                            MultipleInputDialog.this.controlList.get(n3).setText(value);
                        }
                    }
                });
            }
        }
    }

    public void createVariablesField(String labelText, String initialValue, boolean allowEmpty) {
        Label label = new Label(this.panel, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(32));
        Composite comp = new Composite(this.panel, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        final Text text = new Text(comp, 2052);
        GridData data = new GridData(768);
        data.widthHint = 200;
        text.setLayoutData((Object)data);
        text.setData(FIELD_NAME, (Object)labelText);
        label.setSize(label.getSize().x, text.getSize().y);
        if (initialValue != null) {
            text.setText(initialValue);
        }
        if (!allowEmpty) {
            this.validators.add(new Validator(){

                public boolean validate() {
                    return !text.getText().equals("");
                }
            });
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        this.controlList.add(text);
    }

    protected void createComboField(String labelText, String initialValue, boolean allowEmpty) {
        Label label = new Label(this.panel, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(32));
        Composite comp = new Composite(this.panel, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(768));
        StoredCombo combo = new StoredCombo(comp, 2052);
        for (String comboText : this.combosData.get(labelText)) {
            combo.add(comboText);
        }
        if (initialValue != null) {
            int i = 0;
            while (i < combo.getItemCount()) {
                if (combo.getItem(i).equals(initialValue)) {
                    combo.select(i);
                }
                ++i;
            }
        } else {
            combo.select(0);
        }
        GridData data = new GridData(768);
        data.widthHint = 200;
        combo.setLayoutData((Object)data);
        combo.setData(FIELD_NAME, (Object)labelText);
        label.setSize(label.getSize().x, combo.getSize().y);
        if (initialValue != null) {
            combo.setText(initialValue);
        }
        if (!allowEmpty) {
            this.validators.add(new Validator((Combo)combo){
                private final /* synthetic */ Combo val$combo;
                {
                    this.val$combo = combo;
                }

                public boolean validate() {
                    return !this.val$combo.getText().equals("");
                }
            });
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        this.combosList.add((Combo)combo);
    }

    protected void okPressed() {
        for (Control control : this.controlList) {
            if (!(control instanceof Text)) continue;
            this.valueMap.put(control.getData(FIELD_NAME), ((Text)control).getText());
        }
        for (Control control : this.storedComboList) {
            if (!(control instanceof StoredCombo)) continue;
            this.valueMap.put(control.getData(FIELD_NAME), ((StoredCombo)control).getText());
        }
        for (Control control : this.combosList) {
            if (!(control instanceof Combo)) continue;
            this.valueMap.put(control.getData(FIELD_NAME), ((Combo)control).getText());
        }
        this.controlList = null;
        this.combosList = null;
        super.okPressed();
    }

    public int open() {
        MultipleInputDialog.applyDialogFont((Control)this.panel);
        return super.open();
    }

    public Object getValue(String key) {
        return this.valueMap.get(key);
    }

    public String getStringValue(String key) {
        return (String)this.getValue(key);
    }

    private String getDialogSettingsSectionName() {
        return "org.eclipse.debug.ui.MULTIPLE_INPUT_DIALOG_2";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        return section;
    }

    public void addTextField(String labelText, String initialValue, boolean allowsEmpty) {
        this.fieldList.add(new FieldSummary(FieldType.TEXT, labelText, initialValue, allowsEmpty));
    }

    public void addStoredComboField(String labelText, String initialValue, boolean allowsEmpty, String prefID) {
        this.fieldList.add(new FieldSummary(FieldType.STORED_COMBO, labelText, initialValue, allowsEmpty, prefID));
    }

    protected class FieldSummary {
        FieldType type;
        String name;
        String initialValue;
        boolean allowsEmpty;
        boolean allowLocal;
        final String prefID;

        public FieldSummary(FieldType type, String name, String initialValue, boolean allowsEmpty) {
            this(type, name, initialValue, allowsEmpty, true);
        }

        public FieldSummary(FieldType type, String name, String initialValue, boolean allowsEmpty, boolean allowLocal) {
            this.type = type;
            this.name = name;
            this.initialValue = initialValue;
            this.allowsEmpty = allowsEmpty;
            this.allowLocal = allowLocal;
            this.prefID = "";
        }

        public FieldSummary(FieldType type, String name, String initialValue, boolean allowsEmpty, String prefID) {
            this.type = type;
            this.name = name;
            this.initialValue = initialValue;
            this.allowsEmpty = allowsEmpty;
            this.prefID = prefID;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FieldType {
        TEXT,
        BROWSE,
        COMBO,
        STORED_COMBO;

    }

    protected class Validator {
        protected Validator() {
        }

        boolean validate() {
            return true;
        }
    }
}

