/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages.sections;

import eu.geclipse.jsdl.model.base.ApplicationType;
import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.ui.internal.pages.FormSectionFactory;
import eu.geclipse.jsdl.ui.internal.pages.Messages;
import eu.geclipse.jsdl.ui.internal.pages.sections.JsdlFormPageSection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ApplicationSection
extends JsdlFormPageSection {
    private static final int WIDGET_HEIGHT = 100;
    protected Label lblApplicationName = null;
    protected Label lblApplicationVersion = null;
    protected Label lblApplicationDescription = null;
    protected Text txtApplicationName = null;
    protected Text txtApplicationVersion = null;
    protected Text txtDescription = null;
    protected JobDefinitionType jobDefinitionType = JsdlFactory.eINSTANCE.createJobDefinitionType();
    protected ApplicationType applicationType = JsdlFactory.eINSTANCE.createApplicationType();

    public ApplicationSection(Composite parent, FormToolkit toolkit) {
        this.createSection(parent, toolkit);
    }

    private void createSection(Composite parent, FormToolkit toolkit) {
        String sectionTitle = Messages.getString("JobApplicationPage_ApplicationSectionTitle");
        String sectionDescription = Messages.getString("JobApplicationPage_ApplicationDescription");
        Composite client = FormSectionFactory.createGridStaticSection(toolkit, parent, sectionTitle, sectionDescription, 2);
        this.lblApplicationName = toolkit.createLabel(client, Messages.getString("JobApplicationPage_ApplicationName"));
        this.txtApplicationName = toolkit.createText(client, "", 0);
        GridData gd = new GridData();
        gd.widthHint = 300;
        this.txtApplicationName.setLayoutData((Object)gd);
        this.txtApplicationName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ApplicationSection.this.txtApplicationName.getText().equals("")) {
                    ApplicationSection.this.applicationType.setApplicationName(ApplicationSection.this.txtApplicationName.getText());
                } else {
                    ApplicationSection.this.applicationType.setApplicationName(null);
                }
                ApplicationSection.this.contentChanged();
            }
        });
        this.lblApplicationVersion = toolkit.createLabel(client, Messages.getString("JobApplicationPage_ApplicationVersion"));
        this.txtApplicationVersion = toolkit.createText(client, "", 0);
        gd = new GridData();
        gd.widthHint = 300;
        this.txtApplicationVersion.setLayoutData((Object)gd);
        this.txtApplicationVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ApplicationSection.this.txtApplicationVersion.getText().equals("")) {
                    ApplicationSection.this.applicationType.setApplicationVersion(ApplicationSection.this.txtApplicationVersion.getText());
                } else {
                    ApplicationSection.this.applicationType.setApplicationVersion(null);
                }
                ApplicationSection.this.contentChanged();
            }
        });
        this.lblApplicationDescription = toolkit.createLabel(client, Messages.getString("JobApplicationPage_ApplicationDescr"));
        this.txtDescription = toolkit.createText(client, "", 576);
        gd = new GridData();
        gd.verticalSpan = 3;
        gd.widthHint = 285;
        gd.heightHint = 100;
        this.txtDescription.setLayoutData((Object)gd);
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ApplicationSection.this.txtDescription.getText().equals("")) {
                    ApplicationSection.this.applicationType.setDescription(ApplicationSection.this.txtDescription.getText());
                } else {
                    ApplicationSection.this.applicationType.setDescription(null);
                }
                ApplicationSection.this.contentChanged();
            }
        });
        toolkit.paintBordersFor(client);
    }

    public void setInput(JobDefinitionType jobDefinition) {
        this.adapterRefreshed = true;
        if (jobDefinition != null) {
            this.jobDefinitionType = jobDefinition;
            this.applicationType = this.jobDefinitionType.getJobDescription().getApplication();
            this.applicationType.eAdapters().add((Object)this);
            this.fillFields();
        }
    }

    private void fillFields() {
        this.isNotifyAllowed = false;
        if (this.applicationType != null) {
            if (this.applicationType.getApplicationName() != null) {
                this.txtApplicationName.setText(this.applicationType.getApplicationName());
            }
            if (this.applicationType.getApplicationVersion() != null) {
                this.txtApplicationVersion.setText(this.applicationType.getApplicationVersion());
            }
            if (this.applicationType.getDescription() != null) {
                this.txtDescription.setText(this.applicationType.getDescription());
            }
        }
        this.isNotifyAllowed = true;
        if (this.adapterRefreshed) {
            this.adapterRefreshed = false;
        }
    }
}

