/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages.sections;

import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.base.JobIdentificationType;
import eu.geclipse.jsdl.model.base.JsdlFactory;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.dialogs.MultipleInputDialog;
import eu.geclipse.jsdl.ui.internal.pages.FormSectionFactory;
import eu.geclipse.jsdl.ui.internal.pages.Messages;
import eu.geclipse.jsdl.ui.internal.pages.sections.JsdlFormPageSection;
import eu.geclipse.jsdl.ui.providers.FeatureContentProvider;
import eu.geclipse.jsdl.ui.providers.FeatureLabelProvider;
import java.util.ArrayList;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class JobIdentificationSection
extends JsdlFormPageSection {
    private static final int WIDGET_HEIGHT = 100;
    protected JobDefinitionType jobDefinitionType = JsdlFactory.eINSTANCE.createJobDefinitionType();
    protected JobIdentificationType jobIdentificationType = JsdlFactory.eINSTANCE.createJobIdentificationType();
    protected Object[] value = null;
    protected TableViewer annotationsViewer = null;
    protected TableViewer projectsViewer = null;
    protected Text txtDescription = null;
    protected Text txtJobName = null;
    protected List lstJobProject = null;
    protected List lstJobAnnotation = null;
    protected Label lblJobDescripiton = null;
    protected Label lblJobAnnotation = null;
    protected Label lblJobProject = null;
    protected Button btnAnnotationsAdd = null;
    protected Button btnAnnotationsDel = null;
    protected Button btnProjectsAdd = null;
    protected Button btnProjectsDel = null;
    protected Composite body = null;
    private Composite containerComposite = null;

    public JobIdentificationSection(Composite parent, FormToolkit toolkit) {
        this.containerComposite = parent;
        this.createSection(parent, toolkit);
    }

    private void createSection(Composite parent, FormToolkit toolkit) {
        String sectionTitle = Messages.getString("JobDefinitionPage_JobIdentificationTitle");
        String sectionDescription = Messages.getString("JobDefinitionPage_JobIdentificationDescr");
        Composite client = FormSectionFactory.createGridStaticSection(toolkit, parent, sectionTitle, sectionDescription, 4);
        toolkit.createLabel(client, Messages.getString("JobDefinitionPage_JobName"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 2;
        gd.horizontalSpan = 3;
        gd.widthHint = 300;
        this.txtJobName = toolkit.createText(client, "", 0);
        this.txtJobName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobIdentificationSection.this.jobIdentificationType.setJobName(JobIdentificationSection.this.txtJobName.getText());
                JobIdentificationSection.this.contentChanged();
            }
        });
        this.txtJobName.setLayoutData((Object)gd);
        this.lblJobDescripiton = toolkit.createLabel(client, Messages.getString("JobDefinitionPage_JobDescr"));
        gd = new GridData();
        gd.verticalSpan = 1;
        gd.verticalAlignment = 1;
        this.lblJobDescripiton.setLayoutData((Object)gd);
        this.txtDescription = toolkit.createText(client, "", 578);
        this.txtDescription.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobIdentificationSection.this.jobIdentificationType.setDescription(JobIdentificationSection.this.txtDescription.getText());
                JobIdentificationSection.this.contentChanged();
            }
        });
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.verticalSpan = 1;
        gd.horizontalSpan = 3;
        gd.widthHint = 285;
        gd.heightHint = 100;
        this.txtDescription.setLayoutData((Object)gd);
        this.lblJobAnnotation = toolkit.createLabel(client, Messages.getString("JobDefinitionPage_JobAnnotation"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.verticalSpan = 2;
        gd.verticalAlignment = 1;
        this.lblJobAnnotation.setLayoutData((Object)gd);
        Table tblAnnotations = new Table(client, 2818);
        gd = new GridData();
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 1;
        gd.verticalSpan = 2;
        gd.widthHint = 250;
        gd.heightHint = 100;
        tblAnnotations.setLayoutData((Object)gd);
        this.annotationsViewer = new TableViewer(tblAnnotations);
        tblAnnotations = this.annotationsViewer.getTable();
        this.annotationsViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        FeatureLabelProvider annotationsLabelProvider = new FeatureLabelProvider();
        annotationsLabelProvider.setStringType(2);
        this.annotationsViewer.setLabelProvider((IBaseLabelProvider)annotationsLabelProvider);
        this.annotationsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JobIdentificationSection.this.updateButtons((TableViewer)event.getSource());
            }
        });
        tblAnnotations.setData((Object)"FormWidgetFactory.drawBorder");
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalSpan = 1;
        gd.widthHint = 60;
        this.btnAnnotationsAdd = toolkit.createButton(client, Messages.getString("JsdlEditor_AddButton"), 8);
        this.btnAnnotationsAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JobIdentificationSection.this.handleAddDialog(Messages.getString("JobDefinitionPage_JobAnnotationDialog"));
                JobIdentificationSection.this.performAdd(JobIdentificationSection.this.annotationsViewer, JobIdentificationSection.this.value);
            }
        });
        this.btnAnnotationsAdd.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalSpan = 1;
        gd.widthHint = 60;
        gd.verticalAlignment = 1;
        this.btnAnnotationsDel = toolkit.createButton(client, Messages.getString("JsdlEditor_RemoveButton"), 8);
        this.btnAnnotationsDel.setEnabled(false);
        this.btnAnnotationsDel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                JobIdentificationSection.this.performDelete(JobIdentificationSection.this.annotationsViewer);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.btnAnnotationsDel.setLayoutData((Object)gd);
        this.lblJobProject = toolkit.createLabel(client, Messages.getString("JobDefinitionPage_JobProject"));
        gd = new GridData();
        gd.verticalSpan = 2;
        gd.horizontalSpan = 1;
        gd.verticalAlignment = 1;
        this.lblJobProject.setLayoutData((Object)gd);
        Table tblProjects = new Table(client, 2818);
        gd = new GridData();
        gd.verticalSpan = 2;
        gd.horizontalSpan = 1;
        gd.widthHint = 250;
        gd.heightHint = 100;
        tblProjects.setLayoutData((Object)gd);
        this.projectsViewer = new TableViewer(tblProjects);
        tblProjects = this.annotationsViewer.getTable();
        this.projectsViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        FeatureLabelProvider projectsLabelProvider = new FeatureLabelProvider();
        projectsLabelProvider.setStringType(3);
        this.projectsViewer.setLabelProvider((IBaseLabelProvider)projectsLabelProvider);
        this.projectsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JobIdentificationSection.this.updateButtons((TableViewer)event.getSource());
            }
        });
        tblAnnotations.setData((Object)"FormWidgetFactory.drawBorder");
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalSpan = 1;
        gd.widthHint = 60;
        this.btnProjectsAdd = toolkit.createButton(client, Messages.getString("JsdlEditor_AddButton"), 8);
        this.btnProjectsAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JobIdentificationSection.this.handleAddDialog(Messages.getString("JobDefinitionPage_JobProjectDialog"));
                JobIdentificationSection.this.performAdd(JobIdentificationSection.this.projectsViewer, JobIdentificationSection.this.value);
            }
        });
        this.btnProjectsAdd.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = 60;
        gd.verticalSpan = 1;
        gd.verticalAlignment = 1;
        this.btnProjectsDel = toolkit.createButton(client, Messages.getString("JsdlEditor_RemoveButton"), 8);
        this.btnProjectsDel.setEnabled(false);
        this.btnProjectsDel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                JobIdentificationSection.this.performDelete(JobIdentificationSection.this.projectsViewer);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.btnProjectsDel.setLayoutData((Object)gd);
        toolkit.paintBordersFor(client);
    }

    protected void performDelete(TableViewer viewer) {
        IStructuredSelection structSelection = (IStructuredSelection)viewer.getSelection();
        if (structSelection != null) {
            for (Object feature : structSelection) {
                try {
                    if (!this.adapterRefreshed) {
                        if (feature instanceof String) {
                            if (viewer == this.annotationsViewer) {
                                this.jobIdentificationType.getJobAnnotation().remove(feature);
                            } else {
                                this.jobIdentificationType.getJobProject().remove(feature);
                            }
                        }
                        this.contentChanged();
                    } else {
                        viewer.remove(feature);
                    }
                }
                catch (Exception e) {
                    Activator.logException(e);
                }
                viewer.refresh();
            }
        }
    }

    public void performAdd(TableViewer tableViewer, Object[] innerValue) {
        boolean elementExists = false;
        int i = 0;
        while (i < innerValue.length) {
            if (innerValue[i] == null) {
                return;
            }
            ++i;
        }
        ArrayList<String> collection = new ArrayList<String>();
        EList newInputList = (EList)tableViewer.getInput();
        if (newInputList == null) {
            newInputList = new BasicEList();
        }
        int i2 = 0;
        while (i2 < innerValue.length && !elementExists) {
            String newElement = (String)innerValue[i2];
            elementExists = newInputList.contains((Object)newElement);
            if (!elementExists) {
                newInputList.add((Object)newElement);
            }
            ++i2;
        }
        if (!elementExists) {
            i2 = 0;
            while (i2 < newInputList.size()) {
                collection.add((String)newInputList.get(i2));
                ++i2;
            }
            if (tableViewer == this.annotationsViewer) {
                this.jobIdentificationType.getJobAnnotation().clear();
                this.jobIdentificationType.getJobAnnotation().addAll(collection);
                tableViewer.setInput((Object)this.jobIdentificationType.getJobAnnotation());
            } else {
                this.jobIdentificationType.getJobProject().clear();
                this.jobIdentificationType.getJobProject().addAll(collection);
                tableViewer.setInput((Object)this.jobIdentificationType.getJobProject());
            }
            this.contentChanged();
        } else {
            MessageDialog.openError((Shell)tableViewer.getControl().getShell(), (String)Messages.getString("GenericDialog_DuplicateEntryDialog_Title"), (String)Messages.getString("GenericDialog_New_DuplicateEntryDialog_Message"));
        }
        collection = null;
    }

    protected void handleAddDialog(String dialogTitle) {
        this.value = new Object[1];
        MultipleInputDialog dialog = new MultipleInputDialog(this.containerComposite.getShell(), dialogTitle);
        dialog.addStoredComboField(Messages.getString("JobDefinitionPage_Value"), "", false, "JobDefinitionPage_Value");
        if (dialog.open() != 0) {
            return;
        }
        this.value[0] = dialog.getStringValue(Messages.getString("JobDefinitionPage_Value"));
    }

    public void setInput(JobDefinitionType jobDefinition) {
        this.adapterRefreshed = true;
        if (jobDefinition != null) {
            this.jobDefinitionType = jobDefinition;
            this.jobIdentificationType = this.jobDefinitionType.getJobDescription().getJobIdentification();
            this.fillFields();
        }
    }

    private void fillFields() {
        this.isNotifyAllowed = false;
        if (this.jobIdentificationType != null) {
            if (this.jobIdentificationType.getJobName() != null) {
                this.txtJobName.setText(this.jobIdentificationType.getJobName());
            }
            if (this.jobIdentificationType.getDescription() != null) {
                this.txtDescription.setText(this.jobIdentificationType.getDescription());
            }
            this.projectsViewer.setInput((Object)this.jobIdentificationType.getJobProject());
            this.annotationsViewer.setInput((Object)this.jobIdentificationType.getJobAnnotation());
        }
        this.isNotifyAllowed = true;
        if (this.adapterRefreshed) {
            this.adapterRefreshed = false;
        }
    }

    protected void updateButtons(TableViewer tableViewer) {
        boolean selectionAvailable;
        ISelection selection = tableViewer.getSelection();
        boolean bl = selectionAvailable = !selection.isEmpty();
        if (tableViewer == this.annotationsViewer) {
            this.btnAnnotationsAdd.setEnabled(true);
            this.btnAnnotationsDel.setEnabled(selectionAvailable);
        } else {
            this.btnProjectsAdd.setEnabled(true);
            this.btnProjectsDel.setEnabled(selectionAvailable);
        }
    }
}

