/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages.sections;

import eu.geclipse.jsdl.model.base.JobDefinitionType;
import eu.geclipse.jsdl.model.sweep.AssignmentType;
import eu.geclipse.jsdl.model.sweep.SweepType;
import eu.geclipse.jsdl.model.sweep.impl.SweepPackageImpl;
import eu.geclipse.jsdl.ui.adapters.jsdl.ParametricJobAdapter;
import eu.geclipse.jsdl.ui.internal.pages.FormSectionFactory;
import eu.geclipse.jsdl.ui.internal.pages.sections.JsdlFormPageSection;
import eu.geclipse.jsdl.ui.providers.parameters.SweepOrderCProvider;
import eu.geclipse.jsdl.ui.providers.parameters.SweepOrderLProvider;
import eu.geclipse.jsdl.ui.widgets.ParametersDialog;
import eu.geclipse.jsdl.ui.widgets.SweepDeleteDialog;
import eu.geclipse.jsdl.ui.widgets.SweepLoopDialog;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SweepOrderSection
extends JsdlFormPageSection {
    TreeViewer viewer;
    Combo sweepCombo;
    Text textArea;
    ParametricJobAdapter adapter;
    ArrayList<SweepType> inerSweepList;
    private JobDefinitionType jobDefinitionType;
    private List<SweepType> sweepType = new ArrayList<SweepType>();
    private MenuManager manager;
    private Shell shell;
    private Button newButton;
    private Button independentButton;
    private Button sameLevelButton;
    private Button innerButton;
    private Button deleteButton;
    private Button addFunctionButton;

    public SweepOrderSection(Composite parent, FormToolkit toolkit, ParametricJobAdapter adapter) {
        this.adapter = adapter;
        this.createSection(parent, toolkit);
    }

    public void setInput(JobDefinitionType jobDefinition) {
        this.adapterRefreshed = true;
        this.sweepType = new ArrayList<SweepType>();
        if (jobDefinition != null) {
            this.jobDefinitionType = jobDefinition;
            TreeIterator iterator = this.jobDefinitionType.eAllContents();
            while (iterator.hasNext()) {
                EObject testType = (EObject)iterator.next();
                if (!(testType instanceof SweepType) || testType.eContainer() instanceof SweepType) continue;
                SweepType type = (SweepType)testType;
                type.eAdapters().add((Object)this);
                this.sweepType.add(type);
            }
            this.inerSweepList = new ArrayList();
            if (!this.sweepType.isEmpty()) {
                for (SweepType type : this.sweepType) {
                    TreeIterator it = type.eAllContents();
                    while (it.hasNext()) {
                        EObject testObject = (EObject)it.next();
                        if (!(testObject instanceof SweepType)) continue;
                        this.inerSweepList.add((SweepType)testObject);
                    }
                }
                this.inerSweepList.addAll(this.sweepType);
            }
            this.fillFields();
        }
    }

    private void fillFields() {
        if (this.viewer != null) {
            this.viewer.setInput((Object)this.sweepType.toArray(new SweepType[0]));
            this.viewer.refresh();
        }
        this.refreshSweepCombo();
    }

    private void refreshSweepCombo() {
        if (this.sweepCombo != null) {
            this.sweepCombo.removeAll();
            for (String name : this.getInerSweepNames()) {
                this.sweepCombo.add(name);
            }
        }
    }

    private void createSection(Composite parent, FormToolkit toolkit) {
        this.shell = parent.getShell();
        String sectionTitle = "Sweep order";
        String sectionDescription = "Specify the order of parameters sweep and their dependency from each other";
        Composite client = FormSectionFactory.createGridStaticSection(toolkit, parent, sectionTitle, sectionDescription, 3);
        Composite treeComp = toolkit.createComposite(client);
        GridData gData = new GridData(1808);
        gData.horizontalSpan = 3;
        treeComp.setLayoutData((Object)gData);
        treeComp.setLayout((Layout)new GridLayout(2, false));
        this.viewer = new TreeViewer(treeComp, 2048);
        this.viewer.setContentProvider((IContentProvider)new SweepOrderCProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SweepOrderLProvider());
        gData = new GridData(512);
        gData = new GridData();
        gData.horizontalAlignment = 4;
        gData.verticalAlignment = 4;
        gData.grabExcessHorizontalSpace = true;
        gData.verticalSpan = 6;
        gData.heightHint = 300;
        this.viewer.getTree().setLayoutData((Object)gData);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection sel = SweepOrderSection.this.viewer.getSelection();
                if (sel instanceof StructuredSelection) {
                    StructuredSelection sSel = (StructuredSelection)sel;
                    if (sSel.getFirstElement() instanceof SweepType) {
                        SweepType type = (SweepType)sSel.getFirstElement();
                        int i = 0;
                        boolean found = false;
                        String[] stringArray = SweepOrderSection.this.sweepCombo.getItems();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String item = stringArray[n2];
                            if (item.equals(SweepOrderSection.this.getNameForSweep(type))) {
                                found = true;
                                break;
                            }
                            ++i;
                            ++n2;
                        }
                        if (found) {
                            SweepOrderSection.this.sweepCombo.select(i);
                            SweepOrderSection.this.setValuesField(SweepOrderSection.this.adapter.getValuesForParameter(SweepOrderSection.this.sweepCombo.getItem(i), SweepOrderSection.this.inerSweepList));
                        }
                    } else if (sSel.isEmpty()) {
                        SweepOrderSection.this.sweepCombo.deselectAll();
                        SweepOrderSection.this.setValuesField(null);
                    }
                }
                SweepOrderSection.this.updateButtons();
            }
        });
        this.manager = this.createMenu();
        Composite buttonComp = toolkit.createComposite(treeComp);
        buttonComp.setLayout((Layout)new GridLayout(1, true));
        this.newButton = toolkit.createButton(buttonComp, "New sweep...", 8);
        this.newButton.setLayoutData((Object)new GridData(768));
        this.independentButton = toolkit.createButton(buttonComp, "Independent sweep...", 8);
        gData = new GridData(768);
        gData.verticalIndent = 15;
        this.independentButton.setLayoutData((Object)gData);
        this.sameLevelButton = toolkit.createButton(buttonComp, "Sweep on the same level...", 8);
        this.sameLevelButton.setLayoutData((Object)new GridData(768));
        this.innerButton = toolkit.createButton(buttonComp, "Inner sweep...", 8);
        this.innerButton.setLayoutData((Object)new GridData(768));
        this.deleteButton = toolkit.createButton(buttonComp, "Delete", 8);
        gData = new GridData(768);
        gData.verticalIndent = 15;
        this.deleteButton.setLayoutData((Object)gData);
        this.updateButtons();
        toolkit.createLabel(client, "Sweep element");
        this.sweepCombo = new Combo(client, 8);
        gData = new GridData(1808);
        gData.widthHint = 200;
        gData.horizontalSpan = 2;
        this.sweepCombo.setLayoutData((Object)gData);
        this.sweepCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SweepOrderSection.this.setValuesField(SweepOrderSection.this.adapter.getValuesForParameter(SweepOrderSection.this.sweepCombo.getText(), SweepOrderSection.this.inerSweepList));
                SweepOrderSection.this.updateButtons();
            }
        });
        toolkit.createLabel(client, "Parameter values\n(put each value in new line)");
        this.textArea = new Text(client, 2626);
        gData = new GridData(1808);
        gData.heightHint = 70;
        gData.widthHint = 160;
        this.textArea.setLayoutData((Object)gData);
        this.textArea.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                ArrayList<String> val = new ArrayList<String>();
                String[] stringArray = SweepOrderSection.this.textArea.getText().split(System.getProperty("line.separator"));
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    val.add(value);
                    ++n2;
                }
                SweepType sweep = SweepOrderSection.this.adapter.findSweepElement(SweepOrderSection.this.sweepCombo.getText(), SweepOrderSection.this.inerSweepList);
                AssignmentType assignment = null;
                if (sweep != null && sweep.getAssignment() != null) {
                    int j = 0;
                    while (j < sweep.getAssignment().size()) {
                        if (((AssignmentType)sweep.getAssignment().get(j)).getParameter().contains((Object)SweepOrderSection.this.sweepCombo.getText())) {
                            assignment = (AssignmentType)sweep.getAssignment().get(j);
                            break;
                        }
                        ++j;
                    }
                }
                if (assignment != null) {
                    SweepOrderSection.this.adapter.setFunctionValues(assignment, val);
                    SweepOrderSection.this.contentChanged();
                }
                SweepOrderSection.this.updateButtons();
            }
        });
        Composite buttonValComp = toolkit.createComposite(client);
        buttonValComp.setLayout((Layout)new GridLayout(1, true));
        this.addFunctionButton = toolkit.createButton(buttonValComp, "Define loop...", 8);
        gData = new GridData();
        this.addFunctionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SweepLoopDialog dialog = new SweepLoopDialog(SweepOrderSection.this.shell);
                if (dialog.open() == 0) {
                    ArrayList<BigInteger> exceptions = new ArrayList<BigInteger>();
                    if (dialog.getExceptionsReturn() != null) {
                        String[] stringArray = dialog.getExceptionsReturn();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String exc = stringArray[n2];
                            exceptions.add(new BigInteger(exc));
                            ++n2;
                        }
                    }
                    SweepOrderSection.this.appendTextToTextArea(ParametricJobAdapter.createLOOPString(new BigInteger(dialog.getStartReturn()), new BigInteger(dialog.getEndReturn()), new BigInteger(dialog.getStepReturn()), exceptions));
                    SweepOrderSection.this.updateButtons();
                }
            }
        });
        this.addFunctionButton.setLayoutData((Object)gData);
        this.updateButtons();
        this.addButtonsListeners();
    }

    protected void appendTextToTextArea(String string) {
        String newText = this.textArea.getText();
        newText = String.valueOf(newText.trim()) + System.getProperty("line.separator") + string;
        this.textArea.setText(newText.trim());
        ArrayList<String> val = new ArrayList<String>();
        String[] stringArray = this.textArea.getText().split(System.getProperty("line.separator"));
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            val.add(value);
            ++n2;
        }
        SweepType sweep = this.adapter.findSweepElement(this.sweepCombo.getText(), this.inerSweepList);
        AssignmentType assignment = null;
        if (sweep.getAssignment() != null) {
            int j = 0;
            while (j < sweep.getAssignment().size()) {
                if (((AssignmentType)sweep.getAssignment().get(j)).getParameter().contains((Object)this.sweepCombo.getText())) {
                    assignment = (AssignmentType)sweep.getAssignment().get(j);
                    break;
                }
                ++j;
            }
        }
        this.adapter.setFunctionValues(assignment, val);
        this.updateButtons();
        this.contentChanged();
    }

    private void addButtonsListeners() {
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SweepOrderSection.this.addNew();
            }
        });
        this.independentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SweepOrderSection.this.addIndependent();
            }
        });
        this.sameLevelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SweepOrderSection.this.addChangesWith();
            }
        });
        this.innerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SweepOrderSection.this.addChangesForEachChange();
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SweepOrderSection.this.removeSelected();
            }
        });
    }

    void updateButtons() {
        boolean enable = !this.viewer.getSelection().isEmpty();
        this.independentButton.setEnabled(enable);
        this.sameLevelButton.setEnabled(enable);
        this.innerButton.setEnabled(enable);
        this.deleteButton.setEnabled(enable);
        if (this.addFunctionButton != null) {
            this.addFunctionButton.setEnabled(!this.sweepCombo.getText().equals("") && this.textArea.getText().trim().equals(""));
        }
    }

    void setValuesField(List<String> values) {
        if (values != null) {
            String multiLinesContent = "";
            for (String name : values) {
                multiLinesContent = String.valueOf(multiLinesContent) + System.getProperty("line.separator") + name;
            }
            if (multiLinesContent.startsWith(System.getProperty("line.separator"))) {
                multiLinesContent = multiLinesContent.trim();
            }
            this.textArea.setText(multiLinesContent);
            this.updateButtons();
        } else {
            this.textArea.setText("");
            this.updateButtons();
        }
    }

    Action createDeleteAction() {
        Action action = new Action(){

            public void run() {
                SweepOrderSection.this.removeSelected();
            }
        };
        action.setText("Delete");
        return action;
    }

    Action createNewAction() {
        Action action = new Action(){

            public void run() {
                SweepOrderSection.this.addNew();
            }
        };
        action.setText("New...");
        return action;
    }

    Action createChangesForEachAction() {
        Action action = new Action(){

            public void run() {
                SweepOrderSection.this.addChangesForEachChange();
            }
        };
        action.setText("Add inner sweep...");
        return action;
    }

    private List<String> getInerSweepNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (SweepType sweep : this.inerSweepList) {
            EList list = sweep.getAssignment();
            int i = 0;
            while (i < list.size()) {
                Object el = list.get(i);
                if (el instanceof AssignmentType) {
                    AssignmentType assignment = (AssignmentType)el;
                    EList paramList = assignment.getParameter();
                    int j = 0;
                    while (j < paramList.size()) {
                        result.add((String)paramList.get(j));
                        ++j;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    protected void addChangesForEachChange() {
        StructuredSelection sSel;
        ISelection sel = this.viewer.getSelection();
        if (sel instanceof StructuredSelection && (sSel = (StructuredSelection)sel).getFirstElement() instanceof SweepType) {
            SweepType type = (SweepType)sSel.getFirstElement();
            List<String> adapterList = this.adapter.getElementsList();
            adapterList.removeAll(this.getInerSweepNames());
            ParametersDialog dialog = new ParametersDialog(this.shell, adapterList, this.getInerSweepNames(), this.getNameForSweep(type), "ref");
            if (dialog.open() == 0) {
                this.performAddChangesForEachChange(dialog.getElementReturn(), dialog.getRefElementReturn(), dialog.getValuesReturn());
            }
        }
    }

    private void performAddChangesForEachChange(String element, String refElement, List<String> values) {
        SweepType refSweep = this.adapter.findSweepElement(refElement, this.inerSweepList);
        SweepType newSweep = this.adapter.createNewSweepType(element);
        if (refSweep != null) {
            AssignmentType assignment = (AssignmentType)newSweep.getAssignment().get(0);
            this.adapter.setFunctionValues(assignment, values);
            refSweep.getSweep().add((Object)newSweep);
        }
        this.viewer.refresh(true);
        this.refreshSweepCombo();
        this.setInput(this.jobDefinitionType);
        this.contentChanged();
    }

    Action createIndependentSweepAction() {
        Action action = new Action(){

            public void run() {
                SweepOrderSection.this.addIndependent();
            }
        };
        action.setText("Add independent sweep...");
        return action;
    }

    Action createChangesWithSweepAction() {
        Action action = new Action(){

            public void run() {
                SweepOrderSection.this.addChangesWith();
            }
        };
        action.setText("Add sweep on the same level...");
        return action;
    }

    String getNameForSweep(SweepType type) {
        String result = null;
        EList list = type.getAssignment();
        int i = 0;
        while (i < list.size()) {
            AssignmentType assignment;
            EList paramList;
            int j;
            Object el = list.get(i);
            if (el instanceof AssignmentType && (j = 0) < (paramList = (assignment = (AssignmentType)el).getParameter()).size()) {
                result = (String)paramList.get(j);
            }
            ++i;
        }
        return result;
    }

    protected void addChangesWith() {
        StructuredSelection sSel;
        ISelection sel = this.viewer.getSelection();
        if (sel instanceof StructuredSelection && (sSel = (StructuredSelection)sel).getFirstElement() instanceof SweepType) {
            SweepType type = (SweepType)sSel.getFirstElement();
            List<String> adapterList = this.adapter.getElementsList();
            adapterList.removeAll(this.getInerSweepNames());
            ParametersDialog dialog = new ParametersDialog(this.shell, adapterList, this.getInerSweepNames(), this.getNameForSweep(type), "ref");
            if (dialog.open() == 0) {
                this.performAddChangesWith(dialog.getElementReturn(), dialog.getRefElementReturn(), dialog.getValuesReturn());
            }
        }
    }

    private void performAddChangesWith(String sweepElement, String refElement, List<String> values) {
        SweepType refSweep = this.adapter.findSweepElement(refElement, this.inerSweepList);
        AssignmentType newSweep = this.adapter.createNewAssignmentType(sweepElement);
        if (refSweep != null) {
            this.adapter.setFunctionValues(newSweep, values);
            refSweep.getAssignment().add((Object)newSweep);
        }
        this.viewer.refresh(true);
        this.refreshSweepCombo();
        this.setInput(this.jobDefinitionType);
        this.contentChanged();
    }

    private MenuManager createMenu() {
        MenuManager mManager = new MenuManager();
        mManager.setRemoveAllWhenShown(true);
        mManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mManager) {
                boolean enable = false;
                if (!SweepOrderSection.this.viewer.getSelection().isEmpty()) {
                    enable = true;
                }
                mManager.add((IContributionItem)new Separator("Zero"));
                GroupMarker marker = new GroupMarker("additions");
                mManager.add((IContributionItem)marker);
                mManager.add((IAction)SweepOrderSection.this.createNewAction());
                Action action = SweepOrderSection.this.createIndependentSweepAction();
                action.setEnabled(enable);
                mManager.add((IContributionItem)new Separator("First"));
                mManager.appendToGroup("First", (IAction)action);
                action = SweepOrderSection.this.createChangesWithSweepAction();
                action.setEnabled(enable);
                mManager.appendToGroup("First", (IAction)action);
                action = SweepOrderSection.this.createChangesForEachAction();
                action.setEnabled(enable);
                mManager.appendToGroup("First", (IAction)action);
                mManager.add((IContributionItem)new Separator("Second"));
                action = SweepOrderSection.this.createDeleteAction();
                action.setEnabled(enable);
                mManager.appendToGroup("Second", (IAction)action);
            }
        });
        mManager.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(mManager.getMenu());
        return mManager;
    }

    protected void removeSelected() {
        ISelection sel = this.viewer.getSelection();
        if (sel instanceof StructuredSelection) {
            HashMap<String, AssignmentType> paramsToRemove = new HashMap<String, AssignmentType>();
            StructuredSelection sSel = (StructuredSelection)sel;
            for (Object object : sSel.toList()) {
                if (!(object instanceof SweepType)) continue;
                SweepType sweep = (SweepType)object;
                EList assignments = sweep.getAssignment();
                int i = 0;
                while (i < assignments.size()) {
                    EList params = ((AssignmentType)assignments.get(i)).getParameter();
                    int j = 0;
                    while (j < params.size()) {
                        paramsToRemove.put((String)params.get(j), (AssignmentType)assignments.get(i));
                        ++j;
                    }
                    ++i;
                }
            }
            List<String> userDecision = new ArrayList<String>();
            boolean remove = true;
            if (paramsToRemove.size() > 1) {
                for (String a : paramsToRemove.keySet()) {
                    userDecision.add(a);
                }
                SweepDeleteDialog dialog = new SweepDeleteDialog(this.shell, userDecision);
                if (dialog.open() == 0) {
                    userDecision = dialog.getElementsToRemove();
                } else {
                    remove = false;
                }
            } else if (paramsToRemove.size() == 1) {
                userDecision = new ArrayList();
                for (String param : paramsToRemove.keySet()) {
                    userDecision.add(param);
                }
            }
            if (paramsToRemove.size() > 0 && remove) {
                for (String param : userDecision) {
                    this.performRemove((AssignmentType)paramsToRemove.get(param), param);
                }
                this.viewer.refresh();
                this.contentChanged();
            }
        }
    }

    private void performRemove(AssignmentType assignment, String assignmentParam) {
        if (assignment.eContainer() instanceof SweepType) {
            SweepType sweepContainer = (SweepType)assignment.eContainer();
            if (assignment.getParameter().size() == 1) {
                if (sweepContainer.getAssignment().size() == 1) {
                    EcoreUtil.remove((EObject)sweepContainer);
                    this.setInput(this.jobDefinitionType);
                } else {
                    EcoreUtil.remove((EObject)assignment);
                    this.setInput(this.jobDefinitionType);
                }
            } else {
                assignment.getParameter().remove((Object)assignmentParam);
                this.setInput(this.jobDefinitionType);
            }
        }
    }

    protected void addIndependent() {
        StructuredSelection sSel;
        ISelection sel = this.viewer.getSelection();
        if (sel instanceof StructuredSelection && (sSel = (StructuredSelection)sel).getFirstElement() instanceof SweepType) {
            SweepType type = (SweepType)sSel.getFirstElement();
            List<String> adapterList = this.adapter.getElementsList();
            adapterList.removeAll(this.getInerSweepNames());
            ParametersDialog dialog = new ParametersDialog(this.shell, adapterList, this.getInerSweepNames(), this.getNameForSweep(type), "ref");
            if (dialog.open() == 0) {
                this.performAddIndependent(dialog.getElementReturn(), dialog.getRefElementReturn(), dialog.getValuesReturn());
            }
        }
    }

    protected void addNew() {
        List<String> adapterList = this.adapter.getElementsList();
        adapterList.removeAll(this.getInerSweepNames());
        ParametersDialog dialog = new ParametersDialog(this.shell, adapterList, this.getInerSweepNames(), "", "new");
        if (dialog.open() == 0) {
            this.performAddIndependent(dialog.getElementReturn(), dialog.getRefElementReturn(), dialog.getValuesReturn());
        }
    }

    protected void performAddIndependent(String sweepElement, String refElement, List<String> values) {
        if (refElement == null) {
            SweepType newSweep = this.adapter.createNewSweepType(sweepElement);
            this.adapter.setFunctionValues((AssignmentType)newSweep.getAssignment().get(0), values);
            EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)SweepPackageImpl.eINSTANCE);
            FeatureMap.Entry e = FeatureMapUtil.createEntry((EStructuralFeature)eClass.getEStructuralFeature("sweep"), (Object)newSweep);
            this.jobDefinitionType.getAny().add((Object)e);
        } else {
            SweepType refSweep = this.adapter.findSweepElement(refElement, this.inerSweepList);
            SweepType newSweep = this.adapter.createNewSweepType(sweepElement);
            this.adapter.setFunctionValues((AssignmentType)newSweep.getAssignment().get(0), values);
            if (refSweep.eContainer() instanceof JobDefinitionType) {
                EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)SweepPackageImpl.eINSTANCE);
                FeatureMap.Entry e = FeatureMapUtil.createEntry((EStructuralFeature)eClass.getEStructuralFeature("sweep"), (Object)newSweep);
                ((JobDefinitionType)refSweep.eContainer()).getAny().add((Object)e);
            } else if (refSweep.eContainer() instanceof SweepType) {
                ((SweepType)refSweep.eContainer()).getSweep().add((Object)newSweep);
            }
        }
        this.viewer.refresh(true);
        this.refreshSweepCombo();
        this.setInput(this.jobDefinitionType);
        this.contentChanged();
    }
}

