/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.wizards;

import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.jsdl.ui.internal.wizards.ChildrenElements;
import eu.geclipse.jsdl.ui.internal.wizards.DataStageControlsData;
import eu.geclipse.jsdl.ui.internal.wizards.FileType;
import eu.geclipse.jsdl.ui.internal.wizards.FirstLevelElements;
import eu.geclipse.jsdl.ui.internal.wizards.Messages;
import eu.geclipse.jsdl.ui.internal.wizards.MultipleArgumentList;
import eu.geclipse.jsdl.ui.internal.wizards.StringLabelProvider;
import eu.geclipse.ui.dialogs.GridFileDialog;
import eu.geclipse.ui.dialogs.ProblemDialog;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationSpecificControlsFactory {
    ArrayList<Text> textFieldsFromParent;
    ArrayList<Text> textFieldsFromParentPositions;
    ArrayList<SelectionAdapter> adapters = new ArrayList();
    ArrayList<DataStageControlsData> parentStagingInControls;
    ArrayList<DataStageControlsData> parentStagingOutControls;
    int intFile;
    private HashMap<Control, String> parentControlsParametersNames;

    public void createControls(Element element, Composite composite, ArrayList<Text> textFieldsWithFileChooser, HashMap<Control, String> controlsParametersNames, ArrayList<DataStageControlsData> stagingIn, ArrayList<DataStageControlsData> stagingOut) {
        this.textFieldsFromParent = textFieldsWithFileChooser;
        this.parentControlsParametersNames = controlsParametersNames;
        this.parentStagingInControls = stagingIn;
        this.parentStagingOutControls = stagingOut;
        try {
            FirstLevelElements currentFirstLevelElement = FirstLevelElements.NULL;
            HashMap<ChildrenElements, String> parametersMap = new HashMap<ChildrenElements, String>();
            ArrayList<String> listValues = new ArrayList<String>();
            NodeList chilrenElements = element.getElementsByTagName("*");
            int i = 0;
            while (i < chilrenElements.getLength()) {
                Element el = (Element)chilrenElements.item(i);
                String name = el.getTagName();
                block1 : switch (FirstLevelElements.valueOfAlias(name)) {
                    case TEXT: {
                        if (!currentFirstLevelElement.equals((Object)FirstLevelElements.NULL)) {
                            this.createControl(currentFirstLevelElement, composite, parametersMap, listValues);
                        }
                        parametersMap = new HashMap();
                        listValues = new ArrayList();
                        currentFirstLevelElement = FirstLevelElements.TEXT;
                        break;
                    }
                    case LIST: {
                        if (!currentFirstLevelElement.equals((Object)FirstLevelElements.NULL)) {
                            this.createControl(currentFirstLevelElement, composite, parametersMap, listValues);
                        }
                        parametersMap = new HashMap();
                        listValues = new ArrayList();
                        currentFirstLevelElement = FirstLevelElements.LIST;
                        break;
                    }
                    case TEXT_WITH_FILE_CHOOSER: {
                        if (!currentFirstLevelElement.equals((Object)FirstLevelElements.NULL)) {
                            this.createControl(currentFirstLevelElement, composite, parametersMap, listValues);
                        }
                        parametersMap = new HashMap();
                        listValues = new ArrayList();
                        currentFirstLevelElement = FirstLevelElements.TEXT_WITH_FILE_CHOOSER;
                        break;
                    }
                    case MULTIPLE_ARGUMENTS: {
                        if (!currentFirstLevelElement.equals((Object)FirstLevelElements.NULL)) {
                            this.createControl(currentFirstLevelElement, composite, parametersMap, listValues);
                        }
                        parametersMap = new HashMap();
                        listValues = new ArrayList();
                        currentFirstLevelElement = FirstLevelElements.MULTIPLE_ARGUMENTS;
                        break;
                    }
                    case TEXT_DATA_STAGING: {
                        if (!currentFirstLevelElement.equals((Object)FirstLevelElements.NULL)) {
                            this.createControl(currentFirstLevelElement, composite, parametersMap, listValues);
                        }
                        parametersMap = new HashMap();
                        listValues = new ArrayList();
                        currentFirstLevelElement = FirstLevelElements.TEXT_DATA_STAGING;
                        break;
                    }
                    case MULTIPLE_DATA_STAGING: {
                        if (!currentFirstLevelElement.equals((Object)FirstLevelElements.NULL)) {
                            this.createControl(currentFirstLevelElement, composite, parametersMap, listValues);
                        }
                        parametersMap = new HashMap();
                        listValues = new ArrayList();
                        currentFirstLevelElement = FirstLevelElements.MULTIPLE_DATA_STAGING;
                        break;
                    }
                    case NULL: {
                        switch (ChildrenElements.valueOfAlias(name)) {
                            case ENABLED: {
                                parametersMap.put(ChildrenElements.ENABLED, el.getTextContent());
                                break block1;
                            }
                            case HINT: {
                                parametersMap.put(ChildrenElements.HINT, el.getTextContent());
                                break block1;
                            }
                            case PARAM_NAME: {
                                parametersMap.put(ChildrenElements.PARAM_NAME, el.getTextContent());
                                break block1;
                            }
                            case PARAM_PREFIX: {
                                parametersMap.put(ChildrenElements.PARAM_PREFIX, el.getTextContent());
                                break block1;
                            }
                            case VALUE: {
                                listValues.add(el.getTextContent());
                                break block1;
                            }
                            case WRITEABLE: {
                                parametersMap.put(ChildrenElements.WRITEABLE, el.getTextContent());
                                break block1;
                            }
                            case LABEL: {
                                parametersMap.put(ChildrenElements.LABEL, el.getTextContent());
                                break block1;
                            }
                            case OPTIONAL: {
                                parametersMap.put(ChildrenElements.OPTIONAL, el.getTextContent());
                                break block1;
                            }
                            case MAX_ARGUMENTS_COUNT: {
                                parametersMap.put(ChildrenElements.MAX_ARGUMENTS_COUNT, el.getTextContent());
                                break block1;
                            }
                            case MIN_ARGUMENTS_COUNT: {
                                parametersMap.put(ChildrenElements.MIN_ARGUMENTS_COUNT, el.getTextContent());
                                break block1;
                            }
                            case FILE: {
                                parametersMap.put(ChildrenElements.FILE, el.getTextContent());
                                break block1;
                            }
                        }
                    }
                }
                ++i;
            }
            if (!currentFirstLevelElement.equals((Object)FirstLevelElements.NULL)) {
                this.createControl(currentFirstLevelElement, composite, parametersMap, listValues);
            }
        }
        catch (IllegalArgumentException iaExc) {
            ProblemException exception = new ProblemException("eu.geclipse.jsdl.ui.applicationSpecificPages.XMLProblem", (Throwable)iaExc, "eu.geclipse.jsdl.ui");
            ProblemDialog.openProblem((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Problem", (String)"There was a problem with XML", (Throwable)exception);
        }
    }

    private void createControl(FirstLevelElements currentFirstLevelElement, Composite composite, HashMap<ChildrenElements, String> parametersMap, ArrayList<String> listValues) {
        switch (currentFirstLevelElement) {
            case TEXT: {
                this.createTextControl(composite, parametersMap);
                break;
            }
            case LIST: {
                this.createListControl(composite, parametersMap, listValues);
                break;
            }
            case TEXT_WITH_FILE_CHOOSER: {
                this.createTextWithFileChooserControl(composite, parametersMap);
                break;
            }
            case MULTIPLE_ARGUMENTS: {
                this.createMultipleArgumentsListControl(composite, parametersMap);
                break;
            }
            case TEXT_DATA_STAGING: {
                this.createTextDataStagingControl(composite, parametersMap);
                break;
            }
        }
    }

    private void createTextDataStagingControl(Composite composite, HashMap<ChildrenElements, String> parametersMap) {
        GridData layout = new GridData();
        Label textLabel = new Label(composite, 0);
        if (parametersMap.containsKey((Object)ChildrenElements.LABEL)) {
            textLabel.setText(parametersMap.get((Object)ChildrenElements.LABEL));
        }
        layout.horizontalAlignment = 1;
        layout.verticalAlignment = 2;
        textLabel.setLayoutData((Object)layout);
        layout = new GridData();
        layout.verticalAlignment = 2;
        layout.horizontalAlignment = 4;
        layout.horizontalSpan = 3;
        layout.grabExcessHorizontalSpace = true;
        textLabel.setLayoutData((Object)layout);
        Label nameLabel = new Label(composite, 0);
        layout = new GridData();
        layout.horizontalIndent = 30;
        nameLabel.setLayoutData((Object)layout);
        nameLabel.setText(Messages.getString("ApplicationSpecificControlsFactory.0"));
        Text textControlName = new Text(composite, 2048);
        layout = new GridData();
        layout.horizontalSpan = 2;
        layout.horizontalAlignment = 4;
        textControlName.setLayoutData((Object)layout);
        Label URILabel = new Label(composite, 0);
        layout = new GridData();
        layout.horizontalIndent = 30;
        URILabel.setLayoutData((Object)layout);
        URILabel.setText(Messages.getString("ApplicationSpecificControlsFactory.1"));
        Text textControlURI = new Text(composite, 2048);
        layout = new GridData();
        layout.horizontalAlignment = 4;
        String paramName = Messages.getString("ApplicationSpecificControlsFactory.2");
        FileType fileType = FileType.NULL;
        this.intFile = 0;
        for (ChildrenElements child : parametersMap.keySet()) {
            switch (child) {
                case ENABLED: {
                    boolean enabled = false;
                    if (parametersMap.get((Object)child).compareToIgnoreCase(Boolean.TRUE.toString()) == 0) {
                        enabled = true;
                    }
                    textControlName.setEnabled(enabled);
                    textControlURI.setEnabled(enabled);
                    break;
                }
                case HINT: {
                    textControlName.setToolTipText(parametersMap.get((Object)child));
                    textControlURI.setToolTipText(parametersMap.get((Object)child));
                    break;
                }
                case PARAM_NAME: {
                    paramName = parametersMap.get((Object)child);
                    break;
                }
                case FILE: {
                    fileType = FileType.valueOfAlias(parametersMap.get((Object)child));
                    break;
                }
            }
        }
        switch (fileType) {
            case INPUT: {
                this.parentStagingInControls.add(new DataStageControlsData(paramName, (Control)textControlName, (Control)textControlURI));
                this.intFile = 1;
                break;
            }
            case OUTPUT: {
                this.parentStagingOutControls.add(new DataStageControlsData(paramName, (Control)textControlName, (Control)textControlURI));
                this.intFile = -1;
                break;
            }
        }
        Button fileButton = new Button(composite, 8);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        Image fileImage = sharedImages.getImage("IMG_OBJ_FILE");
        fileButton.setImage(fileImage);
        layout = new GridData();
        this.adapters.add(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URI[] uris;
                String filename = null;
                GridFileDialog dialog = new GridFileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 0);
                if (dialog.open() == 0 && (uris = dialog.getSelectedURIs()) != null && uris.length > 0) {
                    filename = uris[0].toString();
                }
                if (filename != null) {
                    Text con;
                    if (ApplicationSpecificControlsFactory.this.intFile == 1) {
                        con = (Text)ApplicationSpecificControlsFactory.this.parentStagingInControls.get(ApplicationSpecificControlsFactory.this.adapters.indexOf((Object)this)).getURIControl();
                        con.setText(filename);
                    } else {
                        con = (Text)ApplicationSpecificControlsFactory.this.parentStagingOutControls.get(ApplicationSpecificControlsFactory.this.adapters.indexOf((Object)this)).getURIControl();
                        con.setText(filename);
                    }
                }
            }
        });
        fileButton.addSelectionListener((SelectionListener)this.adapters.get(this.adapters.size() - 1));
        fileButton.setLayoutData((Object)layout);
    }

    private void createTextControl(Composite composite, HashMap<ChildrenElements, String> parametersMap) {
        GridData layout = new GridData();
        Label textLabel = new Label(composite, 0);
        if (parametersMap.containsKey((Object)ChildrenElements.LABEL)) {
            textLabel.setText(parametersMap.get((Object)ChildrenElements.LABEL));
        }
        layout.horizontalAlignment = 1;
        layout.verticalAlignment = 2;
        textLabel.setLayoutData((Object)layout);
        layout = new GridData();
        layout.verticalAlignment = 2;
        layout.horizontalAlignment = 4;
        layout.horizontalSpan = 2;
        layout.grabExcessHorizontalSpace = true;
        Text textControl = new Text(composite, 2048);
        for (ChildrenElements child : parametersMap.keySet()) {
            switch (child) {
                case ENABLED: {
                    boolean enabled = false;
                    if (parametersMap.get((Object)child).compareToIgnoreCase(Boolean.TRUE.toString()) == 0) {
                        enabled = true;
                    }
                    textControl.setEnabled(enabled);
                    break;
                }
                case HINT: {
                    textControl.setToolTipText(parametersMap.get((Object)child));
                    break;
                }
                case PARAM_NAME: {
                    this.parentControlsParametersNames.put((Control)textControl, parametersMap.get((Object)child));
                    break;
                }
            }
        }
        textControl.setLayoutData((Object)layout);
    }

    private void createListControl(Composite composite, HashMap<ChildrenElements, String> parametersMap, ArrayList<String> values) {
        GridData layout = new GridData();
        Label textLabel = new Label(composite, 0);
        if (parametersMap.containsKey((Object)ChildrenElements.LABEL)) {
            textLabel.setText(parametersMap.get((Object)ChildrenElements.LABEL));
        }
        layout.horizontalAlignment = 1;
        layout.verticalAlignment = 2;
        textLabel.setLayoutData((Object)layout);
        layout = new GridData();
        layout.verticalAlignment = 2;
        layout.horizontalAlignment = 4;
        layout.horizontalSpan = 2;
        layout.grabExcessHorizontalSpace = true;
        boolean isReadOnly = true;
        if (parametersMap.containsKey((Object)ChildrenElements.WRITEABLE) && parametersMap.get((Object)ChildrenElements.WRITEABLE).equalsIgnoreCase(Boolean.TRUE.toString())) {
            isReadOnly = false;
        }
        Combo listControl = isReadOnly ? new Combo(composite, 8) : new Combo(composite, 0);
        for (ChildrenElements child : parametersMap.keySet()) {
            switch (child) {
                case ENABLED: {
                    boolean enabled = false;
                    if (parametersMap.get((Object)child).equalsIgnoreCase(Boolean.TRUE.toString())) {
                        enabled = true;
                    }
                    listControl.setEnabled(enabled);
                    break;
                }
                case HINT: {
                    listControl.setToolTipText(parametersMap.get((Object)child));
                    break;
                }
                case PARAM_NAME: {
                    this.parentControlsParametersNames.put((Control)listControl, parametersMap.get((Object)child));
                    break;
                }
            }
        }
        for (String value : values) {
            listControl.add(value);
        }
        listControl.setLayoutData((Object)layout);
    }

    private void createTextWithFileChooserControl(Composite composite, HashMap<ChildrenElements, String> parametersMap) {
        GridData layout = new GridData();
        Label textLabel = new Label(composite, 0);
        if (parametersMap.containsKey((Object)ChildrenElements.LABEL)) {
            textLabel.setText(parametersMap.get((Object)ChildrenElements.LABEL));
        }
        layout.horizontalAlignment = 1;
        layout.verticalAlignment = 2;
        textLabel.setLayoutData((Object)layout);
        layout = new GridData();
        layout.verticalAlignment = 2;
        layout.horizontalAlignment = 4;
        layout.horizontalSpan = 1;
        layout.grabExcessHorizontalSpace = true;
        Text textControl = new Text(composite, 2048);
        for (ChildrenElements child : parametersMap.keySet()) {
            switch (child) {
                case ENABLED: {
                    boolean enabled = false;
                    if (parametersMap.get((Object)child).compareToIgnoreCase(Boolean.TRUE.toString()) == 0) {
                        enabled = true;
                    }
                    textControl.setEnabled(enabled);
                    break;
                }
                case HINT: {
                    textControl.setToolTipText(parametersMap.get((Object)child));
                    break;
                }
                case PARAM_NAME: {
                    this.parentControlsParametersNames.put((Control)textControl, parametersMap.get((Object)child));
                    break;
                }
            }
        }
        textControl.setLayoutData((Object)layout);
        Button fileButton = new Button(composite, 8);
        if (this.textFieldsFromParent.isEmpty()) {
            this.textFieldsFromParent.add(textControl);
        } else {
            this.textFieldsFromParent.add(this.textFieldsFromParent.size(), textControl);
        }
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        Image fileImage = sharedImages.getImage("IMG_OBJ_FILE");
        fileButton.setImage(fileImage);
        layout = new GridData(276);
        this.adapters.add(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                URI[] uris;
                GridFileDialog dialog = new GridFileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 0);
                if (dialog.open() == 0 && (uris = dialog.getSelectedURIs()) != null && uris.length > 0) {
                    ApplicationSpecificControlsFactory.this.textFieldsFromParent.get(ApplicationSpecificControlsFactory.this.adapters.indexOf((Object)this)).setText(uris[0].toString());
                }
            }
        });
        fileButton.addSelectionListener((SelectionListener)this.adapters.get(this.adapters.size() - 1));
        fileButton.setLayoutData((Object)layout);
    }

    private void createMultipleArgumentsListControl(Composite composite, HashMap<ChildrenElements, String> parametersMap) {
        GridData layout = new GridData();
        Label textLabel = new Label(composite, 0);
        if (parametersMap.containsKey((Object)ChildrenElements.LABEL)) {
            textLabel.setText(parametersMap.get((Object)ChildrenElements.LABEL));
        }
        layout.horizontalAlignment = 1;
        layout.verticalAlignment = 2;
        textLabel.setLayoutData((Object)layout);
        layout = new GridData();
        layout.verticalAlignment = 2;
        layout.horizontalAlignment = 4;
        layout.horizontalSpan = 2;
        layout.grabExcessHorizontalSpace = true;
        ArrayList<String> temp = new ArrayList<String>();
        if (parametersMap.containsKey((Object)ChildrenElements.LABEL)) {
            temp.add(parametersMap.get((Object)ChildrenElements.LABEL));
        }
        MultipleArgumentList multipleList = new MultipleArgumentList((IStructuredContentProvider)new ArrayContentProvider(), new StringLabelProvider(), temp);
        multipleList.createControl(composite);
        multipleList.getControl().setSize(2, 10);
        multipleList.getControl().setLayoutData((Object)layout);
    }
}

