/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.providers;

import eu.geclipse.jsdl.model.base.FileSystemType;
import eu.geclipse.jsdl.model.posix.ArgumentType;
import eu.geclipse.jsdl.model.posix.EnvironmentType;
import eu.geclipse.jsdl.ui.internal.Activator;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class FeatureLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final int STRING_TYPE_DEFAULT = 1;
    public static final int STRING_TYPE_ANNOTATION = 2;
    public static final int STRING_TYPE_PROJECT = 3;
    public static final int STRING_TYPE_CANDIDATE_HOSTS = 4;
    private Image argsImage;
    private Image candHostsImage;
    private Image projectsImage;
    private Image annotationImage;
    private int stringType;

    public FeatureLabelProvider() {
        this.loadImages();
        this.stringType = 1;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        block0 : switch (columnIndex) {
            case 0: {
                if (element instanceof ArgumentType) {
                    image = this.argsImage;
                    break;
                }
                if (!(element instanceof String)) break;
                switch (this.stringType) {
                    case 2: {
                        image = this.annotationImage;
                        break block0;
                    }
                    case 3: {
                        image = this.projectsImage;
                        break block0;
                    }
                    case 4: {
                        image = this.candHostsImage;
                        break block0;
                    }
                }
                break;
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = null;
        Object[] array = null;
        if (element instanceof ArgumentType) {
            ArgumentType argumentType = (ArgumentType)element;
            switch (columnIndex) {
                case 0: {
                    text = argumentType.getFilesystemName();
                    break;
                }
                case 1: {
                    text = argumentType.getValue();
                    break;
                }
            }
        } else if (element instanceof EnvironmentType) {
            EnvironmentType environmentType = (EnvironmentType)element;
            switch (columnIndex) {
                case 0: {
                    text = environmentType.getName();
                    break;
                }
                case 1: {
                    text = environmentType.getFilesystemName();
                    break;
                }
                case 2: {
                    text = environmentType.getValue();
                    break;
                }
            }
        } else if (element instanceof FileSystemType) {
            FileSystemType fileSystemType = (FileSystemType)element;
            switch (columnIndex) {
                case 0: {
                    text = fileSystemType.getName();
                    break;
                }
                case 1: {
                    text = fileSystemType.getFileSystemType().toString();
                    break;
                }
                case 2: {
                    text = fileSystemType.getMountPoint();
                    break;
                }
            }
        } else if (element instanceof Object[]) {
            array = (Object[])element;
        } else {
            switch (columnIndex) {
                case 0: {
                    text = element.toString();
                    break;
                }
            }
        }
        if (array != null && columnIndex < array.length) {
            text = this.getText(array[columnIndex]);
        }
        return text;
    }

    public void setStringType(int type) {
        this.stringType = type;
    }

    void loadImages() {
        URL argsURL = Activator.getDefault().getBundle().getEntry("icons/args.gif");
        URL candHostsURL = Activator.getDefault().getBundle().getEntry("icons/computing_obj.gif");
        URL projectsURL = Activator.getDefault().getBundle().getEntry("icons/gridprojects.gif");
        URL annotationURL = Activator.getDefault().getBundle().getEntry("icons/annotation_obj.gif");
        ImageDescriptor argsDesc = ImageDescriptor.createFromURL((URL)argsURL);
        ImageDescriptor candHostsDesc = ImageDescriptor.createFromURL((URL)candHostsURL);
        ImageDescriptor projectsDesc = ImageDescriptor.createFromURL((URL)projectsURL);
        ImageDescriptor annotDesc = ImageDescriptor.createFromURL((URL)annotationURL);
        this.argsImage = argsDesc.createImage();
        this.candHostsImage = candHostsDesc.createImage();
        this.projectsImage = projectsDesc.createImage();
        this.annotationImage = annotDesc.createImage();
    }
}

