/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.wizards;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridElementCreator;
import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IVirtualOrganization;
import eu.geclipse.core.model.IWrappedElement;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.jsdl.JSDLJobDescriptionCreator;
import eu.geclipse.jsdl.model.base.DataStagingType;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.wizards.FileType;
import eu.geclipse.jsdl.ui.wizards.DataStagingNewJobWizardPage;
import eu.geclipse.jsdl.ui.wizards.ExecutableNewJobWizardPage;
import eu.geclipse.jsdl.ui.wizards.Messages;
import eu.geclipse.jsdl.ui.wizards.specific.IApplicationSpecificPage;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.wizards.IProjectSelectionProvider;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewJobWizard
extends Wizard
implements INewWizard,
IProjectSelectionProvider {
    private IStructuredSelection selection;
    private FirstPage firstPage;
    private IFile file;
    private ExecutableNewJobWizardPage executablePage;
    private DataStagingNewJobWizardPage outputFilesPage;
    private JSDLJobDescription basicJSDL;
    private String appName = "";
    private boolean hasFinished = false;

    public void addPages() {
        this.firstPage = new FirstPage(Messages.getString("NewJobWizard.first_page_name"), this.selection);
        this.firstPage.setTitle(Messages.getString("NewJobWizard.first_page_title"));
        this.firstPage.setDescription(Messages.getString("NewJobWizard.first_page_description"));
        this.addPage((IWizardPage)this.firstPage);
        ArrayList<WizardPage> internal = new ArrayList<WizardPage>();
        this.outputFilesPage = new DataStagingNewJobWizardPage(Messages.getString("NewJobWizard.files_output_new_job_page_name"));
        internal.add(this.outputFilesPage);
        this.executablePage = new ExecutableNewJobWizardPage(Messages.getString("NewJobWizard.executablePageName"), internal);
        this.addPage((IWizardPage)this.executablePage);
    }

    public void init(IWorkbench workbench, IStructuredSelection sel) {
        this.setWindowTitle(Messages.getString("NewJobWizard.windowTitle"));
        this.setNeedsProgressMonitor(true);
        this.selection = sel;
    }

    public boolean performFinish() {
        boolean result = false;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    NewJobWizard.this.createFile(monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, true, op);
            result = true;
            this.openFile();
        }
        catch (InterruptedException interruptedException) {
            result = false;
        }
        catch (InvocationTargetException iTExc) {
            Throwable realException = iTExc.getCause();
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ProblemDialog.openProblem((Shell)shell, (String)Messages.getString("NewJobWizard.invocation_error_title"), (String)Messages.getString("NewJobWizard.invocation_title_message"), (Throwable)realException);
            result = false;
        }
        return result;
    }

    private void openFile() {
        try {
            if (this.file.exists()) {
                IDE.openEditor((IWorkbenchPage)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.file, (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            Activator.logException(partInitException);
        }
    }

    IPath getProject() {
        return this.firstPage.getContainerFullPath();
    }

    protected void createFile(IProgressMonitor monitor) {
        block15: {
            boolean translate;
            monitor.beginTask(String.valueOf(Messages.getString("NewJobWizard.creating_task")) + this.firstPage.getFileName(), 2);
            IGridElementCreator creator = this.firstPage.getCreator();
            boolean bl = translate = creator != null && !(creator instanceof JSDLJobDescriptionCreator);
            if (translate) {
                String fileName = this.firstPage.getFileName();
                Path path = new Path(fileName);
                fileName = path.removeFileExtension().addFileExtension("jsdl").lastSegment();
                this.firstPage.setFileName(fileName);
            }
            this.file = this.firstPage.createNewFile();
            JSDLJobDescription jsdlJobDescription = null;
            IGridElement element = GridModel.getRoot().findElement((IResource)this.file);
            if (element instanceof JSDLJobDescription) {
                jsdlJobDescription = (JSDLJobDescription)element;
            }
            monitor.worked(1);
            monitor.setTaskName(String.valueOf(Messages.getString("NewJobWizard.setting_contents_task")) + this.firstPage.getFileName());
            if (jsdlJobDescription != null) {
                this.setInitialModel(jsdlJobDescription);
                jsdlJobDescription.save();
            }
            if (translate) {
                try {
                    try {
                        creator.setSource((Object)jsdlJobDescription);
                        IGridElement newElement = creator.create(jsdlJobDescription.getParent());
                        this.file = (IFile)newElement.getResource();
                    }
                    catch (ProblemException pExc) {
                        ProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("NewJobWizard.CreationFailed"), (String)Messages.getString("NewJobWizard.ErrorCreatingJobDescription"), (Throwable)pExc);
                        try {
                            jsdlJobDescription.getResource().delete(true, null);
                        }
                        catch (CoreException cExc) {
                            ProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("NewJobWizard.DeletionFailed"), (String)Messages.getString("NewJobWizard.UnableToDelete"), (Throwable)cExc);
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        jsdlJobDescription.getResource().delete(true, null);
                    }
                    catch (CoreException cExc) {
                        ProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("NewJobWizard.DeletionFailed"), (String)Messages.getString("NewJobWizard.UnableToDelete"), (Throwable)cExc);
                    }
                    throw throwable;
                }
                try {
                    jsdlJobDescription.getResource().delete(true, null);
                }
                catch (CoreException cExc) {
                    ProblemDialog.openProblem((Shell)this.getShell(), (String)Messages.getString("NewJobWizard.DeletionFailed"), (String)Messages.getString("NewJobWizard.UnableToDelete"), (Throwable)cExc);
                }
            }
        }
        monitor.worked(1);
    }

    void setInitialModel(JSDLJobDescription jsdl) {
        this.executablePage.getApplicationSpecificPage();
        if (this.getContainer().getCurrentPage() != this.outputFilesPage) {
            JSDLJobDescription tempJSDL = this.executablePage.getBasicJSDL();
            String tempAppName = this.executablePage.getApplicationName();
            if (!tempAppName.equals(this.appName)) {
                this.updateBasicJSDL(tempJSDL, tempAppName);
                if (this.basicJSDL != null) {
                    jsdl.setRoot(this.basicJSDL.getDocumentRoot());
                } else {
                    jsdl.setUpBasicJSDLStructure();
                }
            } else if (this.basicJSDL != null) {
                this.basicJSDL.removeDataStaging();
                jsdl.setRoot(this.basicJSDL.getDocumentRoot());
            } else {
                jsdl.setUpBasicJSDLStructure();
            }
        } else if (this.basicJSDL != null) {
            this.basicJSDL.removeDataStaging();
            jsdl.setRoot(this.basicJSDL.getDocumentRoot());
        } else {
            jsdl.setUpBasicJSDLStructure();
        }
        String applicationName = this.executablePage.getApplicationName();
        if (applicationName.equals("")) {
            applicationName = this.file.getName();
            applicationName = applicationName.substring(0, applicationName.indexOf("."));
        }
        jsdl.setJobIdentification(applicationName, null);
        String appName1 = "";
        appName1 = this.executablePage.getApplicationName().equals("") ? applicationName : this.executablePage.getApplicationName();
        String in = null;
        String out = null;
        String err = null;
        String inName = null;
        String outName = null;
        String errName = null;
        in = this.executablePage.getStdin();
        out = this.executablePage.getStdout();
        err = this.executablePage.getStderr();
        if (in.equals("")) {
            in = null;
        } else {
            inName = in.lastIndexOf("/") != -1 ? in.substring(in.lastIndexOf("/") + 1) : "stdIn";
        }
        if (out.equals("")) {
            out = null;
        } else {
            outName = out.lastIndexOf("/") != -1 ? out.substring(out.lastIndexOf("/") + 1) : "stdOut";
        }
        if (err.equals("")) {
            err = null;
        } else {
            errName = err.lastIndexOf("/") != -1 ? err.substring(err.lastIndexOf("/") + 1) : "stdErr";
        }
        String execName = this.executablePage.getExecutableFile();
        jsdl.setApplicationName(appName1);
        if (!execName.equals("")) {
            try {
                URI test = new URI(execName);
                if (test.getScheme() != null) {
                    String execNameTemp = test.toString().substring(test.toString().lastIndexOf("/") + 1, test.toString().length());
                    jsdl.addDataStagingIn(execNameTemp, execName);
                    execName = execNameTemp;
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
            jsdl.setPOSIXApplicationDetails(appName1, execName, in, inName, out, outName, err, errName);
        }
        if (this.outputFilesPage.isCreated()) {
            List<DataStagingType> outFiles = this.outputFilesPage.getFiles(FileType.OUTPUT);
            if (!outFiles.isEmpty()) {
                for (DataStagingType data : outFiles) {
                    jsdl.addDataStagingOut(data.getFileName(), data.getTarget().getURI());
                }
            }
            if (!(outFiles = this.outputFilesPage.getFiles(FileType.INPUT)).isEmpty()) {
                for (DataStagingType data : outFiles) {
                    jsdl.addDataStagingIn(data.getFileName(), data.getSource().getURI());
                }
            }
        }
        ArrayList<String> argList = this.executablePage.getArgumentsList();
        for (String argumentFormLine : argList) {
            jsdl.addArgument(argumentFormLine);
        }
        List<IApplicationSpecificPage> aspList = this.executablePage.getApplicationSpecificPages();
        if (aspList != null) {
            for (IApplicationSpecificPage asp : aspList) {
                Map<String, Properties> stagingIn;
                Map<String, ArrayList<String>> arguments = asp.getParametersValues();
                if (arguments != null) {
                    for (String argName : arguments.keySet()) {
                        jsdl.addArgumentForPosixApplication(argName, arguments.get(argName));
                    }
                }
                if ((stagingIn = asp.getStageInFiles()) == null) continue;
                for (String argName : stagingIn.keySet()) {
                    Enumeration<?> vals = stagingIn.get(argName).propertyNames();
                    ArrayList<String> values = new ArrayList<String>();
                    while (vals.hasMoreElements()) {
                        values.add((String)vals.nextElement());
                    }
                    jsdl.addArgumentForPosixApplication(argName, values);
                    for (String value : values) {
                        jsdl.addDataStagingIn(value, stagingIn.get(argName).getProperty(value));
                    }
                }
                Map<String, Properties> stagingOut = asp.getStageOutFiles();
                if (stagingOut == null) continue;
                for (String argName : stagingOut.keySet()) {
                    Enumeration<?> vals = stagingOut.get(argName).propertyNames();
                    ArrayList<String> values = new ArrayList<String>();
                    while (vals.hasMoreElements()) {
                        values.add((String)vals.nextElement());
                    }
                    jsdl.addArgumentForPosixApplication(argName, values);
                    for (String value : values) {
                        jsdl.addDataStagingOut(value, stagingOut.get(argName).getProperty(value));
                    }
                }
            }
        }
    }

    void updateBasicJSDL(JSDLJobDescription newBasicJSDL, String aspName) {
        boolean fromPreSet = false;
        if (this.basicJSDL != null) {
            fromPreSet = true;
        }
        this.basicJSDL = newBasicJSDL;
        this.appName = aspName;
        if (this.basicJSDL != null) {
            this.outputFilesPage.setInitialStagingOutModel(this.basicJSDL.getDataStagingOut());
            this.outputFilesPage.setInitialStagingInModel(this.basicJSDL.getDataStagingIn());
        } else if (!fromPreSet) {
            this.outputFilesPage.setInitialStagingInModel(this.outputFilesPage.getFiles(FileType.INPUT));
            this.outputFilesPage.setInitialStagingOutModel(this.outputFilesPage.getFiles(FileType.OUTPUT));
        } else {
            this.outputFilesPage.setInitialStagingOut(null);
            this.outputFilesPage.setInitialStagingIn(null);
        }
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public IVirtualOrganization getVirtualOrganization() {
        IVirtualOrganization result = null;
        if (this.firstPage != null) {
            IPath path = this.firstPage.getContainerFullPath();
            path = path.removeLastSegments(path.segmentCount() - 1);
            IGridElement project = GridModel.getRoot().findElement(path);
            if (project instanceof IGridProject && (result = ((IGridProject)project).getVO()) instanceof IWrappedElement) {
                result = (IVirtualOrganization)((IWrappedElement)result).getWrappedElement();
            }
        }
        return result;
    }

    public boolean getIsFinished() {
        return this.hasFinished;
    }

    public IGridProject getGridProject() {
        IGridProject result = null;
        if (this.firstPage != null) {
            IPath path = this.firstPage.getContainerFullPath();
            path = path.removeLastSegments(path.segmentCount() - 1);
            IGridElement project = GridModel.getRoot().findElement(path);
            if (project instanceof IGridProject) {
                result = (IGridProject)project;
            }
        }
        return result;
    }

    class FirstPage
    extends WizardNewFileCreationPage {
        private static final String JSDL_STANDARD = "JSDL - Job Submission Description Language (OGF Standard)";
        private IStructuredSelection iniSelection;
        private final String initFileName;
        private Combo typeCombo;
        private Hashtable<String, IGridElementCreator> creators;

        public FirstPage(String pageName, IStructuredSelection selection) {
            super(pageName, selection);
            this.initFileName = Messages.getString(Messages.getString("NewJobWizard.DefaultFileName"));
            this.creators = new Hashtable();
            this.iniSelection = selection;
        }

        public void createControl(Composite parent) {
            Layout layout;
            Composite mainComp = new Composite(parent, 0);
            mainComp.setLayout((Layout)new GridLayout(1, false));
            Label typeLabel = new Label(mainComp, 0);
            typeLabel.setText(Messages.getString("NewJobWizard.JobDescriptionType"));
            typeLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            this.typeCombo = new Combo(mainComp, 8);
            this.typeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FirstPage.this.updateFilename();
                }
            });
            super.createControl(mainComp);
            Control control = this.getControl();
            if (control instanceof Composite && (layout = ((Composite)control).getLayout()) instanceof GridLayout) {
                GridLayout gLayout = (GridLayout)layout;
                gLayout.marginHeight = 0;
                gLayout.marginWidth = 0;
            }
            this.setControl((Control)mainComp);
            this.initTypeCombo(this.typeCombo);
            this.setFileName(this.getUniqueFileName());
        }

        public IGridElementCreator getCreator() {
            String type = this.typeCombo.getText();
            return this.creators.get(type);
        }

        public String getDescriptionSuffix() {
            int index;
            String result = Messages.getString("NewJobWizard.JSDL");
            String text = this.typeCombo.getText();
            if (text != null && (index = text.trim().indexOf(" ")) != -1) {
                result = text.substring(0, index).toLowerCase();
            }
            return result;
        }

        public String getUniqueFileName() {
            IPath containerFullPath = this.getContainerFullPath();
            String fileName = this.initFileName;
            String extension = this.getDescriptionSuffix();
            if (containerFullPath == null) {
                containerFullPath = new Path("");
            }
            if (fileName == null || fileName.trim().length() == 0) {
                fileName = "default";
            }
            IPath filePath = containerFullPath.append(fileName);
            if (extension != null && !extension.equals(filePath.getFileExtension())) {
                filePath = filePath.addFileExtension(extension);
            }
            extension = filePath.getFileExtension();
            fileName = filePath.removeFileExtension().lastSegment();
            int i = 0;
            while (ResourcesPlugin.getWorkspace().getRoot().exists(filePath)) {
                filePath = containerFullPath.append(String.valueOf(fileName) + ++i);
                if (extension == null) continue;
                filePath = filePath.addFileExtension(extension);
            }
            return filePath.lastSegment();
        }

        protected void updateFilename() {
            String filename = this.getFileName();
            String extension = this.getDescriptionSuffix();
            if (filename == null) {
                filename = this.getUniqueFileName();
            }
            Path path = new Path(filename);
            this.setFileName(path.removeFileExtension().addFileExtension(extension).lastSegment());
            this.validatePage();
        }

        protected boolean validatePage() {
            boolean result = true;
            if (!super.validatePage()) {
                result = false;
            }
            String extension = this.getDescriptionSuffix();
            Path path = new Path(this.getFileName());
            String currentExtension = path.getFileExtension();
            if (currentExtension == null || !currentExtension.toLowerCase().endsWith(extension)) {
                this.setErrorMessage(String.format(Messages.getString("NewJobWizard.wrong_file_extension_error_message"), extension));
                result = false;
            }
            return result;
        }

        protected IPath getFilePath() {
            String fileName;
            IPath path = this.getContainerFullPath();
            if (path == null) {
                path = new Path("");
            }
            if ((fileName = this.getFileName()) != null) {
                path = path.append(fileName);
            }
            return path;
        }

        public boolean canFlipToNextPage() {
            return super.canFlipToNextPage();
        }

        protected void initialPopulateContainerNameField() {
            Object obj = this.iniSelection.getFirstElement();
            if (obj instanceof IGridContainer) {
                IPath ePath;
                IPath cPath;
                IGridContainer descriptions;
                IGridElement element = (IGridElement)obj;
                IGridProject project = element.getProject();
                if (project != null && (descriptions = project.getProjectFolder(IGridJobDescription.class)) != null && !(cPath = descriptions.getPath()).isPrefixOf(ePath = element.getPath())) {
                    element = descriptions;
                }
                super.setContainerFullPath(element.getPath());
            } else {
                super.initialPopulateContainerNameField();
            }
        }

        private void initTypeCombo(Combo combo) {
            List elements = GridModel.getCreatorRegistry().getConfigurations(JSDLJobDescription.class, IGridJobDescription.class);
            ArrayList<String> names = new ArrayList<String>();
            for (IConfigurationElement element : elements) {
                try {
                    IGridElementCreator creator = (IGridElementCreator)element.createExecutableExtension("class");
                    String name = element.getAttribute("name");
                    this.creators.put(name, creator);
                    names.add(name);
                }
                catch (CoreException e) {
                    Activator.logException(e);
                }
            }
            names.add(JSDL_STANDARD);
            Collections.sort(names);
            for (String name : names) {
                combo.add(name);
            }
            combo.setText(JSDL_STANDARD);
        }
    }
}

