/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.parametric.internal;

import eu.geclipse.jsdl.parametric.ParametricJsdlException;
import eu.geclipse.jsdl.parametric.internal.IFunction;
import eu.geclipse.jsdl.parametric.internal.IGenerationContext;
import eu.geclipse.jsdl.xpath.XPathDocument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Assignment {
    private List<String> xPathQueries;
    private IFunction function;

    Assignment(XPathDocument pathDocument, NodeList parameters, IFunction function) throws ParametricJsdlException {
        this.function = function;
        this.initXpathExpressions(parameters);
        if (function == null) {
            String msg = String.format("Parameter: %s\nhas not defined any Value or Loop", this.xPathQueries.isEmpty() ? "" : this.xPathQueries.get(0));
            throw new ParametricJsdlException(msg);
        }
    }

    private void initXpathExpressions(NodeList parameters) throws ParametricJsdlException {
        this.xPathQueries = new ArrayList<String>(parameters.getLength());
        int index = 0;
        while (index < parameters.getLength()) {
            Node item = parameters.item(index);
            String textContent = item.getTextContent();
            if (textContent == null || textContent.length() == 0) {
                throw new ParametricJsdlException("<sweep:Parameter> should contain XPath query selecting node in JSDL");
            }
            this.xPathQueries.add(textContent);
            ++index;
        }
    }

    void setParamValue(Iterator<String> functionIterator, IGenerationContext generationContext) throws ParametricJsdlException {
        String value = functionIterator.next();
        for (String xpathQuery : this.xPathQueries) {
            generationContext.setValue(xpathQuery, value);
        }
    }

    public IFunction getFunction() {
        return this.function;
    }

    List<String> getXPathQueries() {
        return this.xPathQueries;
    }
}

