/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.parametric.internal;

import eu.geclipse.jsdl.parametric.ParametricJsdlException;
import eu.geclipse.jsdl.parametric.internal.IFunction;
import eu.geclipse.jsdl.xpath.XPathDocument;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FunctionIntegerLoop
implements IFunction {
    int start;
    int end;
    int step;
    Set<Integer> exceptions;

    FunctionIntegerLoop(NodeList nodes, XPathDocument xpath) throws ParametricJsdlException {
        Node item;
        if (nodes.getLength() == 1) {
            item = nodes.item(0);
            this.start = this.getIntAttribute(item, "sweepfunc:start", true, 0);
            this.end = this.getIntAttribute(item, "sweepfunc:end", true, 0);
            this.step = this.getIntAttribute(item, "sweepfunc:step", false, 1);
            if (this.step == 0) {
                throw new ParametricJsdlException("<sweepfunc:Loop> cannot has step equal to 0.");
            }
        } else {
            throw new ParametricJsdlException("<sweep:Assignment> can contain only one <sweepfunc:Loop>, whilst contain %d loops.");
        }
        this.exceptions = this.readExceptions(item, xpath);
    }

    private int getIntAttribute(Node item, String attrName, boolean mandatory, int defaultValue) throws ParametricJsdlException {
        int value = defaultValue;
        String textContent = null;
        try {
            NamedNodeMap attributes = item.getAttributes();
            Node attr = attributes.getNamedItem(attrName);
            if (attr != null) {
                textContent = attr.getTextContent();
                value = Integer.parseInt(textContent);
            } else if (mandatory) {
                String msg = String.format("Attribute <%s> is missing", attrName);
                throw new ParametricJsdlException(msg);
            }
        }
        catch (NumberFormatException exception) {
            String msg = String.format("<%s> should contain integer number, whilst it contain value '%s'", attrName, textContent == null ? "" : textContent);
            throw new ParametricJsdlException(msg, exception);
        }
        return value;
    }

    private Set<Integer> readExceptions(Node loopNode, XPathDocument xpath) throws ParametricJsdlException {
        try {
            HashSet<Integer> exceptionsSet = new HashSet<Integer>();
            if (loopNode instanceof Element) {
                Element loopElement = (Element)loopNode;
                NodeList nodeList = xpath.getNodes(loopElement, "./sweepfunc:Exception");
                int index = 0;
                while (index < nodeList.getLength()) {
                    Node exceptionNode = nodeList.item(index);
                    exceptionsSet.add(this.getIntAttribute(exceptionNode, "sweepfunc:value", false, 0));
                    ++index;
                }
            }
            return exceptionsSet;
        }
        catch (XPathExpressionException exception) {
            throw new ParametricJsdlException("Error occured during calling XPath query", exception);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new LoopIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LoopIterator
    implements Iterator<String> {
        private int currentValue;

        LoopIterator() {
            this.currentValue = FunctionIntegerLoop.this.start - FunctionIntegerLoop.this.step;
        }

        @Override
        public boolean hasNext() {
            int value = this.currentValue + FunctionIntegerLoop.this.step;
            while (FunctionIntegerLoop.this.exceptions.contains(value) && value < FunctionIntegerLoop.this.end) {
                value += FunctionIntegerLoop.this.step;
            }
            return value <= FunctionIntegerLoop.this.end;
        }

        @Override
        public String next() {
            do {
                this.currentValue += FunctionIntegerLoop.this.step;
            } while (FunctionIntegerLoop.this.exceptions.contains(this.currentValue) && this.currentValue < FunctionIntegerLoop.this.end);
            return Integer.toString(this.currentValue);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

