/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.xpath;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathDocument {
    private static XPath xpathEngine;
    private Document document;
    private Map<String, XPathExpression> expressionsMap;

    public XPathDocument(Document document) {
        this.document = document;
        this.expressionsMap = new HashMap<String, XPathExpression>();
    }

    public NodeList getNodes(Node parentNode, String xpathQuery) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.getExpression(xpathQuery).evaluate(parentNode, XPathConstants.NODESET);
        return nodes;
    }

    public NodeList getNodes(String xpathQuery) throws XPathExpressionException {
        return this.getNodes(this.document.getDocumentElement(), xpathQuery);
    }

    public String getValue(Node parentNode, String xpathQuery) throws XPathExpressionException {
        return this.getExpression(xpathQuery).evaluate(parentNode);
    }

    private XPath getXPathEngine() {
        if (xpathEngine == null) {
            xpathEngine = XPathFactory.newInstance().newXPath();
            xpathEngine.setNamespaceContext(this.getNamespaceContext());
        }
        return xpathEngine;
    }

    private XPathExpression getExpression(String xpathQuery) throws XPathExpressionException {
        XPathExpression expression = this.expressionsMap.get(xpathQuery);
        if (expression == null) {
            expression = this.getXPathEngine().compile(xpathQuery);
            this.expressionsMap.put(xpathQuery, expression);
        }
        return expression;
    }

    private NamespaceContext getNamespaceContext() {
        return new NamespaceContext(){

            public String getNamespaceURI(String prefix) {
                String namespace = "";
                if ("jsdl".equals(prefix)) {
                    namespace = "http://schemas.ggf.org/jsdl/2005/11/jsdl";
                } else if ("jsdl-posix".equals(prefix)) {
                    namespace = "http://schemas.ggf.org/jsdl/2005/11/jsdl-posix";
                } else if ("sweep".equals(prefix)) {
                    namespace = "http://schemas.ogf.org/jsdl/2007/01/jsdl-sweep";
                } else if ("sweepfunc".equals(prefix)) {
                    namespace = "http://schemas.ogf.org/jsdl/2007/01/jsdl-sweep/functions";
                } else if ("xml".equals(prefix)) {
                    namespace = "http://www.w3.org/XML/1998/namespace";
                } else if ("fn".equals(prefix)) {
                    namespace = "http://www.w3.org/2005/xpath-functions";
                }
                return namespace;
            }

            public String getPrefix(String namespaceURI) {
                throw new UnsupportedOperationException();
            }

            public Iterator getPrefixes(String namespaceURI) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        String string = "(null)";
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(this.document), new StreamResult(outputStream));
            string = outputStream.toString();
        }
        catch (TransformerConfigurationException exception) {
            string = exception.getMessage();
        }
        catch (TransformerException exception) {
            string = exception.getMessage();
        }
        return string;
    }

    public Document getDomDocument() {
        return this.document;
    }
}

