/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.ssh.internal;

import eu.geclipse.terminal.ssh.internal.Messages;
import eu.geclipse.terminal.ssh.internal.SSHConnectionComposite;
import eu.geclipse.terminal.ssh.internal.SSHConnectionInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class SSHConnectionWizardPage
extends WizardPage
implements Listener {
    private SSHConnectionComposite composite;
    private String preSelectedHostname = null;

    protected SSHConnectionWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        this.composite = new SSHConnectionComposite(parent, 0, this, this.preSelectedHostname);
        this.setPageComplete(false);
        this.setControl((Control)this.composite);
        IStatus status = this.composite.getStatus();
        this.setPageComplete(status.getSeverity() != 4);
    }

    void setPreselectedHostname(String hostname) {
        this.preSelectedHostname = hostname;
    }

    public String getTitle() {
        return Messages.getString("SSHConnectionWizardPage.ssh");
    }

    public String getDescription() {
        return Messages.getString("SSHConnectionWizardPage.description");
    }

    public void handleEvent(Event event) {
        this.validateInput();
        this.getWizard().getContainer().updateButtons();
    }

    private void validateInput() {
        IStatus status = this.composite.getStatus();
        this.applyToStatusLine(status);
        this.setPageComplete(status.getSeverity() != 4);
    }

    private void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(message);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(message, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(message, 1);
                break;
            }
            default: {
                this.setErrorMessage(message);
                this.setMessage(null);
            }
        }
    }

    SSHConnectionInfo getConnectionInfo() {
        return this.composite.getConnectionInfo();
    }
}

