/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.ssh.internal;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import eu.geclipse.core.IBidirectionalConnection;
import eu.geclipse.core.portforward.ForwardType;
import eu.geclipse.core.portforward.IForward;
import eu.geclipse.core.reporting.ProblemException;
import eu.geclipse.terminal.ITerminalListener;
import eu.geclipse.terminal.ITerminalPage;
import eu.geclipse.terminal.ITerminalView;
import eu.geclipse.terminal.ssh.internal.Activator;
import eu.geclipse.terminal.ssh.internal.Messages;
import eu.geclipse.terminal.ssh.internal.SSHConnectionInfo;
import eu.geclipse.terminal.ssh.internal.SSHWizard;
import eu.geclipse.ui.dialogs.ProblemDialog;
import eu.geclipse.ui.widgets.IDropDownEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshShell
implements IDropDownEntry<ITerminalView>,
ITerminalListener {
    ChannelShell channel;
    ITerminalPage terminal;
    SSHConnectionInfo userInfo;
    private int preConnectCols = -1;
    private int preConnectLines;
    private int preConnectXPix;
    private int preConnectYPix;

    public void windowSizeChanged(int cols, int lines, int xPixels, int yPixels) {
        if (this.channel.isConnected()) {
            this.channel.setPtySize(cols, lines, xPixels, yPixels);
        } else {
            this.preConnectCols = cols;
            this.preConnectLines = lines;
            this.preConnectXPix = xPixels;
            this.preConnectYPix = yPixels;
        }
    }

    public void action(ITerminalView terminalView) {
        SSHWizard sshWizard = new SSHWizard();
        sshWizard.init(terminalView);
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)sshWizard);
        wizardDialog.open();
    }

    public void createTerminal(final ITerminalView terminalView, SSHConnectionInfo sshConnectionInfo, List<IForward> forwards) {
        try {
            IJSchService service = Activator.getDefault().getJSchService();
            if (service == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        ProblemException problemException = new ProblemException("eu.geclipse.terminal.ssh.problem.no_ssh_service", "eu.geclipse.terminal.ssh");
                        ProblemDialog.openProblem(null, (String)Messages.getString("SshShell.sshTerminal"), (String)Messages.getString("SshShell.couldNotGetService"), (Throwable)problemException);
                    }
                });
            } else {
                this.userInfo = sshConnectionInfo;
                final Session session = service.createSession(this.userInfo.getHostname(), this.userInfo.getPort(), this.userInfo.getUsername());
                session.setUserInfo((UserInfo)this.userInfo);
                if (forwards != null) {
                    for (IForward forward : forwards) {
                        if (forward.getType() == ForwardType.LOCAL) {
                            session.setPortForwardingL(forward.getBindPort(), forward.getHostname(), forward.getPort());
                            continue;
                        }
                        session.setPortForwardingR(forward.getBindPort(), forward.getHostname(), forward.getPort());
                    }
                }
                session.connect();
                final IBidirectionalConnection connection = new IBidirectionalConnection(){

                    public void close() {
                        SshShell.this.channel.disconnect();
                        session.disconnect();
                    }

                    public InputStream getInputStream() throws IOException {
                        return SshShell.this.channel.getInputStream();
                    }

                    public OutputStream getOutputStream() throws IOException {
                        return SshShell.this.channel.getOutputStream();
                    }
                };
                this.channel = (ChannelShell)session.openChannel("shell");
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        try {
                            SshShell.this.terminal = terminalView.addTerminal(connection, (ITerminalListener)SshShell.this);
                            SshShell.this.terminal.setTabName(SshShell.this.userInfo.getHostname());
                            SshShell.this.terminal.setDescription(Messages.formatMessage("SshShell.descriptionWithoutWinTitle", SshShell.this.userInfo.getUsername(), SshShell.this.userInfo.getHostname()));
                        }
                        catch (IOException exception) {
                            Activator.logException(exception);
                        }
                    }
                });
                this.channel.connect();
                if (this.preConnectCols != -1) {
                    this.windowSizeChanged(this.preConnectCols, this.preConnectLines, this.preConnectXPix, this.preConnectYPix);
                }
            }
        }
        catch (JSchException exception) {
            if (!this.userInfo.getCanceledPWValue()) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        ProblemException problemException = new ProblemException("eu.geclipse.terminal.ssh.problem.auth_failed", (Throwable)exception, "eu.geclipse.terminal.ssh");
                        ProblemDialog.openProblem(null, (String)Messages.getString("SshShell.sshTerminal"), (String)Messages.getString("SshShell.authFailed"), (Throwable)problemException);
                    }
                });
            }
        }
        catch (Exception exception) {
            Activator.logException(exception);
        }
    }

    public void windowTitleChanged(String windowTitle) {
        this.terminal.setDescription(Messages.formatMessage("SshShell.descriptionWithWinTitle", this.userInfo.getUsername(), this.userInfo.getHostname(), windowTitle));
    }

    public void terminated() {
    }
}

