/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.internal;

import eu.geclipse.core.IBidirectionalConnection;
import eu.geclipse.terminal.ITerminalListener;
import eu.geclipse.terminal.ITerminalPage;
import eu.geclipse.terminal.internal.Activator;
import eu.geclipse.terminal.internal.Messages;
import eu.geclipse.terminal.internal.Terminal;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.themes.IThemeManager;

class TerminalPage
extends Composite
implements ITerminalPage {
    private static final String fgColorThemeEntry = "eu.geclipse.terminal.ForgroundColor";
    private static final String bgColorThemeEntry = "eu.geclipse.terminal.BackgroundColor";
    private static final String fontTextEntry = "eu.geclipse.terminal.TextFont";
    Label descLabel = null;
    CTabItem tabItem;
    private Terminal terminal;
    private IBidirectionalConnection connection;

    TerminalPage(Composite parent, int style, CTabItem cTabItem) {
        super(parent, style);
        this.tabItem = cTabItem;
        this.createPartControl();
    }

    void copy() {
        this.terminal.copy();
    }

    void paste() {
        this.terminal.paste();
    }

    public void setTabName(final String name) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TerminalPage.this.tabItem.setText(name);
            }
        });
    }

    public String getTabName() {
        return this.tabItem.getText();
    }

    public void setDescription(final String desc) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TerminalPage.this.descLabel.setText(desc);
            }
        });
    }

    public String getDescription() {
        return this.descLabel.getText();
    }

    public void setFont(Font font) {
        this.terminal.setFont(font);
    }

    public Font getFont() {
        return this.terminal.getFont();
    }

    void setConnection(IBidirectionalConnection conn) throws IOException {
        this.connection = conn;
        this.terminal.setInputStream(this.connection.getInputStream());
        this.terminal.setOutputStream(this.connection.getOutputStream());
    }

    void addTerminalListener(ITerminalListener termListener) {
        this.terminal.addTerminalListener(termListener);
    }

    void closeConnection() {
        this.connection.close();
    }

    private void createPartControl() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        GridData labelGridData = new GridData();
        labelGridData.horizontalAlignment = 4;
        labelGridData.grabExcessHorizontalSpace = true;
        labelGridData.verticalAlignment = 2;
        this.descLabel = new Label((Composite)this, 0);
        this.descLabel.setText(Messages.getString("TerminalPage.noDescription"));
        this.descLabel.setLayoutData((Object)labelGridData);
        GridData terminalGridData = new GridData();
        terminalGridData.horizontalAlignment = 4;
        terminalGridData.grabExcessHorizontalSpace = true;
        terminalGridData.grabExcessVerticalSpace = true;
        terminalGridData.verticalAlignment = 4;
        IThemeManager themeManager = Activator.getDefault().getWorkbench().getThemeManager();
        Color fgColor = themeManager.getCurrentTheme().getColorRegistry().get(fgColorThemeEntry);
        Color bgColor = themeManager.getCurrentTheme().getColorRegistry().get(bgColorThemeEntry);
        Font font = themeManager.getCurrentTheme().getFontRegistry().get(fontTextEntry);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int historySize = store.getInt("historySize");
        this.terminal = new Terminal(this, 0, fgColor, bgColor, historySize);
        this.terminal.setFont(font);
        this.terminal.setLayoutData(terminalGridData);
        this.tabItem.setText(Messages.getString("TerminalPage.terminal"));
        this.setLayout((Layout)gridLayout);
    }

    Terminal getTerminal() {
        return this.terminal;
    }
}

