/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.internal;

import eu.geclipse.core.IBidirectionalConnection;
import eu.geclipse.terminal.ITerminalListener;
import eu.geclipse.terminal.ITerminalPage;
import eu.geclipse.terminal.ITerminalView;
import eu.geclipse.terminal.internal.Activator;
import eu.geclipse.terminal.internal.NewTerminalDropDownAction;
import eu.geclipse.terminal.internal.SelectionProviderIntermediate;
import eu.geclipse.terminal.internal.TerminalPage;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class TerminalView
extends ViewPart
implements ITerminalView {
    CTabFolder cTabFolder = null;
    SelectionProviderIntermediate selectionProvider;
    private NewTerminalDropDownAction newTerminalAction;

    public void createPartControl(Composite parent) {
        this.makeActions();
        this.contributeToActionBars();
        this.selectionProvider = new SelectionProviderIntermediate();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.cTabFolder = new CTabFolder(parent, 0x800400);
        this.cTabFolder.setLayoutData((Object)gridData);
        this.cTabFolder.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                CTabFolder folder = (CTabFolder)event.widget;
                CTabItem item = folder.getSelection();
                if (item != null && item.getControl() != null) {
                    item.getControl().setFocus();
                }
            }
        });
        this.cTabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                ((TerminalPage)((CTabItem)event.item).getControl()).closeConnection();
            }
        });
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)new Action(){

            public void run() {
                CTabItem item = TerminalView.this.cTabFolder.getSelection();
                if (item != null && item.getControl() != null) {
                    ((TerminalPage)item.getControl()).paste();
                }
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.newTerminalAction);
    }

    private void makeActions() {
        this.newTerminalAction = new NewTerminalDropDownAction(this);
    }

    public void setFocus() {
        this.cTabFolder.setFocus();
    }

    public ITerminalPage addTerminal(IBidirectionalConnection connection, ITerminalListener termListener) throws IOException {
        final CTabItem cTabItem = new CTabItem(this.cTabFolder, 64);
        TerminalPage page = new TerminalPage((Composite)this.cTabFolder, 0, cTabItem);
        page.setConnection(connection);
        page.addTerminalListener(termListener);
        page.addTerminalListener(new ITerminalListener(){

            public void terminated() {
                IPreferenceStore store = Activator.getDefault().getPreferenceStore();
                boolean closeTabs = store.getBoolean("closeTabs");
                if (closeTabs) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            cTabItem.dispose();
                        }
                    });
                }
            }

            public void windowSizeChanged(int cols, int lines, int pixels, int pixels2) {
            }

            public void windowTitleChanged(String windowTitle) {
            }
        });
        cTabItem.setControl((Control)page);
        this.cTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TerminalView.this.selectionProvider.setSelectionProviderDelegate(((TerminalPage)((CTabFolder)event.getSource()).getSelection().getControl()).getTerminal());
            }
        });
        this.cTabFolder.setSelection(cTabItem);
        this.selectionProvider.setSelectionProviderDelegate(page.getTerminal());
        return page;
    }
}

