/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.debug.actions;

import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.ISourceLocation;
import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.debug.Activator;
import eu.geclipse.traceview.debug.EventBreakpoint;
import java.util.HashMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public abstract class AbstractEventBreakpointAction
extends Action
implements IActionDelegate {
    protected StructuredSelection selection;

    protected ICProject getProject(ITrace trace) {
        ICProject project = null;
        IPath tracePath = trace.getPath();
        boolean workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().isPrefixOf(tracePath);
        if (workspace) {
            IPath path = tracePath.removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getLocation().segmentCount());
            String projectName = path.uptoSegment(1).toPortableString();
            String device = path.getDevice();
            if (device != null) {
                projectName = projectName.substring(device.length());
            }
            if (projectName != null && projectName.length() > 0) {
                project = CoreModel.getDefault().getCModel().getCProject(projectName);
            }
        }
        return project;
    }

    protected IResource getResource(ICProject project, String sourceHandle) throws CModelException {
        ISourceRoot[] roots;
        String source = new Path(sourceHandle).lastSegment();
        IResource resource = null;
        ISourceRoot[] iSourceRootArray = roots = project.getSourceRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            ITranslationUnit[] units;
            ISourceRoot root = iSourceRootArray[n2];
            ITranslationUnit[] iTranslationUnitArray = units = root.getTranslationUnits();
            int n3 = units.length;
            int n4 = 0;
            while (n4 < n3) {
                ITranslationUnit unit = iTranslationUnitArray[n4];
                if (source.equals(unit.getResource().getName())) {
                    resource = unit.getResource();
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        return resource;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof StructuredSelection ? (StructuredSelection)selection : StructuredSelection.EMPTY;
    }

    protected boolean existing(IEvent event, ICProject project) {
        boolean existing = false;
        if (event instanceof ISourceLocation) {
            ISourceLocation sourceLocation = (ISourceLocation)event;
            String sourceHandle = project.getProject().getFile(sourceLocation.getSourceFilename()).getLocation().toOSString();
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
            int i = 0;
            while (i < breakpoints.length && !existing) {
                if (breakpoints[i] instanceof EventBreakpoint) {
                    EventBreakpoint eventBreakPoint = (EventBreakpoint)breakpoints[i];
                    try {
                        if (eventBreakPoint.getLineNumber() == sourceLocation.getSourceLineNumber() && eventBreakPoint.getSourceHandle().equals(sourceHandle) && eventBreakPoint.getProcess() == event.getProcessId()) {
                            if (eventBreakPoint.containtsEvent(event)) {
                                eventBreakPoint.removeEvent(event);
                            } else {
                                eventBreakPoint.addEvent(event);
                            }
                            existing = true;
                        }
                    }
                    catch (CoreException coreException) {
                        Activator.logException((Exception)((Object)coreException));
                    }
                }
                ++i;
            }
        }
        return existing;
    }

    protected EventBreakpoint createEventBreakpoint(IEvent event) throws CoreException {
        EventBreakpoint eventBreakpoint = null;
        if (event instanceof ISourceLocation) {
            boolean enabled = true;
            boolean register = false;
            IResource resource = null;
            ISourceLocation sourceLocation = (ISourceLocation)event;
            String condition = "";
            String sourceHandle = "";
            int lineNumber = sourceLocation.getSourceLineNumber();
            int ignoreCount = sourceLocation.getOccurrenceCount();
            ICProject project = this.getProject(event.getProcess().getTrace());
            if (project != null) {
                sourceHandle = project.getProject().getFile(sourceLocation.getSourceFilename()).getLocation().toOSString();
                resource = this.getResource(project, sourceLocation.getSourceFilename());
                if (resource != null) {
                    if (!this.existing(event, project)) {
                        HashMap<String, Object> attributes = new HashMap<String, Object>(10);
                        attributes.put("org.eclipse.debug.core.id", CDebugCorePlugin.getUniqueIdentifier());
                        attributes.put("lineNumber", lineNumber);
                        attributes.put("org.eclipse.debug.core.enabled", enabled);
                        attributes.put("org.eclipse.cdt.debug.core.ignoreCount", ignoreCount);
                        attributes.put("org.eclipse.cdt.debug.core.condition", condition);
                        attributes.put("org.eclipse.cdt.debug.core.sourceHandle", sourceHandle);
                        attributes.put("Process", event.getProcessId());
                        eventBreakpoint = new EventBreakpoint(resource, attributes, register);
                        eventBreakpoint.addEvent(event);
                    }
                } else {
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Cannot find source file.", (IStatus)new Status(4, "eu.geclipse.traceview.debug", "The project does not contain the source file."));
                }
            } else {
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Cannot find source file.", (IStatus)new Status(4, "eu.geclipse.traceview.debug", "The trace must be located in a project of the workspace."));
            }
        }
        return eventBreakpoint;
    }
}

