/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.debug.actions;

import eu.geclipse.traceview.EventType;
import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.ITraceView;
import eu.geclipse.traceview.IVectorEvent;
import eu.geclipse.traceview.debug.Activator;
import eu.geclipse.traceview.debug.EventBreakpoint;
import eu.geclipse.traceview.debug.actions.AbstractEventBreakpointAction;
import eu.geclipse.traceview.utils.VectorEventComparator;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class GlobalBreakpointAction
extends AbstractEventBreakpointAction {
    private int[] first;
    private int[] last;

    public void run(IAction action) {
        Object selectedObject = this.selection.getFirstElement();
        if (selectedObject instanceof IEvent) {
            IEvent event = (IEvent)selectedObject;
            if (event.getType() == EventType.RECV) {
                event = event.getPartnerEvent();
            }
            ITrace trace = event.getProcess().getTrace();
            boolean valid = this.createSet(event);
            if (!valid) {
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Cannot set global breakpoint", (String)"Please select a different event.", (IStatus)new Status(1, "eu.geclipse.traceview.debug", "There is no global breakpoint for this event."));
            } else {
                ArrayList<EventBreakpoint> eventBreakpoints = new ArrayList<EventBreakpoint>();
                try {
                    int i = 0;
                    while (i < trace.getNumberOfProcesses()) {
                        if (this.last[i] != -1 && this.last[i] <= trace.getProcess(i).getMaximumLogicalClock()) {
                            EventBreakpoint eventBreakpoint = this.createEventBreakpoint(trace.getProcess(i).getEventByLogicalClock(this.last[i]));
                            eventBreakpoints.add(eventBreakpoint);
                        }
                        ++i;
                    }
                    DebugPlugin.getDefault().getBreakpointManager().addBreakpoints((IBreakpoint[])eventBreakpoints.toArray(new EventBreakpoint[0]));
                }
                catch (IndexOutOfBoundsException exception) {
                    Activator.logException(exception);
                }
                catch (CoreException exception) {
                    Activator.logException((Exception)((Object)exception));
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            ITraceView traceView = (ITraceView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.geclipse.traceview.views.TraceView");
                            traceView.redraw();
                        }
                        catch (PartInitException partInitException) {
                            Activator.logException((Exception)((Object)partInitException));
                        }
                    }
                });
            }
        }
    }

    private boolean createSet(IEvent event) {
        IEvent e;
        ITrace trace = event.getProcess().getTrace();
        this.last = new int[trace.getNumberOfProcesses()];
        this.first = new int[trace.getNumberOfProcesses()];
        IVectorEvent vectorEvent = (IVectorEvent)event;
        VectorEventComparator comparator = new VectorEventComparator();
        IVectorEvent vectorEvent2 = null;
        int i = 0;
        while (i < trace.getNumberOfProcesses()) {
            if (i != event.getProcessId()) {
                this.first[i] = vectorEvent.getLogicalClock();
                if (trace.getProcess(i).getMaximumLogicalClock() < this.first[i]) {
                    this.first[i] = trace.getProcess(i).getMaximumLogicalClock();
                }
                if (comparator.compare(vectorEvent2 = (IVectorEvent)trace.getProcess(i).getEventByLogicalClock(this.first[i]), vectorEvent) < 0) {
                    do {
                        int n = i;
                        this.first[n] = this.first[n] + 1;
                    } while ((vectorEvent2 = (IVectorEvent)trace.getProcess(i).getEventByLogicalClock(this.first[i])) != null && comparator.compare(vectorEvent2, vectorEvent) < 0);
                } else if (comparator.compare(vectorEvent2, vectorEvent) >= 0) {
                    do {
                        int n = i;
                        this.first[n] = this.first[n] - 1;
                        vectorEvent2 = (IVectorEvent)trace.getProcess(i).getEventByLogicalClock(this.first[i]);
                    } while (this.first[i] > -1 && vectorEvent2 != null && comparator.compare(vectorEvent2, vectorEvent) >= 0);
                    int n = i;
                    this.first[n] = this.first[n] + 1;
                }
                this.last[i] = vectorEvent.getLogicalClock();
                if (trace.getProcess(i).getMaximumLogicalClock() < this.last[i]) {
                    this.last[i] = trace.getProcess(i).getMaximumLogicalClock();
                }
                if (comparator.compare(vectorEvent2 = (IVectorEvent)trace.getProcess(i).getEventByLogicalClock(this.last[i]), vectorEvent) <= 0) {
                    do {
                        int n = i;
                        this.last[n] = this.last[n] + 1;
                    } while ((vectorEvent2 = (IVectorEvent)trace.getProcess(i).getEventByLogicalClock(this.last[i])) != null && comparator.compare(vectorEvent2, vectorEvent) <= 0);
                } else if (comparator.compare(vectorEvent2, vectorEvent) > 0) {
                    do {
                        int n = i;
                        this.last[n] = this.last[n] - 1;
                        vectorEvent2 = (IVectorEvent)trace.getProcess(i).getEventByLogicalClock(this.last[i]);
                    } while (this.last[i] > -1 && vectorEvent2 != null && comparator.compare(vectorEvent2, vectorEvent) > 0);
                    int n = i;
                    this.last[n] = this.last[n] + 1;
                }
            } else {
                this.first[i] = event.getLogicalClock();
                this.last[i] = event.getLogicalClock();
            }
            ++i;
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            int i2 = 0;
            while (i2 < trace.getNumberOfProcesses()) {
                int start = this.first[i2];
                while (start <= this.last[i2] && !changed) {
                    e = trace.getProcess(i2).getEventByLogicalClock(start);
                    if (e != null && e.getPartnerLogicalClock() > this.last[e.getPartnerProcessId()] && start != this.last[i2]) {
                        this.last[i2] = start;
                        changed = true;
                    }
                    ++start;
                }
                ++i2;
            }
        }
        boolean valid = true;
        int i3 = 0;
        while (i3 < trace.getNumberOfProcesses()) {
            if (this.first[i3] != 0 && (e = trace.getProcess(i3).getEventByLogicalClock(this.first[i3] - 1)).getPartnerLogicalClock() > this.last[e.getPartnerProcessId()]) {
                valid = false;
                break;
            }
            int j = this.first[i3];
            while (j < this.last[i3]) {
                IEvent e2 = trace.getProcess(i3).getEventByLogicalClock(j);
                if (e2.getPartnerLogicalClock() > this.last[e2.getPartnerProcessId()]) {
                    valid = false;
                    break;
                }
                ++j;
            }
            ++i3;
        }
        return valid;
    }
}

