/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.nope.tracereader;

import eu.geclipse.traceview.EventType;
import eu.geclipse.traceview.IEvent;
import eu.geclipse.traceview.ILamportEvent;
import eu.geclipse.traceview.IPhysicalEvent;
import eu.geclipse.traceview.IProcess;
import eu.geclipse.traceview.ISourceLocation;
import eu.geclipse.traceview.nope.tracereader.EventSubtype;
import eu.geclipse.traceview.nope.tracereader.Process;
import eu.geclipse.traceview.utils.AbstractEvent;
import eu.geclipse.traceview.utils.ILamportEventClockSetter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Event
extends AbstractEvent
implements ILamportEvent,
IPhysicalEvent,
ISourceLocation,
ILamportEventClockSetter {
    public static final String PROP_SUBTYPE = "Event.SubType";
    public static final String PROP_BLOCKING = "Event.Blocking";
    public static final String PROP_SUPPOSED_PARTNER_PROCESS = "Event.SupposedPartnerProcess";
    public static final String PROP_ACCEPTED_MESSAGE_TYPE = "Event.AcceptedMessageType";
    public static final String PROP_SUPPOSED_MESSAGE_TYPE = "Event.SupposedMessageType";
    public static final String PROP_ACCEPTED_MESSAGE_LENGTH = "Event.AcceptedMessageLength";
    public static final String PROP_SUPPOSED_MESSAGE_LENGTH = "Event.SupposedMessageLength";
    public static final String PROP_SOURCE_IGNORE_COUNT = "Event.IgnoreCount";
    private static IPropertyDescriptor[] descriptors;
    private static final int typeOffset = 0;
    private static final int blockingOffset = 1;
    private static final int subTypeOffset = 2;
    private static final int acceptedMessageTypeOffset = 3;
    private static final int supposedMessageTypeOffset = 4;
    private static final int acceptedMessageLengthOffset = 5;
    private static final int supposedMessageLengthOffset = 6;
    private static final int acceptedPartnerProcessOffset = 7;
    private static final int supposedPartnerProcessOffset = 8;
    private static final int partnerLogicalClockOffset = 9;
    private static final int lamportClockOffset = 10;
    private static final int partnerLamportClockOffset = 11;
    private static final int sourceFilenameIndexOffset = 12;
    private static final int sourceLineNrOffset = 13;
    private static final int ignoreCountOffset = 14;
    private static final int timeStartOffset = 15;
    private static final int timeStopOffset = 16;
    protected final int logicalClock;
    protected final Process process;

    public Event(int logicalClock, Process process) {
        this.logicalClock = logicalClock;
        this.process = process;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (descriptors == null) {
            descriptors = this.buildPropertyDescriptors();
        }
        return descriptors;
    }

    protected IPropertyDescriptor[] buildPropertyDescriptors() {
        IPropertyDescriptor[] descriptors1 = super.getPropertyDescriptors();
        IPropertyDescriptor[] descriptors2 = new IPropertyDescriptor[]{new PropertyDescriptor((Object)PROP_SUBTYPE, "Message Subtype"), new PropertyDescriptor((Object)PROP_BLOCKING, "Blocking"), new PropertyDescriptor((Object)PROP_SUPPOSED_PARTNER_PROCESS, "Supposed Partner Process"), new PropertyDescriptor((Object)PROP_ACCEPTED_MESSAGE_TYPE, "Accepted Message Type"), new PropertyDescriptor((Object)PROP_SUPPOSED_MESSAGE_TYPE, "Supposed Message Type"), new PropertyDescriptor((Object)PROP_ACCEPTED_MESSAGE_LENGTH, "Accepted Message Length"), new PropertyDescriptor((Object)PROP_SUPPOSED_MESSAGE_LENGTH, "Supposed Message Length"), new PropertyDescriptor((Object)PROP_SOURCE_IGNORE_COUNT, "Ignore Count")};
        IPropertyDescriptor[] desc = new IPropertyDescriptor[descriptors1.length + descriptors2.length];
        System.arraycopy(descriptors1, 0, desc, 0, descriptors1.length);
        System.arraycopy(descriptors2, 0, desc, descriptors1.length, descriptors2.length);
        return desc;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public Object getPropertyValue(Object id) {
        Object result = super.getPropertyValue(id);
        if (result == null) {
            if (id.equals(PROP_SUBTYPE)) {
                result = EventSubtype.getCommunicationEventName(this.getSubType());
            } else if (id.equals(PROP_BLOCKING)) {
                result = this.getBlocking();
            } else if (id.equals(PROP_SUPPOSED_PARTNER_PROCESS)) {
                result = this.getSupposedPartnerProcess();
            } else if (id.equals(PROP_ACCEPTED_MESSAGE_TYPE)) {
                result = this.getAcceptedMessageType();
            } else if (id.equals(PROP_SUPPOSED_MESSAGE_TYPE)) {
                result = this.getSupposedMessageType();
            } else if (id.equals(PROP_ACCEPTED_MESSAGE_LENGTH)) {
                result = this.getAcceptedMessageLength();
            } else if (id.equals(PROP_SUPPOSED_MESSAGE_LENGTH)) {
                result = this.getSupposedMessageLength();
            } else if (id.equals(PROP_SOURCE_IGNORE_COUNT)) {
                result = this.getIgnoreCount();
            }
        }
        return result;
    }

    public EventType getType() {
        return EventType.getEventType((int)this.process.read(this.logicalClock, 0));
    }

    protected void setType(EventType type) {
        this.process.write(this.logicalClock, 0, type.id);
    }

    public int getProcessId() {
        return this.process.getProcessId();
    }

    public int getPartnerProcessId() {
        return this.process.read(this.logicalClock, 7);
    }

    public int getLogicalClock() {
        return this.logicalClock;
    }

    public int getPartnerLogicalClock() {
        return this.process.read(this.logicalClock, 9);
    }

    protected void setPartnerLogicalClock(int partnerLogicalClock) {
        this.process.write(this.logicalClock, 9, partnerLogicalClock);
    }

    public IEvent getNextEvent() {
        return this.process.getEventByLogicalClock(this.getLogicalClock() + 1);
    }

    public IEvent getPartnerEvent() {
        IEvent result = null;
        if (this.getPartnerProcessId() != -1) {
            result = this.getProcess().getTrace().getProcess(this.getPartnerProcessId()).getEventByLogicalClock(this.getPartnerLogicalClock());
        }
        return result;
    }

    public String getName() {
        return EventSubtype.getCommunicationEventName(this.getSubType());
    }

    public int getLamportClock() {
        return this.process.read(this.logicalClock, 10);
    }

    public void setLamportClock(int lamportClock) {
        this.process.write(this.logicalClock, 10, lamportClock);
    }

    public int getPartnerLamportClock() {
        return this.process.read(this.logicalClock, 11);
    }

    public void setPartnerLamportClock(int partnerLamportClock) {
        this.process.write(this.logicalClock, 11, partnerLamportClock);
    }

    public int getPhysicalStartClock() {
        return this.process.read(this.logicalClock, 15) + this.process.getStartTimeOffset();
    }

    protected void setPhysicalStartClock(int timeStart) {
        this.process.write(this.logicalClock, 15, timeStart);
    }

    public int getPhysicalStopClock() {
        return this.process.read(this.logicalClock, 16) + this.process.getStartTimeOffset();
    }

    protected void setPhysicalStopClock(int timeStop) {
        this.process.write(this.logicalClock, 16, timeStop);
    }

    public int getPartnerPhysicalStartClock() {
        Event partner = (Event)this.getPartnerEvent();
        int result = -1;
        if (partner != null) {
            result = partner.getPhysicalStartClock();
        }
        return result;
    }

    public int getPartnerPhysicalStopClock() {
        Event partner = (Event)this.getPartnerEvent();
        int result = -1;
        if (partner != null) {
            result = partner.getPhysicalStopClock();
        }
        return result;
    }

    public String getSourceFilename() {
        int index = this.process.read(this.logicalClock, 12);
        return this.process.getSourceFilenameForIndex(index);
    }

    public int getSourceLineNumber() {
        return this.process.read(this.logicalClock, 13);
    }

    protected void setSourceLineNumber(int sourceLineNr) {
        this.process.write(this.logicalClock, 13, sourceLineNr);
    }

    public int getSubType() {
        return this.process.read(this.logicalClock, 2);
    }

    protected void setSubType(int subType) {
        this.process.write(this.logicalClock, 2, subType);
    }

    public int getAcceptedPartnerProcess() {
        return this.process.read(this.logicalClock, 7);
    }

    protected void setAcceptedPartnerProcess(int acceptedPartnerProcess) {
        this.process.write(this.logicalClock, 7, acceptedPartnerProcess);
    }

    public int getSupposedPartnerProcess() {
        return this.process.read(this.logicalClock, 8);
    }

    protected void setSupposedPartnerProcess(int supposedPartnerProcess) {
        this.process.write(this.logicalClock, 8, supposedPartnerProcess);
    }

    public int getAcceptedMessageLength() {
        return this.process.read(this.logicalClock, 5);
    }

    protected void setAcceptedMessageLength(int acceptedMessageLength) {
        this.process.write(this.logicalClock, 5, acceptedMessageLength);
    }

    public int getSupposedMessageLength() {
        return this.process.read(this.logicalClock, 6);
    }

    protected void setSupposedMessageLength(int supposedMessageLength) {
        this.process.write(this.logicalClock, 6, supposedMessageLength);
    }

    public int getAcceptedMessageType() {
        return this.process.read(this.logicalClock, 3);
    }

    protected void setAcceptedMessageType(int acceptedMessageType) {
        this.process.write(this.logicalClock, 3, acceptedMessageType);
    }

    public int getSupposedMessageType() {
        return this.process.read(this.logicalClock, 4);
    }

    protected void setSupposedMessageType(int supposedMessageType) {
        this.process.write(this.logicalClock, 4, supposedMessageType);
    }

    public int getBlocking() {
        return this.process.read(this.logicalClock, 1);
    }

    protected void setBlocking(int blocking) {
        this.process.write(this.logicalClock, 1, blocking);
    }

    public int getIgnoreCount() {
        return this.process.read(this.logicalClock, 14);
    }

    protected void setIgnoreCount(int ignoreCount) {
        this.process.write(this.logicalClock, 14, ignoreCount);
    }

    protected void setSourceFilenameIndex(int sourceFilenameIndex) {
        this.process.write(this.logicalClock, 12, sourceFilenameIndex);
    }

    public int getOccurrenceCount() {
        return this.getIgnoreCount();
    }
}

