/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.nope.ui;

import eu.geclipse.traceview.nope.Activator;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class EventSubTypePreferenceEditor {
    IPreferenceStore store;
    String name;
    Button button;
    Combo combo;
    ColorSelector colorSelector;

    public EventSubTypePreferenceEditor(Composite composite, String name) {
        this.name = name;
        this.store = Activator.getDefault().getPreferenceStore();
        this.button = new Button(composite, 32);
        this.button.setText(name);
        this.button.setSelection(this.store.getBoolean(String.valueOf(name) + "enabled"));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EventSubTypePreferenceEditor.this.handleSelectionEvent();
            }
        });
        this.colorSelector = new ColorSelector(composite);
        this.colorSelector.setColorValue(PreferenceConverter.getColor((IPreferenceStore)this.store, (String)(String.valueOf(name) + "color")));
        GridData gd = new GridData();
        gd.widthHint = 32;
        gd.heightHint = 16;
        this.colorSelector.getButton().setLayoutData((Object)gd);
        this.colorSelector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                EventSubTypePreferenceEditor.this.handlePropertyChangeEvent(event);
            }
        });
        this.combo = new Combo(composite, 8);
        int selection = this.store.getInt(String.valueOf(this.name) + "shape");
        switch (selection) {
            case 1: {
                selection = 0;
                break;
            }
            case 2: {
                selection = 1;
                break;
            }
            case 4: {
                selection = 2;
                break;
            }
            case 8: {
                selection = 3;
                break;
            }
            case 16: {
                selection = 4;
                break;
            }
            case 32: {
                selection = 5;
                break;
            }
            default: {
                selection = 0;
            }
        }
        this.combo.setItems(new String[]{"None", "Rectangle", "Circle", "Cross", "Triangle", "Diamond"});
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EventSubTypePreferenceEditor.this.handleSelectionEvent2();
            }
        });
        this.combo.select(selection);
        this.setEnabled(this.button.getSelection());
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (event.getNewValue() instanceof RGB) {
            RGB rgb = (RGB)event.getNewValue();
            PreferenceConverter.setValue((IPreferenceStore)this.store, (String)(String.valueOf(this.name) + "color"), (RGB)rgb);
        }
    }

    protected void handleSelectionEvent() {
        this.store.setValue(String.valueOf(this.name) + "enabled", this.button.getSelection());
        this.setEnabled(this.button.getSelection());
    }

    protected void setEnabled(boolean state) {
        this.colorSelector.setEnabled(state);
        this.combo.setEnabled(state);
    }

    protected void handleSelectionEvent2() {
        int value = 0;
        switch (this.combo.getSelectionIndex()) {
            case 0: {
                value = 1;
                break;
            }
            case 1: {
                value = 2;
                break;
            }
            case 2: {
                value = 4;
                break;
            }
            case 3: {
                value = 8;
                break;
            }
            case 4: {
                value = 16;
                break;
            }
            case 5: {
                value = 32;
                break;
            }
            default: {
                value = -1;
            }
        }
        this.store.setValue(String.valueOf(this.name) + "shape", value);
    }
}

