/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.eventgraph.tracereader.otf;

import eu.geclipse.eventgraph.tracereader.otf.Process;
import eu.geclipse.traceview.EventType;
import eu.geclipse.traceview.ILamportEvent;
import eu.geclipse.traceview.IPhysicalEvent;
import eu.geclipse.traceview.IProcess;
import eu.geclipse.traceview.utils.AbstractEvent;
import eu.geclipse.traceview.utils.IEventPartnerLogicalClockSetter;
import eu.geclipse.traceview.utils.ILamportEventClockSetter;

class Event
extends AbstractEvent
implements ILamportEvent,
IPhysicalEvent,
ILamportEventClockSetter,
IEventPartnerLogicalClockSetter {
    private static final int typeOffset = 0;
    private static final int partnerProcessOffset = 1;
    private static final int partnerLogicalClockOffset = 2;
    private static final int partnerLamportClockOffset = 3;
    private static final int lamportClockOffset = 4;
    private static final int timestampOffset = 5;
    private int logicalClock;
    private Process process;

    Event(int logicalClock, Process process) {
        this.logicalClock = logicalClock;
        this.process = process;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public int getLamportClock() {
        return this.process.read(this.logicalClock, 4);
    }

    public int getLogicalClock() {
        return this.logicalClock;
    }

    protected void setPartnerProcess(int partnerProcess) {
        this.process.write(this.logicalClock, 1, partnerProcess);
    }

    public int getPartnerProcessId() {
        return this.process.read(this.logicalClock, 1);
    }

    public int getPartnerLamportClock() {
        return this.process.read(this.logicalClock, 3);
    }

    public int getPartnerLogicalClock() {
        return this.process.read(this.logicalClock, 2);
    }

    protected void setType(EventType type) {
        this.process.write(this.logicalClock, 0, type.id);
    }

    public EventType getType() {
        return EventType.getEventType((int)this.process.read(this.logicalClock, 0));
    }

    public void setLamportClock(int lamportClock) {
        this.process.write(this.logicalClock, 4, lamportClock);
    }

    public void setPartnerLamportClock(int partnerLamportClock) {
        this.process.write(this.logicalClock, 3, partnerLamportClock);
    }

    public void setPartnerLogicalClock(int partnerLogClock) {
        this.process.write(this.logicalClock, 2, partnerLogClock);
    }

    public int getProcessId() {
        return this.process.getProcessId();
    }

    public int getPhysicalStartClock() {
        return this.process.read(this.logicalClock, 5) + this.process.getStartTimeOffset();
    }

    public int getPhysicalStopClock() {
        return this.process.read(this.logicalClock, 5) + this.process.getStartTimeOffset();
    }

    void setTimestamp(int timestamp) {
        this.process.write(this.logicalClock, 5, timestamp);
    }

    int getSize() {
        return 24;
    }

    public Event getPartnerEvent() {
        return null;
    }

    public Event getNextEvent() {
        Event result = null;
        try {
            this.process.getEventByLogicalClock(this.logicalClock + 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return result;
    }

    public int getPartnerPhysicalStartClock() {
        Event partner = this.getPartnerEvent();
        int result = -1;
        if (partner != null) {
            result = partner.getPhysicalStartClock();
        }
        return result;
    }

    public int getPartnerPhysicalStopClock() {
        Event partner = this.getPartnerEvent();
        int result = -1;
        if (partner != null) {
            result = partner.getPhysicalStopClock();
        }
        return result;
    }
}

