/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.eventgraph.tracereader.otf;

import eu.geclipse.eventgraph.tracereader.otf.OTFStreamReader;
import eu.geclipse.eventgraph.tracereader.otf.OTFUtils;
import eu.geclipse.eventgraph.tracereader.otf.Process;
import eu.geclipse.traceview.ILamportTrace;
import eu.geclipse.traceview.IPhysicalEvent;
import eu.geclipse.traceview.IPhysicalTrace;
import eu.geclipse.traceview.IProcess;
import eu.geclipse.traceview.ITrace;
import eu.geclipse.traceview.ITraceReader;
import eu.geclipse.traceview.utils.AbstractTraceFileCache;
import eu.geclipse.traceview.utils.ClockCalculator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class OTFReader
extends AbstractTraceFileCache
implements IPhysicalTrace,
ILamportTrace,
ITraceReader {
    private BufferedReader input;
    private Map<Integer, List<Integer>> streamMap = new HashMap<Integer, List<Integer>>();
    private Map<Integer, Integer> processIdMap = new HashMap<Integer, Integer>();
    private int numProcs = 0;
    private Process[] processes;
    private String filenameBase;
    private String filename;
    private OTFUtils otfUtils = new OTFUtils();

    public ITrace openTrace(IPath tracePath, IProgressMonitor monitor) throws IOException {
        File file = tracePath.toFile();
        long modTime = file.lastModified();
        this.input = new BufferedReader(new FileReader(file));
        this.filenameBase = file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - 4);
        this.filename = file.getName();
        this.readOTFMapping(monitor);
        String traceOptions = "";
        boolean hasCache = this.openCacheDir(file.getAbsolutePath(), traceOptions, modTime);
        if (!this.readOTFData(hasCache, monitor)) {
            return null;
        }
        this.enableMemoryMap();
        if (!hasCache) {
            if (monitor.isCanceled()) {
                return null;
            }
            monitor.subTask("Calculating logical clocks");
            ClockCalculator.calcPartnerLogicalClocks((ITrace)this);
            if (monitor.isCanceled()) {
                return null;
            }
            monitor.subTask("Calculating lamport clocks");
            ClockCalculator.calcLamportClock((ILamportTrace)this);
            this.saveCacheMetadata();
        }
        return this;
    }

    private void readOTFMapping(IProgressMonitor monitor) throws IOException {
        while ((this.otfUtils.line = this.input.readLine()) != null) {
            this.otfUtils.lineIdx = 0;
            this.parseStreamFileDef();
        }
        this.processes = new Process[this.numProcs];
        int i = 0;
        while (i < this.numProcs) {
            this.processes[i] = new Process(i, this);
            ++i;
        }
    }

    private boolean readOTFData(boolean hasCache, IProgressMonitor monitor) throws IOException {
        if (!hasCache) {
            Set<Integer> streamNrs = this.streamMap.keySet();
            monitor.beginTask("Loading trace", streamNrs.size());
            for (Integer streamNr : streamNrs) {
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.subTask("Loading stream " + streamNr);
                this.loadStream(streamNr);
                monitor.worked(1);
            }
        }
        return true;
    }

    private void loadStream(int nr) throws IOException {
        String eventsFilename = String.valueOf(this.filenameBase) + '.' + Integer.toHexString(nr) + ".events";
        new OTFStreamReader(new File(eventsFilename), this);
    }

    private void parseStreamFileDef() {
        Integer streamNr = this.otfUtils.readNumber();
        this.otfUtils.checkChar(58);
        do {
            Integer processNr = this.otfUtils.readNumber();
            List<Integer> processList = this.streamMap.get(streamNr);
            if (processList == null) {
                processList = new LinkedList<Integer>();
                this.streamMap.put(streamNr, processList);
            }
            processList.add(processNr);
            this.processIdMap.put(processNr, this.numProcs);
            ++this.numProcs;
        } while (this.otfUtils.read() == 44);
    }

    public int getNumberOfProcesses() {
        return this.numProcs;
    }

    public IProcess getProcess(int processId) throws IndexOutOfBoundsException {
        return this.processes[processId];
    }

    int getProcessIdForOTFIndex(int processId) {
        return this.processIdMap.get(processId);
    }

    Process getProcessTraceForOTFIndex(int processId) throws IndexOutOfBoundsException {
        return this.processes[this.getProcessIdForOTFIndex(processId)];
    }

    public int getMaximumLamportClock() {
        int result = 0;
        Process[] processArray = this.processes;
        int n = this.processes.length;
        int n2 = 0;
        while (n2 < n) {
            Process proc = processArray[n2];
            int numEvents = proc.getMaximumLamportClock();
            if (numEvents > result) {
                result = numEvents;
            }
            ++n2;
        }
        return result;
    }

    public String getName() {
        return this.filename;
    }

    public int getMaximumPhysicalClock() {
        int maxTimeStop = 0;
        Process[] processArray = this.processes;
        int n = this.processes.length;
        int n2 = 0;
        while (n2 < n) {
            Process process = processArray[n2];
            if (maxTimeStop < ((IPhysicalEvent)process.getEventByLogicalClock(process.getMaximumLogicalClock())).getPhysicalStopClock()) {
                maxTimeStop = ((IPhysicalEvent)process.getEventByLogicalClock(process.getMaximumLogicalClock())).getPhysicalStopClock();
            }
            ++n2;
        }
        return maxTimeStop;
    }

    public IPath getPath() {
        return null;
    }

    public int getEventSize() {
        return 17;
    }
}

