/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.traceview.internal;

import eu.geclipse.traceview.IProcess;
import eu.geclipse.traceview.internal.AbstractGraphVisualization;
import eu.geclipse.traceview.internal.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraphMouseAdapter
implements MouseListener,
MouseMoveListener {
    protected AbstractGraphVisualization graph;
    private int vRulerSelection;
    private Cursor moveProcCursor;

    protected AbstractGraphMouseAdapter(AbstractGraphVisualization graph) {
        this.graph = graph;
        this.moveProcCursor = new Cursor((Device)this.graph.getDisplay(), 7);
    }

    public void mouseDoubleClick(MouseEvent e) {
        int y;
        int graphHeight = this.graph.getClientArea().height - 30;
        if (e.x > 0 && e.y > 0 && e.x < 30 && e.y < graphHeight && (y = this.getLineNumber(e.y)) != -1) {
            boolean[] hideProcs = this.graph.getHideProcess();
            Set procs = this.graph.getLineToProcessMapping().get(y);
            for (Integer proc : procs) {
                int n = proc;
                hideProcs[n] = hideProcs[n] ^ true;
            }
            this.graph.setHideProcess(hideProcs);
        }
    }

    public void mouseMove(MouseEvent e) {
        if ((e.stateMask & 0x80000) != 0 && this.vRulerSelection != -1) {
            GC rulerGC = new GC((Drawable)this.graph);
            this.graph.getEventGraphPaintListener().drawVRulerWithMovingLine(rulerGC, this.vRulerSelection, e.y);
            rulerGC.dispose();
        } else if ((e.stateMask & 0x80000) == 0) {
            this.updateMouseCursor(e);
        }
    }

    protected void updateMouseCursor(MouseEvent e) {
        int graphHeight = this.graph.getClientArea().height - 30;
        if (e.x > 0 && e.y > 0 && e.x < 30 && e.y < graphHeight && this.getLineNumber(e.y) != -1) {
            this.graph.setCursor(this.moveProcCursor);
        } else {
            this.graph.setCursor(null);
        }
    }

    public void mouseUp(MouseEvent e) {
        this.checkVRuler(e.x, e.y, false);
        this.updateMouseCursor(e);
    }

    public void mouseDown(MouseEvent e) {
        try {
            this.checkVRuler(e.x, e.y, true);
            Object[] objs = this.getObjectsForPosition(e.x, e.y);
            if (objs.length != 0 && (e.button == 1 || e.button == 3)) {
                List<Object> objList = Arrays.asList(objs);
                StructuredSelection selection = null;
                ISelectionProvider selectionProvider = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.geclipse.traceview.views.TraceView").getSite().getSelectionProvider();
                StructuredSelection oldSelection = (StructuredSelection)selectionProvider.getSelection();
                if ((e.stateMask & 0x40000) != 0 && oldSelection != null) {
                    ArrayList<Object> oldSelectionList = new ArrayList<Object>(oldSelection.toList());
                    if (!oldSelectionList.containsAll(objList)) {
                        if (e.button == 1) {
                            Object[] objectArray = objs;
                            int n = objs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object obj = objectArray[n2];
                                if (!oldSelectionList.contains(obj)) {
                                    oldSelectionList.add(obj);
                                }
                                ++n2;
                            }
                            selection = new StructuredSelection(oldSelectionList);
                        }
                    } else {
                        selection = new StructuredSelection(oldSelectionList);
                    }
                }
                if (selection == null) {
                    selection = new StructuredSelection(objList);
                }
                selectionProvider.setSelection(selection);
                this.graph.redraw();
            }
        }
        catch (PartInitException exception) {
            Activator.logException((Exception)((Object)exception));
        }
    }

    protected int getLineNumber(int yPos) {
        return this.getLineNumber(yPos, false);
    }

    protected int getLineNumber(int yPos, boolean areaBelowProcess) {
        int yOffset = this.graph.getEventGraphPaintListener().getYOffset();
        int eventSize = this.graph.getEventGraphPaintListener().getEventSize();
        int vSpace = this.graph.getEventGraphPaintListener().getVSpace();
        int numProcLines = this.graph.getLineToProcessMapping().size();
        int processLine = -1;
        int tmp = yPos + yOffset - eventSize / 2;
        if (areaBelowProcess) {
            processLine = tmp / vSpace;
        } else {
            if (tmp % vSpace <= eventSize / 2) {
                processLine = tmp / vSpace;
            }
            if (vSpace - tmp % vSpace <= eventSize / 2) {
                processLine = tmp / vSpace + 1;
            }
        }
        if (processLine != -1 && (processLine += this.graph.getEventGraphPaintListener().getFromProcessLine()) >= numProcLines) {
            processLine = -1;
        }
        return processLine;
    }

    public void checkVRuler(int xPos, int yPos, boolean clicked) {
        int graphHeight = this.graph.getClientArea().height - 30;
        int y = this.getLineNumber(yPos);
        if (clicked) {
            this.vRulerSelection = -1;
        }
        if (xPos > 0 && yPos > 0 && xPos < 30 && yPos < graphHeight && (clicked || this.vRulerSelection != -1)) {
            if (y != -1) {
                if (clicked) {
                    this.vRulerSelection = y;
                } else {
                    this.graph.mergeProcessLines(this.vRulerSelection, y);
                }
            } else if (!clicked) {
                y = this.getLineNumber(yPos, true);
                if (y < this.vRulerSelection) {
                    if (y + 1 < this.graph.getLineToProcessMapping().size()) {
                        this.graph.moveProcessLine(this.vRulerSelection, y + 1);
                    }
                } else {
                    this.graph.moveProcessLine(this.vRulerSelection, y);
                }
            }
        } else if (!clicked && this.vRulerSelection != -1) {
            this.vRulerSelection = -1;
            this.graph.redraw();
        }
    }

    public Object[] getObjectsForPosition(int xPos, int yPos) {
        LinkedList<Object> objList = new LinkedList<Object>();
        int graphWidth = this.graph.getClientArea().width;
        int graphHeight = this.graph.getClientArea().height - 30;
        int y = this.getLineNumber(yPos);
        if (xPos > 30 && yPos > 0 && xPos < graphWidth && yPos < graphHeight) {
            if (y != -1) {
                for (Integer proc : this.graph.getLineToProcessMapping().get(y)) {
                    Object obj = this.getObjectOnProcess(xPos, proc);
                    if (obj == null) continue;
                    objList.add(obj);
                }
                if (objList.size() == 0) {
                    objList.addAll(this.getProcessesOnLine(y));
                }
            } else {
                objList.add(this.graph.getTrace());
            }
        }
        return objList.toArray();
    }

    public List<IProcess> getProcessesOnLine(int line) {
        LinkedList<IProcess> procList = new LinkedList<IProcess>();
        for (Integer proc : this.graph.getLineToProcessMapping().get(line)) {
            procList.add(this.graph.getTrace().getProcess(proc));
        }
        return procList;
    }

    public abstract Object getObjectOnProcess(int var1, int var2);
}

